/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Reporter;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.swing.datatable.DataTable;

public class PanelExpandDataGrid
extends TitledPanel
implements ActionListener {
    private static final String BUNDLE_NAME = "uibk.mtk.swing.datatable.messages";
    private final int maxRows;
    private final DataTable table;
    private final Reporter reporter;
    private final Component parentComponent;

    public PanelExpandDataGrid(int maxRows, DataTable table, Reporter reporter, Component parentComponent) {
        super(Messages.getString(BUNDLE_NAME, "PanelExpandDataGrid.1"));
        this.initComponents();
        this.maxRows = maxRows;
        this.table = table;
        this.reporter = reporter;
        this.parentComponent = parentComponent;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 120));
        JButton button = new JButton(Messages.getString(BUNDLE_NAME, "PanelExpandDataGrid.2"));
        button.setActionCommand("addRow");
        button.addActionListener(this);
        button.setPreferredSize(new Dimension(140, 23));
        this.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        button = new JButton(Messages.getString(BUNDLE_NAME, "PanelExpandDataGrid.3"));
        button.setActionCommand("removeRow");
        button.addActionListener(this);
        button.setPreferredSize(new Dimension(140, 23));
        this.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.table.getRowCount() < 2 || this.table.getColumnCount() < 2) {
            this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelExpandDataGrid.10"), this.parentComponent);
            return;
        }
        if (e.getActionCommand().equals("addRow")) {
            if (this.table.getRowCount() + 1 > this.maxRows) {
                this.reporter.reportError(String.valueOf(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.12")) + this.maxRows + Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.13"), this.parentComponent);
                return;
            }
            this.table.add(new double[this.table.getColumnCount() - 1]);
            this.table.revalidate();
        } else if (e.getActionCommand().equals("removeRow")) {
            if (this.table.getRowCount() - 1 < 2) {
                this.reporter.reportError(Messages.getString(BUNDLE_NAME, "PanelCreateDataGrid.11"), this.parentComponent);
                return;
            }
            this.table.removeLastRow();
            this.table.revalidate();
        }
    }
}

