/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import java.util.Hashtable;
import java.util.Vector;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Sequence;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Parser;
import uibk.mtk.parser.realparser.Variable;

public class SequenceParser {
    private static final String BUNDLE_NAME = "uibk.mtk.math.parsing.messages";
    private int depth;
    Parser parser = new Parser();

    private String trim(String input) {
        String str = "";
        int n = input.length();
        int i = 0;
        while (i < n) {
            if (!Character.isWhitespace(input.charAt(i))) {
                str = String.valueOf(str) + input.charAt(i);
            }
            ++i;
        }
        return str;
    }

    private Vector registerRecVariables(String input, String var) throws Exception {
        int pos = 0;
        int sequencedepth = 0;
        Vector<Integer> rekindices = new Vector<Integer>();
        while (pos < input.length() - 1) {
            int start = input.indexOf("a(" + var + "-", pos);
            if (start < 0) break;
            if (start < 0) continue;
            int end = input.indexOf(")", start + 3);
            String p = input.substring(start + 4, end);
            try {
                Integer index = new Integer(Integer.valueOf(p));
                if (!rekindices.contains(index)) {
                    rekindices.add(index);
                }
                if (index > sequencedepth) {
                    sequencedepth = index;
                }
            }
            catch (NumberFormatException nfe) {
                throw new InputException(Messages.getString(BUNDLE_NAME, "SequenceParser.4"));
            }
            pos = end;
        }
        this.depth = sequencedepth;
        return rekindices;
    }

    public Sequence parse(String input, String var) throws Exception {
        if (input == null) {
            throw new Exception(Messages.getString(BUNDLE_NAME, "SequenceParser.5"));
        }
        input = this.trim(input);
        this.parser.clearVariables();
        Hashtable<String, Variable> variables = new Hashtable<String, Variable>();
        Vector rekindices = this.registerRecVariables(input, var);
        int i = 0;
        while (i < rekindices.size()) {
            Integer index = (Integer)rekindices.elementAt(i);
            String varName = "a(" + var + "-" + index.toString() + ")";
            Variable v = new Variable(varName);
            variables.put(varName, v);
            this.parser.addVariable(v);
            ++i;
        }
        Variable n = new Variable(var);
        variables.put(var, n);
        this.parser.addVariable(n);
        Expr formula = this.parser.parseString(input);
        return new Sequence(variables, formula, rekindices, this.depth);
    }
}

