/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.ParsingResult;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Parser;
import uibk.mtk.parser.realparser.SyntaxException;
import uibk.mtk.parser.realparser.Variable;

final class RealExpressionParser {
    private static Parser parser = new Parser();
    private static final String BUNDLE_NAME = "uibk.mtk.math.parsing.messages";

    private RealExpressionParser() {
    }

    public static synchronized ParsingResult parseFunction(String[] strVars, String[] strFunctions) throws InputException {
        if (strVars == null || strVars.length == 0 || strFunctions == null || strFunctions.length == 0) {
            throw new IllegalArgumentException();
        }
        parser.clearVariables();
        int n = strVars.length;
        Variable[] variables = new Variable[n];
        int i = 0;
        while (i < n) {
            Variable v;
            variables[i] = v = new Variable(strVars[i]);
            parser.addVariable(v);
            ++i;
        }
        int m = strFunctions.length;
        Expr[] functions = new Expr[m];
        int i2 = 0;
        while (i2 < m) {
            if (strFunctions[i2] == null || strFunctions[i2].equals("")) {
                if (m > 1) {
                    throw new InputException(String.valueOf(i2 + 1) + Messages.getString(BUNDLE_NAME, "RealExpressionParser.1"));
                }
                throw new InputException(Messages.getString(BUNDLE_NAME, "RealExpressionParser.2"));
            }
            try {
                functions[i2] = parser.parseString(strFunctions[i2]);
            }
            catch (SyntaxException e) {
                throw new InputException(e.getMessage());
            }
            ++i2;
        }
        return new ParsingResult(variables, functions);
    }
}

