/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.math.parsing.ParsingResult;
import uibk.mtk.math.parsing.RealExpressionParser;

final class ParametricCurveParser {
    private static final String BUNDLE_NAME = "uibk.mtk.math.parsing.messages";

    private ParametricCurveParser() {
    }

    public static synchronized ParsingResult parseParametricCurve(char var, String strcurve, int dim) throws Exception {
        if (dim < 2) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "ParametricCurveParser.0"));
        }
        if (strcurve == null || strcurve.equals("")) {
            throw new InputException("Keine parametrische Kurve definiert");
        }
        String str = strcurve.trim();
        int posBracketOpen = str.indexOf("(");
        int posBracketClose = str.lastIndexOf(")");
        if (posBracketOpen == -1) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ParametricCurveParser.5"));
        }
        if (posBracketClose == -1 || posBracketClose != str.length() - 1) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ParametricCurveParser.6"));
        }
        int unmatchedbracket = 0;
        int pos = str.length() - 1;
        int leftbracketPos = 0;
        while (pos >= 0) {
            if (str.charAt(pos) == ')') {
                ++unmatchedbracket;
            }
            if (str.charAt(pos) == '(' && --unmatchedbracket == 0) {
                leftbracketPos = pos;
                break;
            }
            --pos;
        }
        if (unmatchedbracket != 0) {
            throw new Exception(Messages.getString(BUNDLE_NAME, "ParametricCurveParser.7"));
        }
        String strcommon = str.substring(0, leftbracketPos);
        String[] components = Misc.split(str.substring(leftbracketPos + 1, str.length() - 1), ",");
        if (components == null) {
            throw new InputException(Messages.getString(BUNDLE_NAME, "ParametricCurveParser.9"));
        }
        if (components.length != dim) {
            throw new InputException(String.valueOf(Messages.getString(BUNDLE_NAME, "ParametricCurveParser.10")) + dim + Messages.getString(BUNDLE_NAME, "ParametricCurveParser.11"));
        }
        if (!strcommon.equals("") && !strcommon.endsWith("*")) {
            strcommon = String.valueOf(strcommon) + "*";
        }
        int i = 0;
        while (i < dim) {
            components[i] = String.valueOf(strcommon) + components[i];
            ++i;
        }
        return RealExpressionParser.parseFunction(new String[]{String.valueOf(var)}, components);
    }
}

