/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.functions;

import uibk.mtk.geom.geom3d.Punkt3D;
import uibk.mtk.geom.geom3d.Vector3D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.functions.ParametricCurve3D;
import uibk.mtk.math.functions.ParsedFunction;
import uibk.mtk.math.functions.SingularPointException;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Variable;

public class ParsedParametricCurve3D
extends ParsedFunction
implements ParametricCurve3D {
    private static final String BUNDLE_NAME = "uibk.mtk.math.functions.messages";

    public ParsedParametricCurve3D(Variable[] variables, Expr[] functions) {
        super(variables, functions);
    }

    public Vector3D velocityVector(double t) throws Exception {
        if (this.n != 1) {
            throw new IllegalArgumentException(Messages.getString(BUNDLE_NAME, "ParsedParametricCurve3D.0"));
        }
        double[][] jacob = this.getJacobian(new double[]{t});
        double x = jacob[0][0];
        double y = jacob[1][0];
        double z = jacob[2][0];
        if (this.checkdiff) {
            double esterror = this.getEstimatedErrorFirstDeriv(t);
            if (Math.sqrt(x * x + y * y + z * z) < esterror / 100.0) {
                throw new SingularPointException(Messages.getString(BUNDLE_NAME, "ParsedParametricCurve3D.1"));
            }
        }
        return new Vector3D(x, y, z);
    }

    public Vector3D accelerationVector(double t) throws Exception {
        double[] a = super.getDerivation2(new double[]{t});
        return new Vector3D(a[0], a[1], a[2]);
    }

    public Punkt3D calcPoint(double param) {
        double[] v = this.getValue(new double[]{param});
        return new Punkt3D(v[0], v[1], v[2]);
    }
}

