/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussNewton;

import Jama.Matrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import uibk.applets.gaussNewton.InteractionControl;
import uibk.applets.gaussNewton.PanelCommand;
import uibk.applets.gaussNewton.RegressionsException;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PanelModel
extends MPanel {
    private final TextField textPar = new TextField(15);
    private final TextField textInitialPoint = new TextField(15);

    public PanelModel() {
        this.setMaximumSize(new Dimension(1000, 270));
        this.setLayout(new GridBagLayout());
    }

    public void initComponents(PanelCommand command, InteractionControl control) {
        this.initFunctionImpl();
        this.initFunction();
        this.initButton(command, control);
    }

    public void clear() {
        this.textPar.setText("");
        this.textInitialPoint.setText("");
        this.clearImpl();
    }

    public abstract void clearImpl();

    private void initFunction() {
        this.add((Component)new JLabel(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.12")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.textPar, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.14")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.textInitialPoint, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    private void initButton(final PanelCommand command, InteractionControl control) {
        JButton getData = new JButton(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.13"));
        getData.setActionCommand("getData");
        getData.addActionListener(control);
        getData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                command.enableButtons(true);
            }
        });
        this.add((Component)getData, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
    }

    protected abstract void initFunctionImpl();

    public abstract String[] getFunction();

    public abstract void setFunction(String var1);

    public Vector<String> getParameter() {
        Scanner s = new Scanner(this.textPar.getText()).useDelimiter(",");
        Vector<String> ret = new Vector<String>();
        while (s.hasNext()) {
            ret.add(s.next().trim());
        }
        return ret;
    }

    public void setParameter(String parameter) {
        this.textPar.setText(parameter);
    }

    public abstract int getDependentVar(int var1) throws RegressionsException;

    public void setInitialPoint(double[] initPoint) {
        String s = "";
        int i = 0;
        while (i < initPoint.length) {
            s = String.valueOf(s) + initPoint[i];
            if (i != initPoint.length - 1) {
                s = String.valueOf(s) + ",";
            }
            ++i;
        }
        this.textInitialPoint.setText(s);
    }

    public Matrix getInitialPoint(int anzVars) throws RegressionsException {
        double[][] ret = new double[1][anzVars];
        try {
            Scanner s = new Scanner(this.textInitialPoint.getText()).useDelimiter(",");
            int i = 0;
            while (i < anzVars) {
                if (!s.hasNext()) {
                    throw new RegressionsException(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.21"), ExceptionLevel.ERROR);
                }
                ret[0][i] = new Double(s.next());
                ++i;
            }
            if (s.hasNextDouble()) {
                throw new RegressionsException(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.21"), ExceptionLevel.ERROR);
            }
        }
        catch (Exception e) {
            throw new RegressionsException(Messages.getString("uibk.applets.gaussNewton.messages", "PanelInput.22"), ExceptionLevel.ERROR);
        }
        return new Matrix(ret);
    }

    public abstract void setDependentVar(String var1);
}

