/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussNewton;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import uibk.applets.gaussNewton.AppletGaussNewton;
import uibk.applets.gaussNewton.InteractionControl;
import uibk.applets.gaussNewton.PanelFunction;
import uibk.applets.gaussNewton.PanelOption;
import uibk.applets.gaussNewton.Report;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.appletbase.RunType;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.datatable.DataTable;
import uibk.mtk.swing.datatable.PanelCreateDataGrid;
import uibk.mtk.swing.datatable.PanelExpandDataGrid;
import uibk.mtk.swing.datatable.PannelFileIO;

class PanelCommand
extends MPanel {
    private final Vector<MPanel> button = new Vector();

    public PanelCommand(AppletGaussNewton main, DataTable table, Report report) {
        PanelOption panelOption = new PanelOption(main);
        InteractionControl control = new InteractionControl(main, table, report, panelOption);
        PanelFunction panelFunction = new PanelFunction(this, table, control, this.createPanelButtons(control), panelOption);
        control.setPanelInput(panelFunction);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BoxLayout(this, 1));
        JTabbedPane tabbedpane = new JTabbedPane();
        MPanel panelData = this.initPanelData(main, table, report, control, panelOption, panelFunction);
        tabbedpane.addTab(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.14"), null, panelFunction, Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.15"));
        tabbedpane.addTab(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.10"), null, panelData, Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.11"));
        tabbedpane.addTab(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.12"), null, this.initPanelPlot(main, control, panelOption), Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.13"));
        this.add(tabbedpane);
        this.enableButtons(false);
    }

    private MPanel initPanelData(AppletGaussNewton main, DataTable table, Report report, InteractionControl control, PanelOption panelOption, PanelFunction panelFunction) {
        MPanel panel = new MPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setMaximumSize(new Dimension(2000, 500));
        panel.add(new PanelCreateDataGrid(100, 20, table, main.getReporter(), main));
        panel.add(new PanelExpandDataGrid(100, table, main.getReporter(), main));
        if (main.getType() == RunType.JavaApplication) {
            panel.add(new PannelFileIO(table, main.getReporter(), main));
        }
        panel.add(panelFunction);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private MPanel initPanelPlot(AppletGaussNewton main, InteractionControl control, PanelOption panelOption) {
        MPanel panel = new MPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(panelOption);
        panel.add(Box.createVerticalGlue());
        panel.add(this.createPanelButtons(control));
        return panel;
    }

    private MPanel createPanelButtons(InteractionControl control) {
        MPanel panelbuttons = new MPanel();
        panelbuttons.setLayout(new GridLayout(1, 2));
        panelbuttons.setMaximumSize(new Dimension(2000, 100));
        panelbuttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton step = new JButton(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.0"));
        step.setActionCommand("step");
        step.addActionListener(control);
        step.setToolTipText(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.1"));
        panelbuttons.add(step);
        JButton solve = new JButton(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.2"));
        solve.setActionCommand("solve");
        solve.addActionListener(control);
        solve.setToolTipText(Messages.getString("uibk.applets.gaussNewton.messages", "PanelCommand.3"));
        panelbuttons.add(solve);
        this.button.add(panelbuttons);
        return panelbuttons;
    }

    public void enableButtons(boolean b) {
        for (MPanel m : this.button) {
            m.setEnabled(b);
        }
    }
}

