/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.gaussNewton;

import Jama.Matrix;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import uibk.applets.gaussNewton.AppletGaussNewton;
import uibk.applets.gaussNewton.Model;
import uibk.applets.gaussNewton.PanelFunction;
import uibk.applets.gaussNewton.PanelModel;
import uibk.applets.gaussNewton.PanelOption;
import uibk.applets.gaussNewton.Report;
import uibk.mtk.swing.datatable.DataTable;

public class InteractionControl
implements ActionListener {
    private final AppletGaussNewton main;
    private PanelFunction panelFunction;
    private final DataTable table;
    private final Report report;
    private final Model model = new Model();
    private final PanelOption panelOption;
    private Matrix t;
    private boolean armijoCondSatisfied = true;
    private int it = 0;

    InteractionControl(AppletGaussNewton main, DataTable table, Report report, PanelOption panelOption) {
        this.main = main;
        this.table = table;
        this.report = report;
        this.panelOption = panelOption;
    }

    public void setPanelInput(PanelFunction panelFunction) {
        this.panelFunction = panelFunction;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            if (ev.getActionCommand().equals("getData")) {
                this.readData(this.panelFunction.getVisibleModel());
            } else if (ev.getActionCommand().equals("step")) {
                this.step();
            } else if (ev.getActionCommand().equals("solve")) {
                this.solve();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.main.getReporter().reportException(null, e, this.main);
        }
    }

    public void readData(PanelModel panelFunction) throws Exception {
        this.t = this.model.readData(this.table, panelFunction);
        this.it = 0;
        this.panelOption.clearPlot(this.model, this.t);
        this.panelOption.set(this.it, this.model.getValue(this.t), null, this.t);
        this.armijoCondSatisfied = true;
        this.report.clear();
    }

    private Matrix solve() throws Exception {
        Matrix dx;
        int i = 0;
        do {
            dx = this.step();
        } while (++i < this.panelOption.getMaxStep() && dx.norm2() > this.panelOption.getTol() && this.armijoCondSatisfied);
        if (!this.armijoCondSatisfied) {
            this.report.println("Armijo-Goldstein Bedingung nicht erf\u00fcllt");
        }
        return null;
    }

    private Matrix step() throws Exception {
        Matrix fs = new Matrix(this.model.getJacobian(this.t.getArray()[0]));
        Matrix f = this.model.getValue(this.t);
        Matrix dx = fs.solve(f.transpose());
        ++this.it;
        this.report.println("----------------it: " + this.it + "---------------");
        if (this.panelOption.isLineSearch()) {
            double alpha = 1.0E-4;
            double lambda = 1.0;
            double lambdaprev = 0.0;
            int retcode = 2;
            double fNorm = 0.0;
            double fprevNorm = 0.0;
            double foldNorm = f.norm2();
            double initslope = -fs.transpose().times(f.transpose()).transpose().times(dx).getArray()[0][0];
            this.report.println("foldNorm + alpha * lambda * initslope: " + (foldNorm + alpha * lambda * initslope));
            while (retcode >= 2 && this.armijoCondSatisfied) {
                double lambdatemp;
                Matrix tempT = this.t.minus(dx.transpose().times(lambda));
                fNorm = this.model.getValue(tempT).norm2();
                this.report.println("fNorm: " + fNorm);
                if (fNorm <= foldNorm + alpha * lambda * initslope) {
                    retcode = 0;
                    this.t = tempT;
                    f = this.model.getValue(this.t);
                    break;
                }
                if (lambda < 1.0E-5) {
                    retcode = 1;
                    break;
                }
                if (lambda == 1.0) {
                    lambdatemp = -initslope / (2.0 * (fNorm - foldNorm + initslope));
                } else {
                    double a = 1.0 / (lambda - lambdaprev) * ((fNorm - foldNorm - lambda * initslope) / (lambda * lambda) - (fprevNorm - foldNorm - lambdaprev * initslope) / (lambdaprev * lambdaprev));
                    double b = 1.0 / (lambda - lambdaprev) * (lambda / (lambdaprev * lambdaprev) * (fprevNorm - foldNorm - lambdaprev * initslope) - lambdaprev / (lambda * lambda) * (fNorm - foldNorm - lambda * initslope));
                    double disc = b * b - 3.0 * a * initslope;
                    lambdatemp = a == 0.0 ? -initslope / (2.0 * b) : (-b + Math.sqrt(disc)) / (3.0 * a);
                }
                lambdaprev = lambda;
                fprevNorm = fNorm;
                lambda = Math.min(Math.max(0.1 * lambdaprev, lambdatemp), 0.5 * lambdaprev);
                this.report.println("Lambda: " + lambda);
            }
            if (retcode == 1) {
                this.armijoCondSatisfied = false;
            }
        } else {
            this.t = this.t.minus(dx.transpose());
            this.armijoCondSatisfied = true;
        }
        this.panelOption.set(this.it, this.model.getValue(this.t), dx, this.t);
        this.report.println("Fx Norm: " + f.norm2());
        this.report.println("DX NORM: " + dx.norm2());
        this.report.println("t: " + this.t);
        return dx;
    }
}

