/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.funktion2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import uibk.applets.funktion2d.AppletFunktion2d;
import uibk.applets.funktion2d.InteractionControl;
import uibk.applets.funktion2d.KurvenDiskussion;
import uibk.applets.funktion2d.MyFunction;
import uibk.applets.funktion2d.ReportingTable;
import uibk.applets.funktion2d.StatusAnzeige;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.swing.appletbase.PanelLoadExample;
import uibk.mtk.swing.base.Button;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TextField;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.swing.util.PanelFunction1D;

public class PanelCommand
extends MPanel {
    public InteractionControl control;
    private final AppletFunktion2d main;
    private PanelFunction1D panelfunction;
    private TextField textFunction;
    private TextField textIntervall;
    private IntegerTextField textAnzahlPoints;
    private Interval interval;
    private MyFunction function;
    private int anzahlPoints = 1;
    public KurvenDiskussion kurvenDisk;
    public StatusAnzeige status;
    private Button buttonPaint;
    private Button buttonDisk;
    ReportingTable table;

    public PanelCommand(AppletFunktion2d main) {
        this.main = main;
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BoxLayout(this, 1));
        this.control = new InteractionControl(this.main, this);
        this.table = new ReportingTable(this.main);
        this.status = new StatusAnzeige();
        JScrollPane scrollpane = new JScrollPane(this.table);
        this.add(this.createPanelDef());
        this.add(this.createPanelLoadExamples());
        this.add(scrollpane);
        this.add(this.status);
        this.add(Box.createVerticalGlue());
        this.add(this.setupPanelButtons());
        this.kurvenDisk = new KurvenDiskussion(this.main, this.control, this);
    }

    private MPanel setupPanelButtons() {
        MPanel panelButtons = new MPanel();
        panelButtons.setLayout(new GridLayout(1, 2, 30, 5));
        panelButtons.setMaximumSize(new Dimension(1000, 80));
        panelButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPaint = new Button(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.1"));
        this.buttonPaint.setActionCommand("zeichnen");
        this.buttonPaint.addActionListener(this.control);
        this.buttonPaint.setToolTipText(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.2"));
        this.buttonDisk = new Button(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.5"));
        this.buttonDisk.setActionCommand("kurvenDisk");
        this.buttonDisk.addActionListener(this.control);
        this.buttonDisk.setToolTipText(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.6"));
        this.buttonDisk.setEnabled(false);
        panelButtons.add(this.buttonPaint);
        panelButtons.add(this.buttonDisk);
        return panelButtons;
    }

    private MPanel createPanelDef() {
        MPanel eingabe = new MPanel();
        eingabe.setLayout(new BoxLayout(eingabe, 1));
        this.panelfunction = new PanelFunction1D("x".charAt(0));
        this.textFunction = this.panelfunction.getFunctionField();
        this.textIntervall = this.panelfunction.getIntervalField();
        this.textFunction.addKeyListener(this.control);
        this.textIntervall.addKeyListener(this.control);
        TitledPanel unterteilung = new TitledPanel(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.7"));
        unterteilung.setLayout(new GridBagLayout());
        unterteilung.setMaximumSize(new Dimension(2000, 140));
        this.textAnzahlPoints = new IntegerTextField(8, new Integer(1000), null, Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.8"));
        this.textAnzahlPoints.setText("1000");
        JLabel labelAnzahlPoints = new JLabel(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.9"));
        unterteilung.add((Component)labelAnzahlPoints, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        unterteilung.add((Component)this.textAnzahlPoints, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        eingabe.add(this.panelfunction);
        eingabe.add(unterteilung);
        return eingabe;
    }

    private MPanel createPanelLoadExamples() {
        String[] options = new String[]{Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.10"), Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.11"), Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.14")};
        JTextComponent[] textfields = new TextField[]{this.textFunction, this.textIntervall};
        String[][] values = new String[][]{{"sin(x)", "[0,6.283]"}, {"x^3+3*x^2-2", "[-3,2]"}, {"exp(-x^2)(1-x^2)", "[-3,2]"}};
        return new PanelLoadExample(Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.12"), Messages.getString("uibk.applets.funktion2d.messages", "PanelCommand.13"), options, textfields, values);
    }

    public void datenLesen() throws Exception {
        String f = this.panelfunction.getFunctionField().getText();
        this.function = new MyFunction(f);
        this.interval = this.panelfunction.getInterval();
        this.anzahlPoints = this.textAnzahlPoints.getValue();
    }

    public MyFunction getFunction() {
        return this.function;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public int getAnzPunkte() {
        return this.anzahlPoints;
    }

    public void clickButtonPaint() {
        this.buttonPaint.doClick();
    }

    public void setDsikEnable(boolean b) {
        this.buttonDisk.setEnabled(b);
    }

    public void setPaintEnable(boolean b) {
        this.buttonPaint.setEnabled(b);
    }
}

