/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.funktion2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import uibk.applets.funktion2d.AppletFunktion2d;
import uibk.applets.funktion2d.InteractionControl;
import uibk.applets.funktion2d.MyFunction;
import uibk.applets.funktion2d.PanelCommand;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.Rounder;
import uibk.mtk.util.IntervalIterator;

public class KurvenDiskussion
extends JPopupMenu
implements ActionListener {
    private final AppletFunktion2d main;
    private final InteractionControl control;
    private final PanelCommand command;
    private JMenuItem nullStelle;
    private JMenuItem extrema;
    private JMenuItem wendePkt;
    private KurvenDiskussion kruvenDisk;
    private final int MAXSTEP = 40;
    public static final double EPS = 1.0E-11;
    double lambda = 1.0;

    public KurvenDiskussion(AppletFunktion2d main, InteractionControl control, PanelCommand command) {
        this.main = main;
        this.control = control;
        this.command = command;
        this.kruvenDisk = this;
        this.initComponents();
    }

    private void initComponents() {
        URL urlIconNullSte = this.getClass().getResource("/uibk/mtk/swing/res/nullstelle.gif");
        this.nullStelle = new JMenuItem(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.1"), new ImageIcon(urlIconNullSte));
        this.nullStelle.setActionCommand("nullStelle");
        this.nullStelle.addActionListener(this);
        this.add(this.nullStelle);
        URL urlIconExtrema = this.getClass().getResource("/uibk/mtk/swing/res/extrema.gif");
        this.extrema = new JMenuItem(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.2"), new ImageIcon(urlIconExtrema));
        this.extrema.setActionCommand("extrema");
        this.extrema.addActionListener(this);
        this.add(this.extrema);
        URL urlIconWende = this.getClass().getResource("/uibk/mtk/swing/res/wendepkt.gif");
        this.wendePkt = new JMenuItem(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.3"), new ImageIcon(urlIconWende));
        this.wendePkt.setActionCommand("wendePkt");
        this.wendePkt.addActionListener(this);
        this.add(this.wendePkt);
        PopupListener popupListener = new PopupListener();
        this.main.f2D.addMouseListener(popupListener);
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            double b;
            Interval i = this.command.getInterval();
            double x = this.control.getLastPunktX();
            double a = x - i.getLength() / 20.0 > i.a ? x - i.getLength() / 20.0 : i.a;
            double d = b = x + i.getLength() / 20.0 < i.b ? x + i.getLength() / 20.0 : i.b;
            if (ev.getActionCommand().equals("nullStelle")) {
                this.nullStelle(new Interval(a, b), true);
            }
            if (ev.getActionCommand().equals("extrema")) {
                this.extrema(new Interval(a, b), true);
            }
            if (ev.getActionCommand().equals("wendePkt")) {
                this.wendePkt(new Interval(a, b), true);
            }
        }
        catch (Exception e) {
            this.main.f2D.reportError(e);
            return;
        }
    }

    public void nullStelle(Interval inter, boolean addPoints) throws Exception {
        double x = this.control.getLastPunktX();
        double dx = 1.0;
        int k = 0;
        MyFunction f = this.command.getFunction();
        Interval i = this.command.getInterval();
        if (inter != null) {
            i = inter;
        }
        this.checkKonst(f, 1, i, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.10"));
        this.lambda = 1.0;
        if (addPoints) {
            while (Math.abs(dx) > 1.0E-11 & 40 > k) {
                double deriv;
                if ((x += (dx = this.newtonStep(x, deriv = f.getDerivation(x), 1, i, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.11")))) > i.b || x < i.a) {
                    throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.11"));
                }
                ++k;
            }
            if (k == 40) {
                throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.11"));
            }
            this.control.checkNewPoint(x, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.12"), f, null);
        }
    }

    public void extrema(Interval inter, boolean addPoints) throws Exception {
        double x = this.control.getLastPunktX();
        double dx = 1.0;
        int k = 0;
        MyFunction f = this.command.getFunction();
        Interval i = this.command.getInterval();
        if (inter != null) {
            i = inter;
        }
        this.lambda = 1.0;
        this.checkKonst(f, 2, i, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.20"));
        if (addPoints) {
            while (Math.abs(dx) > 9.999999999999999E-11 & 40 > k) {
                double deriv;
                if ((x += (dx = this.newtonStep(x, deriv = f.getDerivation2(x), 2, i, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.21")))) > i.b || x < i.a) {
                    throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.21"));
                }
                ++k;
            }
            if (k == 40) {
                throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.21"));
            }
            x = Rounder.roundNumPlacesNext(x, 8);
            double fs = 0.0;
            fs = f.getDerivation2(x);
            if (fs < 0.0) {
                this.control.checkNewPoint(x, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.22"), f, null);
            } else {
                this.control.checkNewPoint(x, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.23"), f, null);
            }
        }
    }

    public void wendePkt(Interval inter, boolean addPoints) throws Exception {
        double x = this.control.getLastPunktX();
        double dx = 1.0;
        int k = 0;
        MyFunction f = this.command.getFunction();
        Interval i = this.command.getInterval();
        if (inter != null) {
            i = inter;
        }
        this.lambda = 1.0;
        this.checkKonst(f, 3, i, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.30"));
        this.lambda = 1.0;
        if (addPoints) {
            while (Math.abs(dx) > 9.999999999999999E-10 & 40 > k) {
                double deriv = f.getDerivation3(x);
                if (deriv == 0.0) {
                    throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.31"));
                }
                if ((x += (dx = this.newtonStep(x, deriv, 3, i, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.31")))) > i.b || x < i.a) {
                    throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.31"));
                }
                ++k;
            }
            if (k == 40) {
                throw new Exception(Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.31"));
            }
            x = Rounder.roundNumPlacesNext(x, 4);
            this.control.checkNewPoint(x, Messages.getString("uibk.applets.funktion2d.messages", "KurvenDiskussion.32"), f, null);
        }
    }

    private double newtonStep(double x0, double deriv, int typ, Interval i, String error) throws Exception {
        double g_0;
        MyFunction f = this.command.getFunction();
        if (deriv == 0.0) {
            throw new Exception(error);
        }
        if (Double.isNaN(deriv) || Double.isInfinite(deriv)) {
            throw new Exception(error);
        }
        double dx = -this.getValue(x0, f, typ, i, error) / deriv;
        double x_lambda = x0 + this.lambda * dx;
        double dx_lambda = -this.getValue(x_lambda, f, typ, i, error) / deriv;
        double g_lambda = Math.abs(dx_lambda);
        if (g_lambda > (g_0 = Math.abs(dx))) {
            while (g_lambda > g_0) {
                this.lambda /= 2.0;
                x_lambda = x0 + this.lambda * dx;
                dx_lambda = -this.getValue(x_lambda, f, typ, i, error) / deriv;
                g_lambda = Math.abs(dx_lambda);
                if (!(this.lambda < 1.0E-5)) continue;
                throw new Exception(error);
            }
        } else if (this.lambda < 1.0) {
            while (g_lambda < g_0 && this.lambda <= 2.0) {
                g_0 = g_lambda;
                this.lambda *= 2.0;
                x_lambda = x0 + this.lambda * dx;
                dx_lambda = -this.getValue(x_lambda, f, typ, i, error) / deriv;
                g_lambda = Math.abs(dx_lambda);
            }
            this.lambda = Math.min(1.0, this.lambda / 2.0);
        }
        return this.lambda * dx;
    }

    private double getValue(double x, MyFunction f, int typ, Interval i, String error) throws Exception {
        if (x > i.b || x < i.a) {
            throw new Exception(error);
        }
        switch (typ) {
            case 1: {
                return f.getValue(x);
            }
            case 2: {
                return f.getDerivation(x);
            }
            case 3: {
                return f.getDerivation2(x);
            }
            case 4: {
                return f.getDerivation3(x);
            }
        }
        throw new Exception("Interner Fehler");
    }

    private void checkKonst(MyFunction f, int typ, Interval i, String error) throws Exception {
        IntervalIterator it1 = new IntervalIterator(i.a, i.b, this.control.anzahlPoints_Graph / 100);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        while (it1.hasNext()) {
            double t = it1.nextdouble();
            double y = 0.0;
            try {
                y = this.getValue(t, f, typ, i, error);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (y < min) {
                min = y;
            }
            if (!(y > max)) continue;
            max = y;
        }
        if (Math.abs(max - min) < 1.0E-6) {
            MathPoint2D p = new MathPoint2D(i.a, max);
            p.setColor(Color.red);
            if (typ == 1) {
                p.setRadius(2);
                this.main.f2D.add(p);
                this.control.setFtop();
            }
            if (typ == 2) {
                p.setRadius(1);
                this.main.fs2D.add(p);
                this.control.setFstop();
            }
            if (typ == 3) {
                p.setRadius(1);
                this.main.fss2D.add(p);
                this.control.setFsstop();
            }
            throw new Exception(error);
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && KurvenDiskussion.this.control.isReady()) {
                KurvenDiskussion.this.kruvenDisk.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

