/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.polynom;

import java.util.Iterator;
import java.util.TreeSet;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.polynom.PolynomException;
import uibk.mtk.math.polynom.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variables
implements Iterable<Variable> {
    private static final String BUNDLE_NAME = "uibk.mtk.math.polynom.messages";
    public static final Variable ONE = new Variable();
    public TreeSet<Variable> vars = new TreeSet();

    public Variables() {
        this.vars.add(ONE);
    }

    public Variables(String var) {
        this.vars.add(new Variable(var, 1));
    }

    Variables(TreeSet<Variable> vars) {
        this.vars = vars;
    }

    public Variables(Variable var) {
        this.vars.add(var);
    }

    public void addVariable(Variable var) throws PolynomException {
        if (this.vars.contains(var)) {
            throw new PolynomException(Messages.getString(BUNDLE_NAME, "Variables.0"), ExceptionLevel.ERROR);
        }
        this.vars.add(var);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Variables) {
            Variables variable2 = (Variables)obj;
            if (this.vars.size() != variable2.vars.size()) {
                return false;
            }
            Object[] v1 = this.vars.toArray();
            Object[] v2 = variable2.vars.toArray();
            int i = 0;
            while (i < this.vars.size()) {
                if (!v1[i].equals(v2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Variable v : this.vars) {
            hashCode += v.hashCode();
        }
        return hashCode;
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.vars.iterator();
    }

    public boolean contains(Variable s) {
        boolean b = false;
        b = this.vars.contains(s);
        return b;
    }

    public void incrementVariable(Variable var) throws PolynomException {
        if (var.bez.equals("1")) {
            return;
        }
        for (Variable v : this.vars) {
            if (!v.equals(var)) continue;
            ++v.exponent;
            return;
        }
        throw new PolynomException(Messages.getString(BUNDLE_NAME, "Variables.1"), ExceptionLevel.ERROR);
    }

    public String toString() {
        String ret = "";
        for (Variable v : this) {
            if (v.equals("1")) continue;
            ret = String.valueOf(ret) + v;
        }
        return ret;
    }

    public Variables clone() {
        TreeSet<Variable> var_tmp = new TreeSet<Variable>();
        for (Variable v : this.vars) {
            var_tmp.add(v.clone());
        }
        return new Variables(var_tmp);
    }
}

