/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import java.awt.Component;
import java.math.BigInteger;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.NotANumberException;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixPanelCholesky;
import uibk.mtk.math.numberPanel.MatrixPanelLU;
import uibk.mtk.math.numberPanel.MyNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatrixUtil {
    static final String BUNDLE_NAME = "uibk.mtk.math.numberPanel.messages";

    private MatrixUtil() {
    }

    public static MatrixPanel transpose(MatrixPanel m) throws ExtendedException {
        MatrixPanel r = new MatrixPanel(m.getColumnDim(), m.getRowDim());
        r.setPrecision(m.getPrecision());
        int i = 0;
        while (i < m.getRowDim()) {
            int j = 0;
            while (j < m.getColumnDim()) {
                r.setValueAt(j, i, m.getVauleAt(i, j).clone());
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static MatrixPanel getIdentityMatrix(int rowDim, int columnDim, int view, Component parentComponent, Class<? extends MyNumber> cl) throws ExtendedException {
        return MatrixUtil.getIdentityMatrix(rowDim, columnDim, view, parentComponent, 3, cl);
    }

    public static MatrixPanel getIdentityMatrix(int rowDim, int columnDim, int view, Component parentComponent, int precision, Class<? extends MyNumber> cl) throws ExtendedException {
        MatrixPanel ret = new MatrixPanel(rowDim, columnDim);
        ret.setPrecision(precision);
        int i = 0;
        while (i < rowDim) {
            int j = 0;
            while (j < columnDim) {
                try {
                    MyNumber r = i == j ? MyNumber.getNumber(cl, 1.0, 1, view, parentComponent, precision) : MyNumber.getNumber(cl, 0.0, 1, view, parentComponent, precision);
                    ret.setValueAtIntern(i, j, r);
                }
                catch (NotANumberException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static MatrixPanel getNullMatrix(int rowDim, int columnDim, int view, Component parentComponent, Class<? extends MyNumber> cl) throws ExtendedException {
        return MatrixUtil.getNullMatrix(rowDim, columnDim, view, parentComponent, 3, cl);
    }

    public static MatrixPanel getNullMatrix(int rowDim, int columnDim, int view, Component parentComponent, int precision, Class<? extends MyNumber> cl) throws ExtendedException {
        MatrixPanel ret = new MatrixPanel(rowDim, columnDim);
        ret.setPrecision(precision);
        int i = 0;
        while (i < rowDim) {
            int j = 0;
            while (j < columnDim) {
                try {
                    ret.setValueAtIntern(i, j, MyNumber.getNumber(cl, 0.0, 1, view, parentComponent, precision));
                }
                catch (NotANumberException notANumberException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static MatrixPanelLU mulLU(MatrixPanel m1, MatrixPanel m2) throws ExtendedException {
        if (m1.getColumnDim() != m2.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.ERROR);
        }
        Class<?> cl = m1.getVauleAt(0, 0).getClass();
        MatrixPanelLU r = new MatrixPanelLU(m1.getRowDim(), m2.getColumnDim());
        int k = 0;
        while (k < m2.getColumnDim()) {
            int i = 0;
            while (i < m1.getRowDim()) {
                MyNumber tmp = MyNumber.getNumber(cl, 0.0, 1, 0, null, m1.getPrecision());
                int j = 0;
                while (j < m1.getColumnDim()) {
                    tmp = m1.getVauleAt(i, j).mul(m2.getVauleAt(j, k)).add(tmp);
                    ++j;
                }
                r.setValueAt(i, k, tmp);
                ++i;
            }
            ++k;
        }
        return r;
    }

    public static MatrixPanelCholesky mulChol(MatrixPanel m1, MatrixPanel m2) throws ExtendedException {
        if (m1.getColumnDim() != m2.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.ERROR);
        }
        Class<?> cl = m1.getVauleAt(0, 0).getClass();
        MatrixPanelCholesky r = new MatrixPanelCholesky(m1.getRowDim(), m2.getColumnDim());
        int k = 0;
        while (k < m2.getColumnDim()) {
            int i = 0;
            while (i < m1.getRowDim()) {
                MyNumber tmp = MyNumber.getNumber(cl, 0.0, 1, 0, null);
                int j = 0;
                while (j < m1.getColumnDim()) {
                    tmp = m1.getVauleAt(i, j).mul(m2.getVauleAt(j, k)).add(tmp);
                    ++j;
                }
                r.setValueAt(i, k, tmp);
                ++i;
            }
            ++k;
        }
        return r;
    }

    public static MatrixPanel mul(MatrixPanel m1, MatrixPanel m2) throws ExtendedException {
        if (m1.getColumnDim() != m2.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.ERROR);
        }
        Class<?> cl = m1.getVauleAt(0, 0).getClass();
        MatrixPanel r = new MatrixPanel(m1.getRowDim(), m2.getColumnDim());
        r.setPrecision(m1.getPrecision());
        int k = 0;
        while (k < m2.getColumnDim()) {
            int i = 0;
            while (i < m1.getRowDim()) {
                MyNumber tmp = MyNumber.getNumber(cl, 0.0, 1, 0, null, m1.getPrecision());
                int j = 0;
                while (j < m1.getColumnDim()) {
                    tmp = m1.getVauleAt(i, j).mul(m2.getVauleAt(j, k)).add(tmp);
                    ++j;
                }
                r.setValueAt(i, k, tmp);
                ++i;
            }
            ++k;
        }
        return r;
    }

    public static MatrixPanel partMul(MatrixPanel m1, MatrixPanel m2, int index) throws ExtendedException {
        if (m1.getColumnDim() != m2.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.ERROR);
        }
        Class<?> cl = m1.getVauleAt(0, 0).getClass();
        MatrixPanel r = new MatrixPanel(m1.getRowDim(), m2.getColumnDim());
        int k = index;
        while (k < m2.getColumnDim()) {
            int i = index;
            while (i < m1.getRowDim()) {
                MyNumber tmp = MyNumber.getNumber(cl, 0.0, 1, 0, null);
                int j = index;
                while (j < m1.getColumnDim()) {
                    tmp = m1.getVauleAt(i, j).mul(m2.getVauleAt(j, k)).add(tmp);
                    ++j;
                }
                r.setValueAt(i, k, tmp);
                ++i;
            }
            ++k;
        }
        return r;
    }

    public static boolean isSymmetric(MatrixPanel m1) throws ExtendedException {
        if (m1.getColumnDim() != m1.getRowDim() || m1.getColumnDim() <= 0) {
            throw new MatrixException("Matrix nicht quadratisch", ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < m1.getColumnDim()) {
            int j = i + 1;
            while (j < m1.getRowDim()) {
                if (m1.getVauleAt(i, j).compareTo(m1.getVauleAt(j, i)) != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSymmetric(MatrixPanel m1, int index) throws ExtendedException {
        if (m1.getColumnDim() != m1.getRowDim() || m1.getColumnDim() <= 0) {
            throw new MatrixException("Matrix nicht quadratisch", ExceptionLevel.ERROR);
        }
        int i = index;
        while (i < m1.getColumnDim()) {
            int j = i + 1;
            while (j < m1.getRowDim()) {
                if (m1.getVauleAt(i, j).compareTo(m1.getVauleAt(j, i)) != 0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDiagonalDominant(MatrixPanel m1) throws ExtendedException {
        if (m1.getColumnDim() != m1.getRowDim() || m1.getColumnDim() <= 0) {
            throw new MatrixException("Matrix nicht quadratisch", ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < m1.getColumnDim()) {
            MyNumber sum = m1.getVauleAt(i, 0).abs();
            int j = 1;
            while (j < m1.getRowDim()) {
                sum.add(m1.getVauleAt(i, j).abs());
                ++j;
            }
            sum.sub(m1.getVauleAt(i, i).abs());
            if (sum.compareTo(m1.getVauleAt(i, i).abs()) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static MatrixPanel forwordInsert(MatrixPanel L, MatrixPanel b) throws ExtendedException {
        if ((L == null || b == null) && b == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.0"), ExceptionLevel.WARNING);
        }
        if (!MatrixUtil.isLowerTriangle(L)) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.1"), ExceptionLevel.ERROR);
        }
        MatrixPanel x = L.initXMatrix(b);
        x.setPrecision(L.getPrecision());
        Class<?> cl = L.getVauleAt(0, 0).getClass();
        int solveIndexColumn = 0;
        while (solveIndexColumn < b.getColumnDim()) {
            int solveIndexRow = 0;
            while (solveIndexRow < L.getRowDim()) {
                MyNumber sum = MyNumber.getNumber(cl, 0.0, 1, L.getView(), L, L.getPrecision());
                int j = 0;
                while (j < solveIndexRow) {
                    sum = sum.add(L.getVauleAt(solveIndexRow, j).mul(x.getVauleAt(j, solveIndexColumn)));
                    ++j;
                }
                x.setValueAt(solveIndexRow, solveIndexColumn, b.getVauleAt(solveIndexRow, solveIndexColumn).sub(sum).div(L.getVauleAt(solveIndexRow, solveIndexRow)));
                ++solveIndexRow;
            }
            ++solveIndexColumn;
        }
        return x;
    }

    public static MatrixPanel backwardInsert(MatrixPanel U, MatrixPanel b) throws ExtendedException {
        if (U == null || b == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.0"), ExceptionLevel.WARNING);
        }
        if (!MatrixUtil.isUperTriangle(U)) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.3"), ExceptionLevel.ERROR);
        }
        MatrixPanel x = U.initXMatrix(b);
        x.setPrecision(U.getPrecision());
        Class<?> cl = U.getVauleAt(0, 0).getClass();
        int k = 0;
        while (k < b.getColumnDim()) {
            int i = U.getColumnDim() - 1;
            while (i >= 0) {
                MyNumber sum = MyNumber.getNumber(cl, 0.0, 1, U.getView(), U, U.getPrecision());
                int j = U.getColumnDim() - 1;
                while (j > i) {
                    sum = sum.add(U.getVauleAt(i, j).mul(x.getVauleAt(j, k)));
                    --j;
                }
                x.setValueAt(i, k, b.getVauleAt(i, k).sub(sum).div(U.getVauleAt(i, i)));
                --i;
            }
            ++k;
        }
        return x;
    }

    public static MatrixPanel backwardInsert(MatrixPanelLU U, MatrixPanel b) throws ExtendedException {
        int nullRows = MatrixUtil.isSolveAble(U, b, -1);
        MatrixPanel x = U.initXMatrix(b);
        x.setPrecision(U.getPrecision());
        Class<?> cl = U.getVauleAt(0, 0).getClass();
        int k = 0;
        while (k < b.getColumnDim()) {
            int i = U.getRowDim() - 1 - nullRows;
            while (i >= 0) {
                MyNumber sum = MyNumber.getNumber(cl, 0.0, 1, U.getView(), U, U.getPrecision());
                int j = U.getColumnDim() - 1;
                while (j > i) {
                    sum = sum.add(U.getVauleAt(i, j).mul(x.getVauleAt(j, k)));
                    --j;
                }
                x.setValueAt(i, k, b.getVauleAt(i, k).sub(sum).div(U.getVauleAt(i, i)));
                --i;
            }
            ++k;
        }
        return x;
    }

    public static MatrixPanel backwardInsert(MatrixPanelLU U, MatrixPanel x, int index, MatrixPanel b) throws ExtendedException {
        int nullRows = MatrixUtil.isSolveAble(U, b, index);
        Class<?> cl = U.getVauleAt(0, 0).getClass();
        if (x == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrixUtil.0"), ExceptionLevel.WARNING);
        }
        if (U.getColumnDim() != x.getRowDim() || x.getColumnDim() != b.getColumnDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.6"), ExceptionLevel.WARNING);
        }
        int k = 0;
        while (k < b.getColumnDim()) {
            int i = U.getRowDim() - 1 - nullRows;
            while (i >= 0) {
                MyNumber sum = MyNumber.getNumber(cl, 0.0, 1, U.getView(), U, U.getPrecision());
                int j = U.getColumnDim() - 1;
                while (j > i) {
                    sum = sum.add(U.getVauleAt(i, j).mul(x.getVauleAt(j, k)));
                    --j;
                }
                x.setValueAt(i, k, b.getVauleAt(i, k).sub(sum).div(U.getVauleAt(i, i)));
                --i;
            }
            ++k;
        }
        return x;
    }

    public static boolean isLowerTriangle(MatrixPanel M) throws ExtendedException {
        if (M == null) {
            return false;
        }
        if (M.getRowDim() != M.getColumnDim()) {
            return false;
        }
        int i = 0;
        while (i < M.getRowDim()) {
            if (M.getVauleAt(i, i).isZero()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < M.getRowDim()) {
            int j = i + 1;
            while (j < M.getColumnDim()) {
                if (!M.getVauleAt(i, j).isZero()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUperTriangle(MatrixPanel M) throws ExtendedException {
        if (M == null) {
            return false;
        }
        if (M.getRowDim() < M.getColumnDim()) {
            throw new MatrixException("Nicht impl.", ExceptionLevel.ERROR);
        }
        int i = 0;
        while (i < M.getColumnDim()) {
            if (M.getVauleAt(i, i).isZero()) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < M.getColumnDim()) {
            int i2 = j + 1;
            while (i2 < M.getRowDim()) {
                if (!M.getVauleAt(i2, j).isZero()) {
                    return false;
                }
                ++i2;
            }
            ++j;
        }
        return true;
    }

    public static int isSolveAble(MatrixPanelLU A, MatrixPanel b, int index) throws ExtendedException {
        int min;
        if (A == null || b == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.5"), ExceptionLevel.WARNING);
        }
        index = index < 0 ? 0 : index;
        int n = min = A.getRowDim() < A.getColumnDim() ? A.getRowDim() : A.getColumnDim();
        if (A.getIndexPivot() < min) {
            A.gaussAlgorithmus(false);
        }
        if (A.getRowDim() != b.getRowDim()) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.4"), ExceptionLevel.ERROR);
        }
        int nullRows = 0;
        int i = b.getRowDim() - 1;
        while (i > -1) {
            boolean rowIsNull = true;
            int j = A.getColumnDim() - 1;
            while (j > -1) {
                MyNumber r = A.getVauleAt(i, j);
                if (r.getNumerator().compareTo(BigInteger.ZERO) != 0) {
                    rowIsNull = false;
                    break;
                }
                --j;
            }
            if (!rowIsNull) break;
            ++nullRows;
            j = 0;
            while (j < b.getColumnDim()) {
                if (b.getVauleAt(i, j).getNumerator().compareTo(BigInteger.ZERO) != 0) {
                    throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.9"), ExceptionLevel.WARNING);
                }
                ++j;
            }
            --i;
        }
        if (index == 0 && A.getRowDim() - nullRows != A.getColumnDim() - index) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.10"), ExceptionLevel.WARNING);
        }
        return nullRows;
    }

    public static MatrixPanel getSubMatrix(MatrixPanel A, int row1, int row2, int column1, int column2) throws ExtendedException {
        if (row2 < row1 || column2 < column1) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalMatrix.10"), ExceptionLevel.WARNING);
        }
        MatrixPanel ret = new MatrixPanel(row2 - row1 + 1, column2 - column1 + 1);
        ret.setPrecision(A.getPrecision());
        int i = row1;
        while (i <= row2) {
            int j = column1;
            while (j <= column2) {
                ret.setValueAt(i - row1, j - column1, A.getVauleAt(i, j));
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

