/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.numberPanel;

import java.util.Vector;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.MatrixPanelLU;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.math.numberPanel.MyNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixAttributes {
    static final String BUNDLE_NAME = "uibk.mtk.math.numberPanel.messages";
    private final MatrixPanelLU m;
    private final MyNumber det;
    private final int columnDim;
    private final int rowDim;
    private final int rank;
    private final int kernDim;
    private final Vector<MatrixPanel> basisKern = new Vector();

    public MatrixAttributes(MatrixPanelLU A) throws ExtendedException {
        int i;
        if (A == null) {
            throw new MatrixException("Ung\u00fcltige Matrix", ExceptionLevel.ERROR);
        }
        this.m = A.clone();
        this.m.gaussAlgorithmus(false);
        Class<?> cl = this.m.getVauleAt(0, 0).getClass();
        this.columnDim = this.m.getColumnDim();
        this.rowDim = this.m.getRowDim();
        if (this.columnDim != this.rowDim) {
            this.det = null;
        } else {
            MyNumber det = MyNumber.getNumber(cl, 1.0, 1, this.m.getView(), this.m);
            i = 0;
            while (i < this.columnDim) {
                det = det.mul(this.m.getVauleAt(i, i));
                ++i;
            }
            this.det = det;
        }
        int min = this.columnDim < this.rowDim ? this.columnDim : this.rowDim;
        i = 0;
        while (i < min) {
            if (this.m.getVauleAt(i, i).getDoubleValue() == 0.0) break;
            ++i;
        }
        this.rank = i;
        this.kernDim = this.columnDim - this.rank;
        if (this.kernDim > 0) {
            try {
                MatrixPanel x = MatrixUtil.getNullMatrix(this.m.getColumnDim(), this.kernDim, 0, null, 3, A.getVauleAt(0, 0).getClass());
                int k = 0;
                while (k < this.kernDim) {
                    x.setValueAt(x.getRowDim() - k - 1, k, MyNumber.getNumber(cl, 1.0, 1, 0, null));
                    ++k;
                }
                MatrixPanel b = MatrixUtil.backwardInsert(this.m, x, this.kernDim, MatrixUtil.getNullMatrix(this.m.getRowDim(), x.getColumnDim(), 0, null, 3, A.getVauleAt(0, 0).getClass()));
                MatrixPanel T = MatrixUtil.transpose(this.m.getPermuttationSpalten());
                b = MatrixUtil.mul(T, b);
                int j = 0;
                while (j < b.getColumnDim()) {
                    this.basisKern.add(MatrixUtil.getSubMatrix(b, 0, b.getRowDim() - 1, j, j));
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getColumnDim() {
        return this.columnDim;
    }

    public MyNumber getDet() throws MatrixException {
        if (this.m.getColumnDim() != this.m.getRowDim() || this.det == null) {
            throw new MatrixException(Messages.getString(BUNDLE_NAME, "RationalValues.0"), ExceptionLevel.ERROR);
        }
        return this.det;
    }

    public int getKernDim() {
        return this.kernDim;
    }

    public int getRank() {
        return this.rank;
    }

    public int getRowDim() {
        return this.rowDim;
    }

    public String getDim() {
        return String.valueOf(this.rowDim) + "x" + this.columnDim;
    }

    public String toString() {
        String ret = "Dim: " + this.getDim() + "; Det: " + this.det + "; rank: " + this.rank + "; kernDim: " + this.kernDim + "\nBasis Kern: \n";
        for (MatrixPanel mat : this.basisKern) {
            ret = String.valueOf(ret) + mat.toString();
        }
        return ret;
    }

    public Vector<MatrixPanel> getBasisKern() {
        return this.basisKern;
    }
}

