/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.MathUtil;
import uibk.mtk.math.functions.Function1D;

public class BisectionMethod {
    private double eps = 1.0E-5;
    static final int MAXSTEPS = 1000;
    Interval interval;
    Function1D function;
    double error;
    static final String BUNDLE_NAME = "uibk.mtk.math.messages";

    public BisectionMethod() {
    }

    public BisectionMethod(Function1D function) {
        this.setFunction(function);
    }

    public void setFunction(Function1D f) {
        this.function = f;
    }

    public Function1D getFunction() {
        return this.function;
    }

    public double getError() {
        return this.error;
    }

    public void setEps(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("");
        }
        this.eps = d;
    }

    public void setInterval(Interval interval) {
        this.interval = (Interval)interval.clone();
    }

    public Interval getInterval() {
        if (this.interval == null) {
            return null;
        }
        return (Interval)this.interval.clone();
    }

    public double compute() throws ComputationException {
        int count = 0;
        while (count < 1000) {
            double approx = this.nextApproximation();
            this.error = Math.abs(this.interval.getLength()) / 2.0;
            if (!(this.error < this.eps)) continue;
            return approx;
        }
        throw new ComputationException(String.valueOf(Messages.getString(BUNDLE_NAME, "BisectionMethod.1")) + 1000 + Messages.getString(BUNDLE_NAME, "BisectionMethod.2"));
    }

    public double getEps() {
        return this.eps;
    }

    public double nextApproximation() throws ComputationException {
        double a = this.interval.a;
        double b = this.interval.b;
        double fa = this.function.getValue(a);
        double fb = this.function.getValue(b);
        if (fa == 0.0) {
            this.error = 0.0;
            return a;
        }
        if (fb == 0.0) {
            this.error = 0.0;
            return b;
        }
        if (MathUtil.sign(fa) == MathUtil.sign(fb)) {
            throw new ComputationException(Messages.getString(BUNDLE_NAME, "BisectionMethod.3"));
        }
        double newlimit = (a + b) / 2.0;
        double fnewlimit = this.function.getValue(newlimit);
        if (MathUtil.sign(fnewlimit) == MathUtil.sign(fb)) {
            this.interval.b = newlimit;
        } else {
            this.interval.a = newlimit;
        }
        if (fnewlimit == 0.0) {
            this.interval.a = newlimit;
            this.interval.b = newlimit;
            return newlimit;
        }
        this.error = Math.abs(this.interval.a - this.interval.b) / 2.0;
        return newlimit;
    }
}

