/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.choleskyAlgorithmus;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import uibk.applets.choleskyAlgorithmus.AppletCholeskyAlgorithmus;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.InputException;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.StandardOptions;
import uibk.mtk.math.numberPanel.IrrationalNumber;
import uibk.mtk.math.numberPanel.MatrixPanel;
import uibk.mtk.math.numberPanel.RationalNumber;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.RationalNumberTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PopUpSetValue {
    private static final String title = Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "SetValuePopUp.0");

    public static int[] getPopUp(Component parentComponent, int rowIndex, int columnIndex, MatrixPanel A, String bez, Vector<MatrixPanel> matrixSetValue, AppletCholeskyAlgorithmus main) throws InputException, ExtendedException {
        String name = String.valueOf(bez) + "(" + (rowIndex + 1) + "," + (columnIndex + 1) + ")=";
        JLabel labelName = new JLabel(name);
        RationalNumberTextField textField = new RationalNumberTextField(15, null, null, name);
        textField.setText(A.getVauleAt(rowIndex, columnIndex).toString());
        A.setBorderByIndex(rowIndex, columnIndex, null);
        Object[] array = new Object[]{PopUpSetValue.createSetValuePanel(labelName, textField)};
        Object[] options = new Object[]{"<<", Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "SetValuePopUp.3"), ">>"};
        JOptionPane optionPane = new JOptionPane(array, 3, 0, null, options, options[2]);
        optionPane.setBackground(StandardOptions.COMPONENTSCOLOR);
        JDialog dialog = optionPane.createDialog(parentComponent, title);
        dialog.setVisible(true);
        RationalNumber r = textField.getValue();
        r.setParentComponent(main);
        r.setView(1);
        for (MatrixPanel M : matrixSetValue) {
            if (M.getVauleAt(0, 0) instanceof RationalNumber) {
                M.setValueAt(rowIndex, columnIndex, r.clone());
                continue;
            }
            M.setValueAt(rowIndex, columnIndex, new IrrationalNumber(r.getDoubleValue(), 2, (Component)main, M.getPrecision()));
        }
        main.setMainPanel();
        if (optionPane.getValue() == null) {
            return null;
        }
        if (optionPane.getValue().equals(options[0])) {
            int row = rowIndex;
            int column = columnIndex - 1;
            if (column < 0) {
                column = A.getColumnDim() - 1;
                --row;
            }
            if (row < 0) {
                row = A.getRowDim() - 1;
            }
            return PopUpSetValue.getPopUp(parentComponent, row, column, A, bez, matrixSetValue, main);
        }
        if (optionPane.getValue().equals(options[2])) {
            int row = rowIndex;
            int column = columnIndex + 1;
            if (column >= A.getColumnDim()) {
                column = 0;
                ++row;
            }
            if (row >= A.getRowDim()) {
                row = 0;
            }
            return PopUpSetValue.getPopUp(parentComponent, row, column, A, bez, matrixSetValue, main);
        }
        int[] ret = new int[]{rowIndex, columnIndex};
        return ret;
    }

    private static MPanel createSetValuePanel(JLabel labelName, RationalNumberTextField textField) {
        MPanel panel = new MPanel();
        panel.setLayout(new GridBagLayout());
        panel.setMaximumSize(new Dimension(2000, 60));
        panel.add((Component)labelName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)textField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }
}

