/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.choleskyAlgorithmus;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import uibk.applets.choleskyAlgorithmus.AppletCholeskyAlgorithmus;
import uibk.applets.choleskyAlgorithmus.PanelControl;
import uibk.applets.choleskyAlgorithmus.PanelMain;
import uibk.mtk.exception.ExceptionLevel;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.math.numberPanel.IrrationalNumber;
import uibk.mtk.math.numberPanel.MatrixException;
import uibk.mtk.math.numberPanel.MatrixPanelCholesky;
import uibk.mtk.math.numberPanel.MatrixUtil;
import uibk.mtk.swing.base.MPanel;

public class PanelMainCholesky
extends PanelMain {
    private int index = 0;

    public PanelMainCholesky(AppletCholeskyAlgorithmus main, PanelControl panelControl) {
        super(main, panelControl);
    }

    public synchronized void initGLS(boolean permutX) throws ExtendedException {
        this.initPanels();
        MPanel[] mPanelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            MPanel p = mPanelArray[n2];
            p.removeAll();
            ++n2;
        }
        if (this.A != null) {
            JLabel text = new JLabel("D:");
            text.setFont(new Font("Dialog", 0, 24));
            this.panels[0].add(text);
            this.A.getVec().setFont(AppletCholeskyAlgorithmus.FONT);
            this.A.getVec().setBackground(AppletCholeskyAlgorithmus.COLOR_NO_EDIT);
            this.panels[1].add(this.A.getVec());
            JLabel text1 = new JLabel("H:");
            text1.setFont(new Font("Dialog", 0, 24));
            this.panels[2].add(text1);
            this.A.setFont(AppletCholeskyAlgorithmus.FONT);
            this.A.addMouseListener(this.mouseEvents);
            this.A.addMouseMotionListener(this.mouseEvents);
            this.A.setBackground(AppletCholeskyAlgorithmus.COLOR_NO_EDIT);
            this.A.setRowBorder(this.A.getIndexRow(), this.A.getIndexColumn() + 1, this.A.getIndexRow() + 1, Color.BLACK);
            this.panels[3].add(this.A);
            this.A.getL().setFont(AppletCholeskyAlgorithmus.FONT);
            this.A.getL().setBackground(AppletCholeskyAlgorithmus.COLOR_EDIT);
            this.A.getL().setBorderByIndex(this.A.getIndexRow(), this.A.getIndexColumn(), Color.BLACK);
            JLabel text2 = new JLabel("C:");
            text2.setFont(new Font("Dialog", 0, 24));
            this.panels[6].add(text2);
            this.panels[7].add(this.A.getL());
        }
        this.setView(2);
        this.main.setMainPanel();
    }

    protected void solveStep() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        if (this.index == 0) {
            int i = 0;
            while (i < this.A.getRowDim()) {
                this.A.getVec().setValueAtIntern(i, 0, this.A.getVauleAt(i, i).clone());
                ++i;
            }
        }
        if (!MatrixUtil.isSymmetric(this.A, this.index)) {
            throw new MatrixException("Matrix nicht symmetrisch", ExceptionLevel.ERROR);
        }
        if (this.A.getIndexColumn() < this.A.getColumnDim() || this.A.getIndexRow() < this.A.getColumnDim()) {
            this.addSteppToHistory(this.index, this.index, AppletCholeskyAlgorithmus.COLOR_SOLVE);
            this.solveStep(this.A);
            this.initGLS(false);
        } else {
            this.A.setSolved(true);
        }
        System.out.println(this.A);
        ((PanelMain.History)this.history.lastElement()).A = this.A;
        ((PanelMain.History)this.history.lastElement()).index = this.index;
    }

    private void solveStep(MatrixPanelCholesky A) throws ExtendedException {
        int indexRow = A.getIndexRow();
        int indexColumn = A.getIndexColumn();
        System.out.println(String.valueOf(A.getIndexRow()) + " , " + A.getIndexColumn());
        if (indexRow == indexColumn) {
            if (A.getVauleAt(indexRow, indexRow).getDoubleValue() <= 0.0) {
                throw new MatrixException("Matrix nicht positiv definit", ExceptionLevel.ERROR);
            }
            A.getL().setValueAtIntern(indexRow, indexColumn, A.getVauleAt(indexRow, indexRow).clone().sqrt());
            A.setValueAtInternKeepView(indexRow, indexColumn, new IrrationalNumber(" ", 3, (Component)this.main, A.getPrecision()));
        } else {
            A.getL().setValueAt(indexRow, indexColumn, A.getVauleAt(indexRow, indexColumn).div(A.getL().getVauleAt(indexColumn, indexColumn)));
            int i = indexColumn + 1;
            while (i <= indexRow) {
                A.setValueAtIntern(indexRow, i, A.getVauleAt(indexRow, i).clone().sub(A.getL().getVauleAt(indexRow, indexColumn).clone().mul(A.getL().getVauleAt(i, indexColumn))));
                ++i;
            }
            A.setValueAtInternKeepView(indexRow, indexColumn, new IrrationalNumber("   ", 3, (Component)this.main, A.getPrecision()));
        }
        System.out.println("Pecision: " + A.getPrecision());
        if (indexRow + 1 == A.getColumnDim()) {
            A.setIndexColumn(indexColumn + 1);
            A.setIndexRow(indexColumn + 1);
        } else {
            A.setIndexRow(indexRow + 1);
        }
        ++this.index;
        this.A = A;
    }

    protected void newGLSImpl() {
        this.index = 0;
    }

    protected void removeStepFromHistoryImpl() {
        this.index = ((PanelMain.History)this.history.lastElement()).index;
    }

    protected void addSteppToHistory() {
        ((PanelMain.History)this.history.lastElement()).index = this.index;
    }

    public void setBorder() {
        this.A.setBorderByIndex(-1, -1, Color.BLACK);
        this.A.setRowBorder(this.A.getIndexRow(), this.A.getIndexColumn() + 1, this.A.getIndexRow() + 1, Color.BLACK);
    }
}

