/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.choleskyAlgorithmus;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import uibk.applets.choleskyAlgorithmus.AppletCholeskyAlgorithmus;
import uibk.applets.choleskyAlgorithmus.MouseEvents;
import uibk.applets.choleskyAlgorithmus.PanelControl;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.IrrationalNumber;
import uibk.mtk.math.numberPanel.MatrixEvent;
import uibk.mtk.math.numberPanel.MatrixPanelCholesky;
import uibk.mtk.math.numberPanel.RationalMatrixListener;
import uibk.mtk.math.numberPanel.RationalNumber;
import uibk.mtk.swing.base.MPanel;

public abstract class PanelMain
extends MPanel
implements RationalMatrixListener,
ComponentListener {
    protected final AppletCholeskyAlgorithmus main;
    protected final PanelControl panelControl;
    protected final MouseEvents mouseEvents;
    protected MatrixPanelCholesky A;
    protected final MPanel[] panels = new MPanel[25];
    protected Vector<History> history = new Vector();

    public PanelMain(AppletCholeskyAlgorithmus main, PanelControl panelControl) {
        this.main = main;
        this.mouseEvents = new MouseEvents(main, this, panelControl);
        this.panelControl = panelControl;
        this.setBackground(AppletCholeskyAlgorithmus.COLOR_BGD);
        this.setLayout(new BoxLayout(this, 1));
    }

    protected void initPanels() {
        this.removeAll();
        this.history.lastElement().removeAll();
        this.history.lastElement().setBackground(AppletCholeskyAlgorithmus.COLOR_BGD);
        this.history.lastElement().setAlignmentX(0.0f);
        this.history.lastElement().add(Box.createGlue());
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i] = new MPanel();
            this.panels[i].setBackground(AppletCholeskyAlgorithmus.COLOR_BGD);
            this.history.lastElement().add(this.panels[i]);
            ++i;
        }
        this.history.lastElement().add(Box.createGlue());
        i = this.history.size();
        while (i > 0) {
            this.add(this.history.get(i - 1));
            --i;
        }
        this.add(Box.createVerticalGlue());
    }

    public void newGLS(int rows, int columns) throws ExtendedException {
        int j;
        MatrixPanelCholesky A = new MatrixPanelCholesky(rows, columns);
        int i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                A.setValueAt(i, j, new RationalNumber(0L, 1L, 1, (Component)this.main));
                ++j;
            }
            ++i;
        }
        this.main.mainPanel[0].A = A;
        this.main.mainPanel[0].newGLS(this.main.mainPanel[0].A);
        A = new MatrixPanelCholesky(rows, columns);
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                A.setValueAt(i, j, new IrrationalNumber(0.0, 2, (Component)this.main, A.getPrecision()));
                ++j;
            }
            ++i;
        }
        this.main.mainPanel[1].A = A;
        this.main.mainPanel[1].newGLS(this.main.mainPanel[1].A);
        i = 0;
        while (i < A.getColumnDim()) {
            A.getL().setValueAtIntern(i, i, new IrrationalNumber(2, A.getParent(), A.getPrecision()));
            A.getVec().setValueAtIntern(i, 0, new IrrationalNumber(2, A.getParent(), A.getPrecision()));
            ++i;
        }
    }

    public void newGLS(MatrixPanelCholesky A) throws ExtendedException {
        this.A = A;
        this.newGLSImpl();
        this.history.removeAllElements();
        this.history.add(new History(A));
        this.initGLS(false);
        A.addRationalMatrixListener(this);
        this.setTitleStep();
        this.main.report.reportSuccess(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelMain.13"));
    }

    protected abstract void newGLSImpl();

    public abstract void initGLS(boolean var1) throws ExtendedException;

    public void valueSet(MatrixEvent ev) throws ExtendedException {
        this.setTitleStep();
        this.main.report.reportSuccess(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelMain.14"));
    }

    protected void addSteppToHistory(Integer rowIndex, Integer columnIndex, Color c) throws ExtendedException {
        this.A.removeMouseListener(this.mouseEvents);
        this.A.removeMouseMotionListener(this.mouseEvents);
        this.A.setBackground(AppletCholeskyAlgorithmus.COLOR_HISTORY);
        this.A.setFont(AppletCholeskyAlgorithmus.FONT_HISTORY);
        this.A.getL().setBackground(AppletCholeskyAlgorithmus.COLOR_HISTORY);
        this.A.getL().setFont(AppletCholeskyAlgorithmus.FONT_HISTORY);
        this.A.getLT().setBackground(AppletCholeskyAlgorithmus.COLOR_HISTORY);
        this.A.getLT().setFont(AppletCholeskyAlgorithmus.FONT_HISTORY);
        this.A.getVec().setBackground(AppletCholeskyAlgorithmus.COLOR_HISTORY);
        this.A.getVec().setFont(AppletCholeskyAlgorithmus.FONT_HISTORY);
        this.A = this.A.clone();
        this.history.add(new History(this.A));
        this.addSteppToHistory();
    }

    protected abstract void addSteppToHistory();

    public void removeStepFromHistory() throws ExtendedException {
        if (this.history.size() > 1) {
            this.history.remove(this.history.lastElement());
            this.removeStepFromHistoryImpl();
            this.A = this.history.lastElement().A;
            this.A.setBorderByIndex(-1, -1, null);
            this.initGLS(false);
            this.setTitleStep();
            this.main.report.reportSuccess(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelMain.12"));
        }
    }

    public void goToFirstHistroyEntry() throws ExtendedException {
        while (this.history.size() > 1) {
            this.removeStepFromHistory();
        }
    }

    protected abstract void removeStepFromHistoryImpl();

    public void setView(int view) throws ExtendedException {
        MatrixPanelCholesky A = null;
        for (History h : this.history) {
            A = h.A;
            if (A == null) continue;
            A.setView(view);
            if (A.getL() != null) {
                A.getL().setView(view);
            }
            if (A.getLT() == null) continue;
            A.getLT().setView(view);
        }
    }

    public void choleskyAlgorithmus() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        this.A.setSolved(false);
        while (!this.A.isSolved()) {
            this.step();
        }
    }

    public void solve() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        this.choleskyAlgorithmus();
    }

    public void step() throws ExtendedException {
        if (this.A == null) {
            return;
        }
        this.main.report.reportSuccess(this.setTitleStep());
        this.solveStep();
        this.setTitleStep();
    }

    public String setTitleStep() throws ExtendedException {
        String msg = this.A == null ? Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.5") : Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelMain.11");
        this.panelControl.setTitleStep(msg);
        return msg;
    }

    public abstract void setBorder();

    protected abstract void solveStep() throws ExtendedException;

    public MatrixPanelCholesky getA() {
        return this.A;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        try {
            this.setTitleStep();
            if (this.main.isCholesky()) {
                this.main.getPanelControl().setAlgoVisible(true);
            } else {
                this.main.getPanelControl().setAlgoVisible(false);
            }
        }
        catch (ExtendedException e1) {
            e1.printStackTrace();
        }
    }

    public void setPrecision(int i) {
        if (this.A != null) {
            this.A.setPrecision(i);
        }
        for (History h : this.history) {
            if (h.A == null) continue;
            h.A.setPrecision(i);
        }
    }

    protected class History
    extends MPanel {
        MatrixPanelCholesky A;
        int index = 0;

        public History(MatrixPanelCholesky A) {
            this.A = A;
        }
    }
}

