/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.choleskyAlgorithmus;

import java.awt.Component;
import javax.swing.BoxLayout;
import uibk.applets.choleskyAlgorithmus.AppletCholeskyAlgorithmus;
import uibk.applets.choleskyAlgorithmus.ExampleData;
import uibk.applets.choleskyAlgorithmus.PanelControl;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.numberPanel.IrrationalNumber;
import uibk.mtk.math.numberPanel.MatrixPanelCholesky;
import uibk.mtk.math.numberPanel.MyNumber;
import uibk.mtk.math.numberPanel.RationalNumber;
import uibk.mtk.swing.appletbase.PanelLoadExample;
import uibk.mtk.swing.base.MPanel;

public class PanelExampleData
extends MPanel {
    private final AppletCholeskyAlgorithmus main;
    private final PanelControl controlPanel;

    public PanelExampleData(AppletCholeskyAlgorithmus main, PanelControl controlPanel) {
        this.main = main;
        this.controlPanel = controlPanel;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createPanelLoadDataExamples());
    }

    private MPanel createPanelLoadDataExamples() {
        PanelLoadExample.LoadAction action = new PanelLoadExample.LoadAction(){

            public void execute(String item) {
                try {
                    PanelExampleData.this.loadexample(item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        String[] names = ExampleData.getAllSetNames();
        PanelLoadExample.LoadAction[] actions = new PanelLoadExample.LoadAction[]{action, action, action, action, action, action, action, action, action, action};
        return new PanelLoadExample(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelExampleData.0"), Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelExampleData.1"), names, actions);
    }

    private void loadexample(String item) throws ExtendedException {
        int j;
        ExampleData.DataSet dataset = ExampleData.getByName(item);
        if (dataset.zae_A == null) {
            return;
        }
        int row = dataset.nen_A.length;
        int colA = dataset.nen_A[0].length;
        MyNumber[][] data = new RationalNumber[row][colA];
        int i = 0;
        while (i < row) {
            j = 0;
            while (j < colA) {
                data[i][j] = new RationalNumber(dataset.zae_A[i][j], dataset.nen_A[i][j], this.controlPanel.getView(), (Component)this.main);
                ++j;
            }
            ++i;
        }
        MatrixPanelCholesky A = new MatrixPanelCholesky(data);
        this.main.mainPanel[0].newGLS(A);
        data = new IrrationalNumber[row][colA];
        i = 0;
        while (i < row) {
            j = 0;
            while (j < colA) {
                data[i][j] = new IrrationalNumber(1.0 * (double)dataset.zae_A[i][j] / (double)dataset.nen_A[i][j], 2, (Component)this.main, 3);
                ++j;
            }
            ++i;
        }
        A = new MatrixPanelCholesky(data);
        this.main.mainPanel[1].newGLS(A);
        int i2 = 0;
        while (i2 < A.getColumnDim()) {
            A.getL().setValueAtIntern(i2, i2, new IrrationalNumber(2, A.getParent(), A.getPrecision()));
            A.getVec().setValueAt(i2, 0, new IrrationalNumber(2, A.getParent(), A.getPrecision()));
            ++i2;
        }
    }
}

