/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.choleskyAlgorithmus;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.choleskyAlgorithmus.AppletCholeskyAlgorithmus;
import uibk.applets.choleskyAlgorithmus.PanelExampleData;
import uibk.mtk.lang.Messages;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelControl
extends MPanel
implements ActionListener,
ChangeListener {
    private final AppletCholeskyAlgorithmus main;
    private final IntegerTextField rows = new IntegerTextField(10, 1, 10, Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.14"));
    private final TitledPanel panelGauss = this.buttonsStep();
    private JTextArea algorithmus = new JTextArea(12, 10);
    private JSpinner spinner;

    public PanelControl(AppletCholeskyAlgorithmus main) {
        this.main = main;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new PanelExampleData(this.main, this));
        this.add(this.createEmtyMatrixPanel());
        this.add(this.panelGauss);
        this.add(this.spinnerPre());
        this.add(this.algoText());
        this.add(Box.createVerticalGlue());
        this.add(this.buttonsControl());
    }

    private TitledPanel createEmtyMatrixPanel() {
        TitledPanel titlePanel = new TitledPanel(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.13"));
        titlePanel.setLayout(new GridBagLayout());
        titlePanel.setMaximumSize(new Dimension(2000, 120));
        JLabel labelRows = new JLabel("Dimension");
        this.setMaximumSize(new Dimension(2000, 120));
        titlePanel.add((Component)labelRows, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.rows, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JButton creat = new JButton(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.0"));
        titlePanel.add((Component)creat, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 0, 0, 0), 0, 0));
        creat.addActionListener(this);
        creat.setActionCommand("create");
        return titlePanel;
    }

    private TitledPanel buttonsStep() {
        TitledPanel panel = new TitledPanel(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.5"));
        JButton step = new JButton(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.2"));
        JButton rev = new JButton(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.4"));
        panel.setMaximumSize(new Dimension(1000, 20));
        panel.add(step);
        panel.add(rev);
        step.addActionListener(this);
        step.setActionCommand("step");
        step.setPreferredSize(new Dimension(100, 23));
        rev.addActionListener(this);
        rev.setActionCommand("rev");
        rev.setPreferredSize(new Dimension(100, 23));
        return panel;
    }

    private MPanel spinnerPre() {
        TitledPanel panel = new TitledPanel("Genauigkeit");
        panel.setMaximumSize(new Dimension(1000, 100));
        panel.setLayout(new GridBagLayout());
        SpinnerNumberModel model = new SpinnerNumberModel(3, 1, 15, 1);
        this.spinner = new JSpinner(model);
        this.spinner.addChangeListener(this);
        JLabel labelRows = new JLabel("Anzahl der Nachkommerstellen");
        panel.add((Component)labelRows, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.spinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private MPanel algoText() {
        MPanel panel = new MPanel();
        panel.setMaximumSize(new Dimension(1000, 20));
        this.algorithmus.setFont(new Font("Dialog", 0, 14));
        this.algorithmus.setEditable(false);
        this.algorithmus.append("for k = 1:n \n  if H(k,k) <= 0 \n    error;\n  end \n  C(k,k) = sqrt(H(k,k)); \n  for i = k+1:n \n    C(i,k) = H(i,k)/C(k,k); \n    for j = k+1:i \n      H(i,j) = H(i,j)-C(i,k)*C(j,k); \n    end \n  end \nend");
        this.algorithmus.setBackground(this.panelGauss.getBackground());
        panel.add(this.algorithmus);
        return panel;
    }

    private MPanel buttonsControl() {
        MPanel panel = new MPanel();
        panel.setMaximumSize(new Dimension(1000, 100));
        JButton solve = new JButton(Messages.getString("uibk.applets.choleskyAlgorithmus.messages", "PanelControl.3"));
        panel.add(solve);
        solve.addActionListener(this);
        solve.setActionCommand("solve");
        return panel;
    }

    public void actionPerformed(ActionEvent ev) {
        try {
            if (ev.getActionCommand() == "create") {
                this.main.getSelectedMainPanel().newGLS(this.rows.getValue(), this.rows.getValue());
            } else if (ev.getActionCommand() == "step") {
                this.main.getSelectedMainPanel().step();
            } else if (ev.getActionCommand() == "solve") {
                this.main.getSelectedMainPanel().solve();
            } else if (ev.getActionCommand() == "rev") {
                this.main.getSelectedMainPanel().removeStepFromHistory();
            }
        }
        catch (Exception e) {
            this.main.report.reportException(null, e, this.main);
            e.printStackTrace();
        }
        this.main.setMainPanel();
    }

    public int getView() {
        return 1;
    }

    public void setTitleStep(String title) {
        this.panelGauss.setBorderTitle(title);
        this.panelGauss.repaint();
    }

    public void setAlgoVisible(boolean vis) {
        this.spinner.setEnabled(vis);
        this.algorithmus.setVisible(vis);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.spinner)) {
            int i = (Integer)this.spinner.getValue();
            this.main.mainPanel[1].setPrecision(i);
            this.main.setMainPanel();
        }
    }
}

