/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import umontreal.iro.lecuyer.util.MathFunction;

public class Misc {
    private Misc() {
    }

    public static double quickSelect(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double d = dArray[n2 - 1];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] <= d) {
                ++n4;
                if (dArray[i] == d) continue;
                dArray2[n3++] = dArray[i];
                continue;
            }
            dArray3[n5++] = dArray[i];
        }
        if (n2 <= n3) {
            return Misc.quickSelect(dArray2, n3, n2);
        }
        if (n2 > n4) {
            return Misc.quickSelect(dArray3, n5, n2 - n4);
        }
        return d;
    }

    public static int quickSelect(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n3 = nArray[n2 - 1];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= n3) {
                ++n5;
                if (nArray[i] == n3) continue;
                nArray2[n4++] = nArray[i];
                continue;
            }
            nArray3[n6++] = nArray[i];
        }
        if (n2 <= n4) {
            return Misc.quickSelect(nArray2, n4, n2);
        }
        if (n2 > n5) {
            return Misc.quickSelect(nArray3, n6, n2 - n5);
        }
        return n3;
    }

    public static int getTimeInterval(double[] dArray, int n, int n2, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The starting index must not be negative");
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException("The ending index must be greater than or equal to the starting index");
        }
        if (d < dArray[n]) {
            return -1;
        }
        if (d >= dArray[n2]) {
            return n3;
        }
        int n4 = n;
        int n5 = (n + n2) / 2;
        while (d < dArray[n5] || d >= dArray[n5 + 1]) {
            if (n == n2) {
                throw new IllegalStateException();
            }
            if (d < dArray[n5]) {
                n2 = n5 - 1;
            } else {
                n = n5 + 1;
            }
            n5 = (n + n2) / 2;
        }
        return n5 - n4;
    }

    public static void interpol(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        for (n2 = 0; n2 <= n; ++n2) {
            dArray3[n2] = dArray2[n2];
        }
        for (int i = 1; i <= n; ++i) {
            for (n2 = n; n2 >= i; --n2) {
                dArray3[n2] = (dArray3[n2] - dArray3[n2 - 1]) / (dArray[n2] - dArray[n2 - i]);
            }
        }
    }

    public static double evalPoly(int n, double[] dArray, double[] dArray2, double d) {
        double d2 = dArray2[n];
        for (int i = n - 1; i >= 0; --i) {
            d2 = d2 * (d - dArray[i]) + dArray2[i];
        }
        return d2;
    }

    public static double simpsonIntegral(MathFunction mathFunction, double d, double d2, int n) {
        if (n % 2 != 0) {
            throw new IllegalArgumentException("numIntervals must be an even number");
        }
        if (Double.isInfinite(d) || Double.isInfinite(d2) || Double.isNaN(d) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("a and b must not be infinite or NaN");
        }
        if (d2 < d) {
            throw new IllegalArgumentException("b < a");
        }
        if (d == d2) {
            return 0.0;
        }
        double d3 = (d2 - d) / (double)n;
        double d4 = 2.0 * d3;
        int n2 = n / 2;
        double d5 = 0.0;
        for (int i = 0; i < n2 - 1; ++i) {
            double d6 = d + d3 + 2.0 * d3 * (double)i;
            d5 += 4.0 * mathFunction.evaluate(d6) + 2.0 * mathFunction.evaluate(d6 + d3);
        }
        return (d5 += mathFunction.evaluate(d) + mathFunction.evaluate(d2) + 4.0 * mathFunction.evaluate(d2 - d3)) * d3 / 3.0;
    }
}

