/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat.list.lincv;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.stat.TallyStore;
import umontreal.iro.lecuyer.stat.list.ListOfTalliesWithCovariance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOfTalliesWithCV<E extends Tally>
extends ListOfTalliesWithCovariance<E> {
    private static Algebra alg = new Algebra();
    private DoubleMatrix2D beta;
    private double[] exp;
    private double[] tmp;
    private int q;
    private DoubleMatrix2D tempPP;
    private DoubleMatrix2D tempQQ;
    private DoubleMatrix2D tempPQ;
    private DoubleMatrix2D tempQP;

    public ListOfTalliesWithCV() {
    }

    public ListOfTalliesWithCV(String string) {
        super(string);
    }

    public static ListOfTalliesWithCV<Tally> createWithTally(int n, int n2) {
        ListOfTalliesWithCV<Tally> listOfTalliesWithCV = new ListOfTalliesWithCV<Tally>();
        int n3 = n + n2;
        for (int i = 0; i < n3; ++i) {
            listOfTalliesWithCV.add(new Tally());
        }
        listOfTalliesWithCV.setNumControlVariables(n2);
        listOfTalliesWithCV.init();
        return listOfTalliesWithCV;
    }

    public static ListOfTalliesWithCV<TallyStore> createWithTallyStore(int n, int n2) {
        ListOfTalliesWithCV<TallyStore> listOfTalliesWithCV = new ListOfTalliesWithCV<TallyStore>();
        int n3 = n + n2;
        for (int i = 0; i < n3; ++i) {
            listOfTalliesWithCV.add(new TallyStore());
        }
        listOfTalliesWithCV.setNumControlVariables(n2);
        listOfTalliesWithCV.init();
        return listOfTalliesWithCV;
    }

    @Override
    public void init() {
        super.init();
        this.internalInit();
    }

    private void internalInit() {
        int n = this.sizeWithoutCV();
        this.beta = new DenseDoubleMatrix2D(this.q, n);
        this.exp = new double[this.q];
        this.tmp = new double[n + this.q];
        this.tempPP = new DenseDoubleMatrix2D(n, n);
        this.tempQQ = new DenseDoubleMatrix2D(this.q, this.q);
        this.tempPQ = new DenseDoubleMatrix2D(n, this.q);
        this.tempQP = new DenseDoubleMatrix2D(this.q, n);
        this.setUnmodifiable();
    }

    public DoubleMatrix2D getBeta() {
        return this.beta;
    }

    public void setBeta(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.getNumControlVariables()) {
            throw new IllegalArgumentException("The number of rows in beta must be equal to q");
        }
        if (doubleMatrix2D.columns() != this.sizeWithoutCV()) {
            throw new IllegalArgumentException("The number of columns in beta must be equal to p");
        }
        this.beta = doubleMatrix2D;
    }

    public double getExpectedValue(int n) {
        return this.exp[n];
    }

    public void setExpectedValue(int n, double d) {
        this.exp[n] = d;
    }

    public double[] getExpectedValues() {
        return this.exp;
    }

    public void setExpectedValues(double[] dArray) {
        if (dArray.length != this.exp.length) {
            throw new IllegalArgumentException("Invalid length of exp");
        }
        this.exp = dArray;
    }

    public int sizeWithoutCV() {
        return this.size() - this.q;
    }

    public int getNumControlVariables() {
        return this.q;
    }

    public void setNumControlVariables(int n) {
        if (this.beta != null) {
            throw new IllegalArgumentException("Cannot change the number of control variables");
        }
        if (n < 0 || n >= this.size()) {
            throw new IllegalArgumentException("q is negative or greater than or equal to " + this.size());
        }
        this.q = n;
    }

    public void correlationX(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        if (doubleMatrix2D.rows() != n) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                doubleMatrix2D.setQuick(i, j, this.correlation(i, j));
            }
        }
    }

    public void covarianceX(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        if (doubleMatrix2D.rows() != n) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                doubleMatrix2D.setQuick(i, j, this.covariance(i, j));
            }
        }
    }

    public void correlationC(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        int n2 = this.getNumControlVariables();
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2D.setQuick(i, j, this.correlation(n + i, n + j));
            }
        }
    }

    public void covarianceC(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        int n2 = this.getNumControlVariables();
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                doubleMatrix2D.setQuick(i, j, this.covariance(n + i, n + j));
            }
        }
    }

    public void correlationCX(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        int n2 = this.getNumControlVariables();
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                doubleMatrix2D.setQuick(i, j, this.correlation(n + i, j));
            }
        }
    }

    public void covarianceCX(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        int n2 = this.getNumControlVariables();
        if (doubleMatrix2D.rows() != n2) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (doubleMatrix2D.columns() != n) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                doubleMatrix2D.setQuick(i, j, this.covariance(n + i, j));
            }
        }
    }

    public void add(double[] dArray, double[] dArray2) {
        if (dArray.length != this.sizeWithoutCV()) {
            throw new IllegalArgumentException("Invalid length of x");
        }
        if (dArray2.length != this.getNumControlVariables()) {
            throw new IllegalArgumentException("Invalid length of c");
        }
        System.arraycopy(dArray, 0, this.tmp, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.tmp, dArray.length, dArray2.length);
        this.add(this.tmp);
    }

    public void add(double d, double[] dArray) {
        if (this.sizeWithoutCV() != 1) {
            throw new IllegalArgumentException("Cannot use this method if p != 1");
        }
        if (dArray.length != this.getNumControlVariables()) {
            throw new IllegalArgumentException("Invalid length of c");
        }
        this.tmp[0] = d;
        System.arraycopy(dArray, 0, this.tmp, 1, dArray.length);
        this.add(this.tmp);
    }

    public void add(double d, double d2) {
        if (this.sizeWithoutCV() != 1) {
            throw new IllegalArgumentException("Cannot use this method if p != 1");
        }
        if (this.getNumControlVariables() != 1) {
            throw new IllegalArgumentException("Cannot use this method if q != 1");
        }
        this.tmp[0] = d;
        this.tmp[1] = d2;
        this.add(this.tmp);
    }

    public double averageWithCV(int n) {
        int n2 = this.sizeWithoutCV();
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        Tally tally = (Tally)this.get(n);
        if (tally == null || tally.numberObs() == 0) {
            return Double.NaN;
        }
        double d = tally.average();
        for (int i = 0; i < this.q; ++i) {
            d -= this.beta.getQuick(i, n) * (((Tally)this.get(n2 + i)).average() - this.exp[i]);
        }
        return d;
    }

    public void covarianceWithCV(DoubleMatrix2D doubleMatrix2D) {
        int n = this.sizeWithoutCV();
        int n2 = this.getNumControlVariables();
        if (doubleMatrix2D.rows() != n || doubleMatrix2D.columns() != n2) {
            throw new IllegalArgumentException("Invalid dimensions of covCV");
        }
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D;
        this.covarianceX(doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D3 = this.tempQQ;
        this.covarianceC(doubleMatrix2D3);
        DoubleMatrix2D doubleMatrix2D4 = this.tempQP;
        this.covarianceCX(doubleMatrix2D4);
        this.beta.viewDice().zMult(doubleMatrix2D3, this.tempPQ).zMult(this.beta, doubleMatrix2D, 1.0, 1.0, false, false);
        this.beta.viewDice().zMult(doubleMatrix2D4, doubleMatrix2D, -2.0, 1.0, false, false);
    }

    public double covarianceWithCV(int n, int n2) {
        int n3 = this.sizeWithoutCV();
        if (n >= n3 || n2 >= n3) {
            throw new IllegalArgumentException("i >= p or j >= p");
        }
        double d = this.covariance(n, n2);
        DoubleMatrix2D doubleMatrix2D = this.tempQQ;
        this.covarianceC(doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = this.tempQP;
        this.covarianceCX(doubleMatrix2D2);
        d += this.beta.viewColumn(n).zDotProduct(doubleMatrix2D.zMult(this.beta.viewColumn(n2), null));
        d -= doubleMatrix2D2.viewColumn(n).zDotProduct(this.beta.viewColumn(n2));
        return d -= doubleMatrix2D2.viewColumn(n2).zDotProduct(this.beta.viewColumn(n));
    }

    public void averageWithCV(double[] dArray) {
        int n = this.sizeWithoutCV();
        if (dArray.length != n) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + dArray.length + ", required length is " + n);
        }
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.averageWithCV(i);
        }
    }

    public void averageX(double[] dArray) {
        int n = this.sizeWithoutCV();
        if (dArray.length != n) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + dArray.length + ", required length is " + n);
        }
        for (int i = 0; i < dArray.length; ++i) {
            Tally tally = (Tally)this.get(i);
            double d = dArray[i] = tally == null ? Double.NaN : tally.average();
            if (tally.numberObs() != 0) continue;
            dArray[i] = Double.NaN;
        }
    }

    public void averageC(double[] dArray) {
        int n = this.sizeWithoutCV();
        int n2 = this.getNumControlVariables();
        if (dArray.length != n2) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + dArray.length + ", required length is " + n2);
        }
        for (int i = 0; i < dArray.length; ++i) {
            Tally tally = (Tally)this.get(i + n);
            double d = dArray[i] = tally == null ? Double.NaN : tally.average();
            if (tally.numberObs() != 0) continue;
            dArray[i] = Double.NaN;
        }
    }

    public void standardDeviationWithCV(double[] dArray) {
        int n = this.sizeWithoutCV();
        if (n != dArray.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        DoubleMatrix2D doubleMatrix2D = this.tempPP;
        this.covarianceWithCV(doubleMatrix2D);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.sqrt(doubleMatrix2D.getQuick(i, i));
        }
    }

    public void varianceWithCV(double[] dArray) {
        int n = this.sizeWithoutCV();
        if (n != dArray.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        DoubleMatrix2D doubleMatrix2D = this.tempPP;
        this.covarianceWithCV(doubleMatrix2D);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = doubleMatrix2D.getQuick(i, i);
        }
    }

    public void confidenceIntervalStudentWithCV(int n, double d, double[] dArray) {
        Tally tally = (Tally)this.get(n);
        int n2 = tally.numberObs();
        if (n2 < 2) {
            throw new RuntimeException("Calling confidenceIntervalStudent with < 2 Observations");
        }
        dArray[0] = this.averageWithCV(n);
        double d2 = StudentDist.inverseF(n2 - 1, 0.5 * (d + 1.0));
        dArray[1] = d2 * Math.sqrt(this.covarianceWithCV(n, n) / (double)n2);
    }

    public void estimateBeta() {
        DoubleMatrix2D doubleMatrix2D = this.tempQQ;
        this.covarianceC(doubleMatrix2D);
        DoubleMatrix2D doubleMatrix2D2 = this.tempQP;
        this.covarianceCX(doubleMatrix2D2);
        this.beta = alg.solve(doubleMatrix2D, doubleMatrix2D2);
        assert (this.beta.rows() == this.getNumControlVariables() && this.beta.columns() == this.sizeWithoutCV());
    }

    @Override
    public ListOfTalliesWithCV<E> clone() {
        ListOfTalliesWithCV listOfTalliesWithCV = (ListOfTalliesWithCV)super.clone();
        listOfTalliesWithCV.beta = (DoubleMatrix2D)this.beta.clone();
        listOfTalliesWithCV.exp = (double[])this.exp.clone();
        listOfTalliesWithCV.tmp = (double[])this.tmp.clone();
        listOfTalliesWithCV.q = this.q;
        listOfTalliesWithCV.tempPP = (DoubleMatrix2D)this.tempPP.clone();
        listOfTalliesWithCV.tempQQ = (DoubleMatrix2D)this.tempQQ.clone();
        listOfTalliesWithCV.tempPQ = (DoubleMatrix2D)this.tempPQ.clone();
        listOfTalliesWithCV.tempQP = (DoubleMatrix2D)this.tempQP.clone();
        return listOfTalliesWithCV;
    }
}

