/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.AbstractSimProcess;
import umontreal.iro.lecuyer.simprocs.SimThread;

public abstract class SimProcess
extends AbstractSimProcess {
    public SimProcess() {
        this.scheduledEvent = SimThread.getThread(this);
    }

    public static void init() {
        Sim.init();
    }

    public static void init(EventList eventList) {
        Sim.init(eventList);
    }

    public void delay(double d) {
        if (current != this) {
            throw new IllegalStateException("Calling delay() for a process not in EXECUTING state");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Calling delay() with negative delay");
        }
        this.scheduledEvent.schedule(d);
        SimProcess.dispatch();
        ((SimThread)this.scheduledEvent).passivate();
    }

    public void suspend() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Calling suspend() for a dead process");
        }
        if (current == this) {
            SimProcess.dispatch();
            ((SimThread)this.scheduledEvent).passivate();
            return;
        }
        if (this.scheduledEvent.time() >= 0.0) {
            this.scheduledEvent.cancel();
            this.scheduledEvent.setTime(-10.0);
            return;
        }
        if (this.scheduledEvent.time() == -20.0) {
            throw new IllegalStateException("Calling suspend() for a process in INITIAL state");
        }
        throw new IllegalStateException("Calling suspend() for a suspended process");
    }

    public void kill() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("cannot kill a DEAD process");
        }
        ((SimThread)this.scheduledEvent).kill();
    }

    public static void killAll() {
        SimThread.killAll();
    }

    protected static void dispatch() {
        Event event;
        while ((event = Sim.removeFirstEvent()) != null) {
            if (event instanceof SimThread) {
                current = ((SimThread)event).myProcess;
                ((SimThread)event).activate();
                return;
            }
            event.actions();
        }
        SimThread.simActivate();
    }
}

