/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.ListIterator;
import umontreal.iro.lecuyer.simevents.Accumulate;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.AbstractSimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Resource {
    private static final int FIFO = 1;
    private static final int LIFO = 2;
    private String name;
    private int capacity = 0;
    private int available = 0;
    private int policy = 1;
    private LinkedListStat<UserRecord> serviceList;
    private LinkedListStat<UserRecord> waitingList;
    private boolean stats = false;
    private double initStatTime;
    private Accumulate statUtil;
    private Accumulate statCapacity;
    private Tally statSojourn;

    public Resource(int n) {
        this(n, "");
    }

    public Resource(int n, String string) {
        this.capacity = this.available = n;
        this.name = string;
        this.serviceList = new LinkedListStat(" Service List for " + string);
        this.waitingList = new LinkedListStat(" Waiting List for " + string);
    }

    public void setStatCollecting(boolean bl) {
        if (bl) {
            if (this.stats) {
                throw new IllegalStateException("Already collecting statistics for this resource");
            }
            this.stats = true;
            this.waitingList.setStatCollecting(true);
            this.serviceList.setStatCollecting(true);
            if (this.statUtil != null) {
                this.initStat();
            } else {
                this.statUtil = new Accumulate("StatOnUtil");
                this.statUtil.update(this.capacity - this.available);
                this.statCapacity = new Accumulate("StatOnCapacity");
                this.statCapacity.update(this.capacity);
                this.statSojourn = new Tally("StatOnSojourn");
            }
        } else {
            if (!this.stats) {
                throw new IllegalStateException("Not collecting statistics for this resource");
            }
            this.stats = false;
            this.waitingList.setStatCollecting(false);
            this.serviceList.setStatCollecting(false);
        }
    }

    public void initStat() {
        if (!this.stats) {
            throw new IllegalStateException("Not collecting statistics for this resource");
        }
        this.statUtil.init();
        this.statUtil.update(this.capacity - this.available);
        this.statCapacity.init();
        this.statCapacity.update(this.capacity);
        this.statSojourn.init();
        this.serviceList.initStat();
        this.waitingList.initStat();
        this.initStatTime = Sim.time();
    }

    public void init() {
        this.serviceList.clear();
        this.waitingList.clear();
        this.available = this.capacity;
        if (this.stats) {
            this.initStat();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setPolicyFIFO() {
        this.policy = 1;
    }

    public void setPolicyLIFO() {
        this.policy = 2;
    }

    public void changeCapacity(int n) {
        if (n > 0) {
            this.available += n;
            this.capacity += n;
            if (this.waitingList.size() > 0) {
                this.startNewCust();
            }
        } else {
            if (-n > this.available) {
                throw new IllegalArgumentException("Trying to diminish the capacity of a resource more than its current availability");
            }
            this.available -= -n;
            this.capacity -= -n;
        }
        if (this.stats) {
            this.statCapacity.update(this.capacity);
        }
    }

    public void setCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity cannot be negative");
        }
        this.changeCapacity(n - this.capacity);
    }

    public int getAvailable() {
        return this.available;
    }

    public void request(int n) {
        AbstractSimProcess abstractSimProcess = AbstractSimProcess.current;
        UserRecord userRecord = new UserRecord(n, abstractSimProcess);
        if (n <= this.available) {
            this.available -= n;
            this.serviceList.addLast(userRecord);
            if (this.stats) {
                this.waitingList.statSojourn().add(0.0);
                this.statUtil.update(this.capacity - this.available);
            }
        } else {
            switch (this.policy) {
                case 1: {
                    this.waitingList.addLast(userRecord);
                    break;
                }
                case 2: {
                    this.waitingList.addFirst(userRecord);
                    break;
                }
                default: {
                    throw new IllegalStateException("policy must be FIFO or LIFO");
                }
            }
            abstractSimProcess.suspend();
        }
    }

    private void startNewCust() {
        ListIterator listIterator = this.waitingList.listIterator();
        while (listIterator.hasNext() && this.available > 0) {
            UserRecord userRecord = (UserRecord)listIterator.next();
            if (userRecord.process.getState() == 4) {
                listIterator.remove();
                continue;
            }
            if (userRecord.numUnits > this.available) continue;
            this.serviceList.addLast(userRecord);
            userRecord.process.resume();
            this.available -= userRecord.numUnits;
            listIterator.remove();
        }
    }

    public void release(int n) {
        AbstractSimProcess abstractSimProcess = AbstractSimProcess.currentProcess();
        int n2 = 0;
        ListIterator listIterator = this.serviceList.listIterator();
        while (n2 < n && listIterator.hasNext()) {
            UserRecord userRecord = (UserRecord)listIterator.next();
            if (abstractSimProcess != userRecord.process) continue;
            if ((n2 += userRecord.numUnits) <= n) {
                listIterator.remove();
                if (!this.stats) continue;
                this.statSojourn.add(Sim.time() - userRecord.requestTime);
                continue;
            }
            userRecord.numUnits = n2 - n;
            n2 = n;
        }
        if (n2 < n) {
            throw new IllegalArgumentException("trying to release more units of a Resource than the process currently holds");
        }
        this.available += n2;
        if (this.waitingList.size() > 0) {
            this.startNewCust();
        }
        if (this.stats) {
            this.statUtil.update(this.capacity - this.available);
        }
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public LinkedListStat servList() {
        return this.serviceList;
    }

    public Accumulate statOnCapacity() {
        return this.statCapacity;
    }

    public Accumulate statOnUtil() {
        return this.statUtil;
    }

    public Tally statOnSojourn() {
        return this.statSojourn;
    }

    public String getName() {
        return this.name;
    }

    public String report() {
        if (this.statUtil == null) {
            throw new IllegalStateException("Asking a report for a resource for which setStatCollecting (true) has not been called");
        }
        Accumulate accumulate = this.waitingList.statSize();
        Tally tally = this.waitingList.statSojourn();
        Tally tally2 = this.serviceList.statSojourn();
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("REPORT ON RESOURCE : ").append(this.name).append('\n');
        printfFormat.append("   From time : ").append(7, 2, 2, this.initStatTime);
        printfFormat.append("   to time : ");
        printfFormat.append(10, 2, 2, Sim.time());
        printfFormat.append("\n                    min        max     average  ");
        printfFormat.append("standard dev.  nb. obs.");
        printfFormat.append("\n   Capacity    ");
        printfFormat.append(8, (int)(this.statCapacity.min() + 0.5));
        printfFormat.append(11, (int)(this.statCapacity.max() + 0.5));
        printfFormat.append(12, 3, 2, this.statCapacity.average());
        printfFormat.append("\n   Utilization ");
        printfFormat.append(8, (int)(this.statUtil.min() + 0.5));
        printfFormat.append(11, (int)(this.statUtil.max() + 0.5));
        printfFormat.append(12, 3, 2, this.statUtil.average());
        printfFormat.append("\n   Queue Size  ");
        printfFormat.append(8, (int)(accumulate.min() + 0.5));
        printfFormat.append(11, (int)(accumulate.max() + 0.5));
        printfFormat.append(12, 3, 2, accumulate.average());
        printfFormat.append("\n   Wait    ");
        printfFormat.append(12, 3, 2, tally.min()).append(' ');
        printfFormat.append(10, 3, 2, tally.max()).append(' ');
        printfFormat.append(11, 3, 2, tally.average()).append(' ');
        printfFormat.append(10, 3, 2, tally.standardDeviation());
        printfFormat.append(10, tally.numberObs());
        printfFormat.append("\n   Service ");
        printfFormat.append(12, 3, 2, tally2.min()).append(' ');
        printfFormat.append(10, 3, 2, tally2.max()).append(' ');
        printfFormat.append(11, 3, 2, tally2.average()).append(' ');
        printfFormat.append(10, 3, 2, tally2.standardDeviation());
        printfFormat.append(10, tally2.numberObs());
        printfFormat.append("\n   Sojourn ");
        printfFormat.append(12, 3, 2, this.statSojourn.min()).append(' ');
        printfFormat.append(10, 3, 2, this.statSojourn.max()).append(' ');
        printfFormat.append(11, 3, 2, this.statSojourn.average()).append(' ');
        printfFormat.append(10, 3, 2, this.statSojourn.standardDeviation());
        printfFormat.append(10, this.statSojourn.numberObs()).append('\n');
        return printfFormat.toString();
    }
}

