/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;

public abstract class AbstractSimProcess {
    public static final int INITIAL = 0;
    public static final int EXECUTING = 1;
    public static final int DELAYED = 2;
    public static final int SUSPENDED = 3;
    public static final int DEAD = 4;
    protected static final double STARTING = -20.0;
    protected static final double WAITING = -10.0;
    protected static AbstractSimProcess current;
    protected Event scheduledEvent = null;

    public void schedule(double d) {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Cannot schedule a dead process");
        }
        if (this.scheduledEvent.time() != -20.0) {
            throw new IllegalStateException("Only a process in INITIAL state can call schedule");
        }
        this.scheduledEvent.schedule(d);
    }

    public void scheduleNext() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Cannot schedule a dead process");
        }
        if (this.scheduledEvent.time() != -20.0) {
            throw new IllegalStateException("Only a process in INITIAL state can call scheduleNext");
        }
        this.scheduledEvent.scheduleNext();
    }

    public static AbstractSimProcess currentProcess() {
        return current;
    }

    public final boolean isAlive() {
        return this.scheduledEvent != null;
    }

    public int getState() {
        if (this.scheduledEvent == null) {
            return 4;
        }
        if (current == this) {
            return 1;
        }
        if (this.scheduledEvent.time() >= 0.0) {
            return 2;
        }
        if (this.scheduledEvent.time() == -20.0) {
            return 0;
        }
        return 3;
    }

    public double getDelay() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("Trying to getDelay() on a dead process");
        }
        if (this.scheduledEvent.time() < 0.0) {
            throw new IllegalStateException("Calling getDelay for a process not in DELAYED state");
        }
        return this.scheduledEvent.time() - Sim.time();
    }

    public abstract void delay(double var1);

    public void reschedule(double d) {
        if (current == this) {
            throw new IllegalStateException("reschedule() for a process in EXECUTING state");
        }
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("reschedule() for a dead process ");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Calling reschedule() with negative delay");
        }
        this.scheduledEvent.reschedule(d);
    }

    public abstract void suspend();

    public void resume() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("calling resume() for a dead process");
        }
        if (this.scheduledEvent.time() >= 0.0) {
            this.scheduledEvent.cancel();
        }
        this.scheduledEvent.scheduleNext();
    }

    public boolean cancel() {
        if (this.scheduledEvent == null) {
            throw new IllegalStateException("calling cancel() for a dead process");
        }
        if (this.scheduledEvent.time() < 0.0) {
            throw new IllegalStateException("cancel() for a process not in DELAYED state");
        }
        boolean bl = this.scheduledEvent.cancel();
        this.scheduledEvent.setTime(-10.0);
        return bl;
    }

    public abstract void kill();

    public abstract void actions();
}

