/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simexp;

import umontreal.iro.lecuyer.stat.FunctionOfMultipleMeansTally;
import umontreal.iro.lecuyer.stat.StatProbe;
import umontreal.iro.lecuyer.stat.Tally;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimExp {
    protected boolean simulating = false;

    public boolean isSimulating() {
        return this.simulating;
    }

    public abstract void simulate();

    public static int getRequiredNewObservations(StatProbe[] statProbeArray, double d, double d2) {
        int n = 0;
        for (StatProbe statProbe : statProbeArray) {
            int n2;
            int n3 = n2 = statProbe == null ? 0 : SimExp.getRequiredNewObservations(statProbe, d, d2);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static int getRequiredNewObservations(Iterable<? extends StatProbe> iterable, double d, double d2) {
        int n = 0;
        for (StatProbe statProbe : iterable) {
            int n2 = statProbe == null ? 0 : SimExp.getRequiredNewObservations(statProbe, d, d2);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static int getRequiredNewObservations(StatProbe statProbe, double d, double d2) {
        if (statProbe instanceof Tally) {
            return SimExp.getRequiredNewObservationsTally((Tally)statProbe, d, d2);
        }
        if (statProbe instanceof FunctionOfMultipleMeansTally) {
            return SimExp.getRequiredNewObservationsTally((FunctionOfMultipleMeansTally)statProbe, d, d2);
        }
        return 0;
    }

    public static int getRequiredNewObservationsTally(Tally tally, double d, double d2) {
        double[] dArray = new double[2];
        int n = tally.numberObs();
        if (n >= 2) {
            tally.confidenceIntervalStudent(d2, dArray);
        }
        return SimExp.getRequiredNewObservations(dArray[0], dArray[1], n, d);
    }

    public static int getRequiredNewObservationsTally(FunctionOfMultipleMeansTally functionOfMultipleMeansTally, double d, double d2) {
        double[] dArray = new double[2];
        int n = functionOfMultipleMeansTally.numberObs();
        if (n >= 2) {
            functionOfMultipleMeansTally.confidenceIntervalDelta(d2, dArray);
        }
        return SimExp.getRequiredNewObservations(dArray[0], dArray[1], n, d);
    }

    public static int getRequiredNewObservations(double d, double d2, int n, double d3) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The radius must not be negative");
        }
        if (d3 < 0.0) {
            throw new IllegalArgumentException("The target error must not be negative");
        }
        if (n < 1) {
            return 0;
        }
        double d4 = d3 * Math.abs(d);
        if (d2 <= d4) {
            return 0;
        }
        double d5 = d2 * Math.sqrt(n);
        double d6 = d5 / d4;
        double d7 = d6 * d6;
        int n2 = (int)Math.round(d7) - n;
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }
}

