/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simexp;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import java.lang.ref.SoftReference;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simexp.SimExp;
import umontreal.iro.lecuyer.util.Misc;

public abstract class BatchMeansSim
extends SimExp {
    private DoubleArrayList batchTimes = new DoubleArrayList();
    private boolean batchLengths;
    private boolean aggregation;
    private int minBatches;
    private int maxBatches;
    private double warmupTime;
    private EndSimEvent endSimEvent;
    private boolean warmupDone;
    private int targetBatches;
    private int doneBatches;
    private int droppedBatches;
    private double batchFraction;
    private double batchSizeMultiplier;
    private boolean aggregateUpdated;
    private double batchSize;
    private int nAgr;

    public BatchMeansSim(int n, double d, double d2) {
        this(n, Integer.MAX_VALUE, d, d2);
    }

    public BatchMeansSim(int n, int n2, double d, double d2) {
        if (n <= 0) {
            throw new IllegalArgumentException("minBatches <= 0");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("maxBatches < minBatches");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Warmup time must not be negative");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("Batch size must not be 0 or negative");
        }
        this.minBatches = n;
        this.maxBatches = n2;
        this.warmupTime = d2;
        this.batchSize = d;
        this.targetBatches = n;
    }

    public boolean getBatchAggregation() {
        return this.aggregation;
    }

    public void setBatchAggregation(boolean bl) {
        if (this.warmupDone && this.simulating) {
            throw new IllegalStateException("Cannot change the aggregation status during simulation");
        }
        this.aggregation = bl;
    }

    public boolean getBatchLengthsKeeping() {
        return this.batchLengths;
    }

    public void setBatchLengthsKeeping(boolean bl) {
        if (this.warmupDone && this.simulating) {
            throw new IllegalStateException("Cannot change the aggregation status during simulation");
        }
        this.batchLengths = bl;
    }

    public int getMinBatches() {
        return this.minBatches;
    }

    public void setMinBatches(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("minBatches <= 0");
        }
        this.minBatches = n;
        if (this.maxBatches < n) {
            this.maxBatches = n;
        }
    }

    public int getMaxBatches() {
        return this.maxBatches;
    }

    public void setMaxBatches(int n) {
        if (n < this.minBatches) {
            throw new IllegalArgumentException("maxBatches < minBatches");
        }
        this.maxBatches = n;
    }

    public double getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("batchSize <= 0");
        }
        this.batchSize = d;
    }

    public double getWarmupTime() {
        return this.warmupTime;
    }

    public void setWarmupTime(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("warmupTime < 0");
        }
        this.warmupTime = d;
    }

    public double getBatchFraction() {
        return this.batchFraction;
    }

    public double getBatchSizeMultiplier() {
        return this.batchSizeMultiplier;
    }

    public int getTargetBatches() {
        return this.targetBatches;
    }

    public void setTargetBatches(int n) {
        if (n < this.minBatches) {
            throw new IllegalArgumentException("Target number of batches too small");
        }
        if (n > this.maxBatches) {
            throw new IllegalArgumentException("Target number of batches too large");
        }
        this.targetBatches = n;
    }

    public int getCompletedRealBatches() {
        return this.doneBatches;
    }

    public int getDroppedRealBatches() {
        return this.droppedBatches;
    }

    public void dropFirstRealBatches(int n) {
        if (n < 0 || n > this.doneBatches - this.droppedBatches) {
            throw new IllegalArgumentException("Cannot drop less than 0 or more than " + (this.doneBatches - this.droppedBatches) + " real batches");
        }
        if (this.batchLengths || this.aggregation) {
            this.batchTimes.removeFromTo(0, n - 1);
        }
        this.droppedBatches += n;
    }

    public int getBatch(double d) {
        if (!this.warmupDone) {
            return -1;
        }
        if (!this.batchLengths && !this.aggregation) {
            return -1;
        }
        if (this.batchTimes.size() == 0) {
            return -1;
        }
        return Misc.getTimeInterval(this.batchTimes.elements(), 0, this.doneBatches, d);
    }

    public boolean isWarmupDone() {
        return this.warmupDone;
    }

    public int getNumAggregates() {
        if (this.nAgr == 0) {
            throw new IllegalStateException("Number of real batches not available");
        }
        return this.nAgr;
    }

    public double getRealBatchLength(int n) {
        if (this.batchLengths || this.aggregation) {
            return this.batchTimes.get(n + 1 - this.droppedBatches) - this.batchTimes.getQuick(n - this.droppedBatches);
        }
        if (n != this.doneBatches - 1) {
            throw new IllegalArgumentException("Unavailable batch length");
        }
        return this.batchTimes.getQuick(1) - this.batchTimes.getQuick(0);
    }

    public double getRealBatchStartingTime(int n) {
        if (this.batchLengths || this.aggregation) {
            return this.batchTimes.get(n);
        }
        if (n != this.doneBatches - 1) {
            throw new IllegalArgumentException("Unavailable batch time");
        }
        return this.batchTimes.getQuick(0);
    }

    public double getRealBatchEndingTime(int n) {
        if (this.batchLengths || this.aggregation) {
            return this.batchTimes.get(n + 1);
        }
        if (n != this.doneBatches - 1) {
            throw new IllegalArgumentException("Unavailable batch time");
        }
        return this.batchTimes.getQuick(1);
    }

    public void allocateCapacity(int n) {
        throw new UnsupportedOperationException();
    }

    public void regroupRealBatches(int n) {
        throw new UnsupportedOperationException();
    }

    private final void allocateCapacity() {
        SoftReference<double[]> softReference = new SoftReference<double[]>(new double[50000]);
        this.batchFraction = 1.0;
        this.batchSizeMultiplier = 1.0;
        int n = this.doneBatches;
        while (n < this.targetBatches && softReference.get() != null) {
            int n2 = Math.min(2 * n + 1, this.targetBatches);
            if (this.aggregation || this.batchLengths) {
                this.batchTimes.ensureCapacity(n2 + 1);
            }
            try {
                this.allocateCapacity(n2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return;
            }
            n = n2;
        }
        if (n < this.targetBatches && softReference.get() == null) {
            if (!this.aggregation) {
                throw new IllegalStateException("Cannot increase batch size");
            }
            double d = this.targetBatches;
            double d2 = this.doneBatches;
            while (this.targetBatches > n) {
                this.batchSizeMultiplier *= 2.0;
                this.targetBatches = (int)(d /= 2.0);
                this.doneBatches = (int)(d2 /= 2.0);
                if (this.aggregation || this.batchLengths) {
                    for (int i = 0; i < this.batchTimes.size() / 2; ++i) {
                        this.batchTimes.setQuick(i, this.batchTimes.getQuick(2 * i));
                    }
                    this.batchTimes.setSize(this.batchTimes.size() / 2);
                }
                this.regroupRealBatches(2);
                this.batchFraction = 1.0 - (d2 - (double)this.doneBatches);
            }
            if (this.targetBatches % this.minBatches != 0) {
                this.targetBatches /= this.minBatches;
                this.targetBatches *= this.minBatches;
                this.targetBatches += this.minBatches;
            }
        }
    }

    public abstract void initSimulation();

    public abstract void initBatchStat();

    public abstract void initRealBatchProbes();

    public abstract void initEffectiveBatchProbes();

    public abstract void addRealBatchObs();

    public abstract void addEffectiveBatchObs(int var1, int var2, double var3);

    public int getRequiredNewBatches() {
        return 0;
    }

    public void init() {
        if (this.simulating) {
            throw new IllegalStateException("Already simulating");
        }
        this.nAgr = 0;
        this.warmupDone = false;
        this.doneBatches = 0;
        this.droppedBatches = 0;
        if (this.targetBatches < this.minBatches) {
            this.targetBatches = this.minBatches;
        }
        if (this.aggregation && this.targetBatches % this.minBatches != 0) {
            this.targetBatches /= this.minBatches;
            this.targetBatches += this.minBatches;
            if (this.targetBatches + this.minBatches <= this.maxBatches) {
                this.targetBatches += this.minBatches;
            }
        }
        this.aggregateUpdated = false;
        Sim.init();
        this.endSimEvent = new EndSimEvent();
        this.initSimulation();
    }

    public Event getEndSimEvent() {
        return this.endSimEvent;
    }

    public void warmup() {
        this.warmup(this.warmupTime);
    }

    public void warmup(double d) {
        if (this.warmupDone) {
            throw new IllegalStateException("Warmup already done");
        }
        if (!Double.isInfinite(d) && !Double.isNaN(d)) {
            this.endSimEvent.schedule(d);
        }
        Sim.start();
        this.endSimEvent.cancel();
        this.initRealBatchProbes();
        if (!this.aggregation) {
            this.initEffectiveBatchProbes();
        }
        if (this.aggregation || this.batchLengths) {
            this.batchTimes.setSize(0);
            this.batchTimes.add(Sim.time());
        } else {
            this.batchTimes.setSize(2);
            this.batchTimes.trimToSize();
            this.batchTimes.setQuick(0, Sim.time());
            this.batchTimes.setQuick(1, Sim.time());
        }
        this.warmupDone = true;
    }

    public void simulateBatch() {
        double d = this.getBatchSizeMultiplier();
        if (d > 1.0) {
            this.batchSize *= d;
        }
        this.simulateBatch(this.batchSize * this.getBatchFraction());
    }

    public void simulateBatch(double d) {
        this.initBatchStat();
        this.endSimEvent.schedule(d);
        Sim.start();
        this.endSimEvent.cancel();
        this.batchFraction = 1.0;
        this.batchSizeMultiplier = 1.0;
        this.aggregateUpdated = false;
        ++this.doneBatches;
        if (this.batchLengths || this.aggregation) {
            this.batchTimes.add(Sim.time());
        } else {
            this.batchTimes.setQuick(0, this.batchTimes.getQuick(1));
            this.batchTimes.setQuick(1, Sim.time());
        }
        this.addRealBatchObs();
        if (!this.aggregation) {
            this.nAgr = 1;
            this.addEffectiveBatchObs(this.doneBatches - 1, 1, this.getRealBatchLength(this.doneBatches - 1));
        }
    }

    public void adjustTargetBatches(int n) {
        if (this.doneBatches + n > this.maxBatches) {
            n = this.maxBatches - this.doneBatches;
            if (this.aggregation && n < this.minBatches) {
                return;
            }
        }
        if (this.aggregation && n % this.minBatches != 0) {
            n /= this.minBatches;
            if (this.doneBatches + (n *= this.minBatches) + this.minBatches <= this.maxBatches) {
                n += this.minBatches;
            }
        }
        this.targetBatches = this.doneBatches + n;
    }

    public void simulateBatches() {
        if (this.doneBatches < this.targetBatches) {
            this.allocateCapacity();
        }
        while (this.doneBatches < this.targetBatches) {
            this.simulateBatch();
        }
        if (this.aggregation) {
            this.makeAggregateBatches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulate() {
        this.init();
        this.simulating = true;
        try {
            this.warmup(this.warmupTime);
            while (this.doneBatches < this.targetBatches) {
                this.simulateBatches();
                this.adjustTargetBatches(this.getRequiredNewBatches());
            }
            if (this.aggregation && !this.aggregateUpdated) {
                this.makeAggregateBatches();
            }
        }
        finally {
            this.simulating = false;
        }
    }

    private final void makeAggregateBatches() {
        this.initEffectiveBatchProbes();
        this.nAgr = (this.doneBatches - this.droppedBatches) / this.minBatches;
        int n = this.minBatches;
        if (this.nAgr == 0) {
            this.nAgr = 1;
            n = this.doneBatches - this.droppedBatches;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i * this.nAgr + this.droppedBatches;
            this.addEffectiveBatchObs(n2, this.nAgr, this.batchTimes.getQuick(n2 - this.droppedBatches + this.nAgr) - this.batchTimes.getQuick(n2 - this.droppedBatches));
        }
        this.aggregateUpdated = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("minimal number of batches: ").append(this.minBatches);
        if (this.maxBatches < Integer.MAX_VALUE) {
            stringBuffer.append(", maximal number of batches: ").append(this.maxBatches);
        }
        stringBuffer.append(", target number of batches: ").append(this.targetBatches);
        stringBuffer.append(", warmup time: ").append(this.warmupTime);
        if (this.simulating) {
            stringBuffer.append(", simulation in progress");
        } else {
            stringBuffer.append(", simulation stopped");
        }
        if (this.warmupDone) {
            stringBuffer.append(", number of completed batches: ").append(this.doneBatches);
        } else {
            stringBuffer.append(", warmup not completed");
        }
        if (this.aggregation) {
            stringBuffer.append(", batch aggregation turned ON");
        } else {
            stringBuffer.append(", batch aggregation turned OFF");
            if (this.batchLengths) {
                stringBuffer.append(", batch lengths are kept");
            } else {
                stringBuffer.append(", batch lengths are not kept");
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static double getSum(double[] dArray, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException("Not enough elements in the array");
        }
        double d = 0.0;
        for (int i = n; i < n + n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double getSum(DoubleArrayList doubleArrayList, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (n + n2 > doubleArrayList.size()) {
            throw new IndexOutOfBoundsException("Not enough elements in the array list");
        }
        double d = 0.0;
        for (int i = n; i < n + n2; ++i) {
            d += doubleArrayList.getQuick(i);
        }
        return d;
    }

    public static double getSum(DoubleMatrix1D doubleMatrix1D, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (n + n2 > doubleMatrix1D.size()) {
            throw new IndexOutOfBoundsException("Not enough elements in the matrix");
        }
        double d = 0.0;
        for (int i = n; i < n + n2; ++i) {
            d += doubleMatrix1D.getQuick(i);
        }
        return d;
    }

    public static double[] getSum(double[][] dArray, int n, int n2) {
        if (dArray.length == 0) {
            return new double[0];
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("startColumn must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("numColumns is negative");
        }
        if (n + n2 > dArray[0].length) {
            throw new IndexOutOfBoundsException("Not enough elements in the array");
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = n; j < n + n2; ++j) {
                int n3 = i;
                dArray2[n3] = dArray2[n3] + dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[] getSum(DoubleMatrix2D doubleMatrix2D, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("startColumn must not be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("numColumns is negative");
        }
        if (n + n2 > doubleMatrix2D.columns()) {
            throw new IndexOutOfBoundsException("Not enough columns in the matrix");
        }
        double[] dArray = new double[doubleMatrix2D.rows()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = n; j < n + n2; ++j) {
                int n3 = i;
                dArray[n3] = dArray[n3] + doubleMatrix2D.getQuick(i, j);
            }
        }
        return dArray;
    }

    public static void regroupElements(double[] dArray, int n) {
        int n2;
        double d;
        int n3;
        if (n < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int n4 = dArray.length / n;
        for (n3 = 0; n3 < n4; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += dArray[n3 * n + n2];
            }
            dArray[n3] = d;
        }
        n3 = dArray.length % n;
        if (n3 > 0) {
            d = 0.0;
            n2 = dArray.length - n * n4;
            for (int i = 0; i < n2; ++i) {
                d += dArray[n4 * n + i];
            }
            dArray[n4] = d;
            ++n4;
        }
        for (int i = n4; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
    }

    public static void regroupElements(DoubleArrayList doubleArrayList, int n) {
        int n2;
        double d;
        int n3;
        if (n < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int n4 = doubleArrayList.size() / n;
        for (n3 = 0; n3 < n4; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += doubleArrayList.getQuick(n3 * n + n2);
            }
            doubleArrayList.setQuick(n3, d);
        }
        n3 = doubleArrayList.size() % n;
        if (n3 > 0) {
            d = 0.0;
            n2 = doubleArrayList.size() - n * n4;
            for (int i = 0; i < n2; ++i) {
                d += doubleArrayList.getQuick(n4 * n + i);
            }
            doubleArrayList.setQuick(n4, d);
            ++n4;
        }
        doubleArrayList.setSize(n4);
    }

    public static void regroupElements(DoubleMatrix1D doubleMatrix1D, int n) {
        int n2;
        double d;
        int n3;
        if (n < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int n4 = doubleMatrix1D.size() / n;
        for (n3 = 0; n3 < n4; ++n3) {
            d = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += doubleMatrix1D.getQuick(n3 * n + n2);
            }
            doubleMatrix1D.setQuick(n3, d);
        }
        n3 = doubleMatrix1D.size() % n;
        if (n3 > 0) {
            d = 0.0;
            n2 = doubleMatrix1D.size() - n * n4;
            for (int i = 0; i < n2; ++i) {
                d += doubleMatrix1D.getQuick(n4 * n + i);
            }
            doubleMatrix1D.setQuick(n4, d);
            ++n4;
        }
        for (int i = n4; i < doubleMatrix1D.size(); ++i) {
            doubleMatrix1D.setQuick(i, 0.0);
        }
    }

    public static void regroupElements(DoubleMatrix2D doubleMatrix2D, int n) {
        int n2;
        int n3;
        if (n < 1) {
            throw new IllegalArgumentException("x < 1");
        }
        int n4 = doubleMatrix2D.columns() / n;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < doubleMatrix2D.rows(); ++n2) {
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += doubleMatrix2D.getQuick(n2, n3 * n + i);
                }
                doubleMatrix2D.setQuick(n2, n3, d);
            }
        }
        n3 = doubleMatrix2D.columns() % n;
        if (n3 > 0) {
            n2 = doubleMatrix2D.columns() - n * n4;
            for (int i = 0; i < doubleMatrix2D.rows(); ++i) {
                double d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += doubleMatrix2D.getQuick(i, n4 * n + j);
                }
                doubleMatrix2D.setQuick(i, n4, d);
            }
            ++n4;
        }
        for (n2 = 0; n2 < doubleMatrix2D.rows(); ++n2) {
            for (int i = n4; i < doubleMatrix2D.columns(); ++i) {
                doubleMatrix2D.setQuick(n2, i, 0.0);
            }
        }
    }

    private static final class EndSimEvent
    extends Event {
        private EndSimEvent() {
        }

        public void actions() {
            Sim.stop();
        }
    }
}

