/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents;

import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;

public abstract class Continuous {
    private static final int EULER = 1;
    private static final int RUNGEKUTTA2 = 2;
    private static final int RUNGEKUTTA4 = 4;
    private boolean active = false;
    private double value;
    private Event ev;
    double phi;
    double pi;
    double buffer;
    double sum;
    Continuous prec;
    Continuous succ;
    private static Continuous firstActiveVar = null;
    private static double stepSize;
    private static int integMethod;
    private static int order;
    private static double[] A;
    private static double[] B;
    private static double[] C;
    private static StepEvent stepEv;

    public void init(double d) {
        this.value = d;
    }

    public double value() {
        return this.value;
    }

    public static void selectEuler(double d) {
        integMethod = 1;
        stepSize = d;
    }

    public static void selectRungeKutta2(double d) {
        integMethod = 2;
        stepSize = d;
        order = 2;
        Continuous.A[0] = 1.0;
        Continuous.A[1] = 0.0;
        Continuous.B[0] = 0.5;
        Continuous.B[1] = 0.5;
        Continuous.C[0] = 0.0;
        Continuous.C[1] = 1.0;
    }

    public static void selectRungeKutta4(double d) {
        integMethod = 4;
        stepSize = d;
        order = 4;
        Continuous.A[0] = 0.5;
        Continuous.A[1] = 0.5;
        Continuous.A[2] = 1.0;
        Continuous.A[3] = 0.0;
        Continuous.B[0] = 0.16666666666666666;
        Continuous.B[1] = 0.3333333333333333;
        Continuous.B[2] = 0.3333333333333333;
        Continuous.B[3] = 0.16666666666666666;
        Continuous.C[0] = 0.0;
        Continuous.C[1] = 0.5;
        Continuous.C[2] = 0.5;
        Continuous.C[3] = 1.0;
    }

    public void startInteg() {
        if (stepEv == null) {
            stepEv = new StepEvent();
        }
        this.active = true;
        if (firstActiveVar == null) {
            stepEv.schedule(stepSize);
        } else {
            Continuous.firstActiveVar.prec = this;
        }
        this.succ = firstActiveVar;
        this.prec = null;
        firstActiveVar = this;
    }

    public void startInteg(double d) {
        this.init(d);
        this.startInteg();
    }

    public void stopInteg() {
        this.active = false;
        if (this.prec == null) {
            firstActiveVar = this.succ;
        } else {
            this.prec.succ = this.succ;
        }
        if (this.succ != null) {
            this.succ.prec = this.prec;
        }
        if (firstActiveVar == null) {
            stepEv.cancel();
        }
    }

    public abstract double derivative(double var1);

    public void afterEachStep() {
    }

    private static void oneStepEuler() {
        double d = Sim.time() - stepSize;
        Continuous continuous = firstActiveVar;
        while (continuous != null) {
            continuous.phi = continuous.value + stepSize * continuous.derivative(d);
            continuous = continuous.succ;
        }
        continuous = firstActiveVar;
        while (continuous != null) {
            continuous.value = continuous.phi;
            if (continuous.ev != null) {
                continuous.ev.scheduleNext();
            }
            continuous.afterEachStep();
            continuous = continuous.succ;
        }
    }

    private static void oneStepRK() {
        double d = Sim.time() - stepSize;
        Continuous continuous = firstActiveVar;
        while (continuous != null) {
            continuous.buffer = continuous.value;
            continuous.sum = 0.0;
            continuous.pi = 0.0;
            continuous = continuous.succ;
        }
        for (int i = 1; i <= order - 1; ++i) {
            continuous = firstActiveVar;
            while (continuous != null) {
                continuous.pi = continuous.derivative(d + stepSize * C[i - 1]);
                continuous.sum += continuous.pi * B[i - 1];
                continuous.phi = continuous.buffer + stepSize * continuous.pi * A[i - 1];
                continuous = continuous.succ;
            }
            continuous = firstActiveVar;
            while (continuous != null) {
                continuous.value = continuous.phi;
                continuous = continuous.succ;
            }
        }
        continuous = firstActiveVar;
        while (continuous != null) {
            continuous.pi = continuous.derivative(d + stepSize * C[order - 1]);
            continuous.value = continuous.buffer + stepSize * (continuous.sum + continuous.pi * B[order - 1]);
            if (continuous.ev != null) {
                continuous.ev.scheduleNext();
            }
            continuous.afterEachStep();
            continuous = continuous.succ;
        }
    }

    static {
        A = new double[4];
        B = new double[4];
        C = new double[4];
        stepEv = null;
    }

    protected class StepEvent
    extends Event {
        protected StepEvent() {
        }

        public void actions() {
            switch (integMethod) {
                case 1: {
                    Continuous.oneStepEuler();
                    break;
                }
                case 2: {
                    Continuous.oneStepRK();
                    break;
                }
                case 4: {
                    Continuous.oneStepRK();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Integration step with undefined method");
                }
            }
            this.schedule(stepSize);
        }

        public String toString() {
            return "Integration step for continuous variable " + Continuous.this.toString();
        }
    }
}

