/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

public class WELL1024
extends RandomStreamBase {
    private static final double NORM = 2.3283064365386963E-10;
    private static final int MASK = 31;
    private static final int W = 32;
    private static final int R = 32;
    private static final int P = 0;
    private static final int M1 = 3;
    private static final int M2 = 24;
    private static final int M3 = 10;
    private static final int A1 = -612762831;
    private static final int B1 = 265986753;
    private static final int B2 = 667264397;
    private static final int C1 = 1911133182;
    private int state_i = 0;
    private int[] state;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream;
    private static BitMatrix Apw;
    private static BitMatrix Apz;
    private static boolean initialised;
    private static final int[] pw;
    private static final int[] pz;
    static /* synthetic */ Class class$umontreal$iro$lecuyer$rng$WELL1024;

    private static void initialisation() {
        curr_stream = new int[]{-566162571, -1873828409, -1949011938, 18785121, 1857128928, 2049641697, -534367798, 1928044850, 1367988751, 1052191276, 1370219795, 1839113596, 1298729969, -2078179382, 1922096666, 1117739592, 1858350835, -1777683691, 1925424963, 1222720497, -1994921272, 675995686, 897315392, -1858383444, 325775765, 907721752, 1931130661, 1674815433, -437048808, -1851203228, 82469301, -953524079};
        try {
            InputStream inputStream = (class$umontreal$iro$lecuyer$rng$WELL1024 == null ? (class$umontreal$iro$lecuyer$rng$WELL1024 = WELL1024.class$("umontreal.iro.lecuyer.rng.WELL1024")) : class$umontreal$iro$lecuyer$rng$WELL1024).getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/rng/WELL1024.dat");
            if (inputStream == null) {
                throw new FileNotFoundException("Couldn't find WELRNG1024.dat");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Apw = (BitMatrix)objectInputStream.readObject();
            Apz = (BitMatrix)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        initialised = true;
    }

    private void advanceSeed(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[32];
        for (n = 0; n < 32; ++n) {
            this.state[n] = nArray[n];
        }
        this.state_i = 0;
        for (n = 0; n < 32; ++n) {
            int n2 = nArray2[n];
            for (int i = 0; i < 32; ++i) {
                if ((n2 & 1) == 1) {
                    for (int j = 0; j < 32; ++j) {
                        int n3 = j;
                        nArray3[n3] = nArray3[n3] ^ this.state[this.state_i + j & 0x1F];
                    }
                }
                n2 >>= 1;
                this.nextValue();
            }
        }
        for (n = 0; n < 32; ++n) {
            nArray[n] = nArray3[n];
        }
    }

    private static void verifySeed(int[] nArray) {
        if (nArray.length != 32) {
            throw new IllegalArgumentException("Seed must contain 32values");
        }
        for (int i = 0; i < 32; ++i) {
            if (nArray[i] == 0) continue;
            return;
        }
        throw new IllegalArgumentException("At least one of the element of the seed must not be 0.");
    }

    private WELL1024(int n) {
        this.state = new int[32];
        for (int i = 0; i < 32; ++i) {
            this.state[i] = 0;
        }
        this.state[n / 32] = 1 << n % 32;
        this.state_i = 0;
    }

    public WELL1024() {
        if (!initialised) {
            WELL1024.initialisation();
        }
        this.state = new int[32];
        this.stream = new int[32];
        this.substream = new int[32];
        for (int i = 0; i < 32; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, pz);
        this.resetStartStream();
    }

    public WELL1024(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        WELL1024.verifySeed(nArray);
        for (int i = 0; i < 32; ++i) {
            WELL1024.curr_stream[i] = nArray[i];
        }
    }

    public void setSeed(int[] nArray) {
        WELL1024.verifySeed(nArray);
        for (int i = 0; i < 32; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        int[] nArray = new int[32];
        for (int i = 0; i < 32; ++i) {
            nArray[i] = this.state[this.state_i + i & 0x1F];
        }
        return nArray;
    }

    public void resetStartStream() {
        for (int i = 0; i < 32; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 0;
        for (int i = 0; i < 32; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, pw);
        this.resetStartSubstream();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name == null) {
            stringBuffer.append("The state of this WELL1024 is : {");
        } else {
            stringBuffer.append("The state of " + this.name + " is : {");
        }
        for (int i = 0; i < 31; ++i) {
            stringBuffer.append(this.state[this.state_i + i & 0x1F] + ", ");
        }
        stringBuffer.append(this.state[this.state_i + 32 - 1 & 0x1F] + "}");
        return stringBuffer.toString();
    }

    protected double nextValue() {
        int n = this.state[this.state_i + 31 & 0x1F];
        int n2 = this.state[this.state_i] ^ (this.state[this.state_i + 3 & 0x1F] ^ this.state[this.state_i + 3 & 0x1F] >>> 8);
        int n3 = this.state[this.state_i + 24 & 0x1F] ^ this.state[this.state_i + 24 & 0x1F] << 19 ^ (this.state[this.state_i + 10 & 0x1F] ^ this.state[this.state_i + 10 & 0x1F] << 14);
        this.state[this.state_i] = n2 ^ n3;
        this.state[this.state_i + 31 & 0x1F] = n ^ n << 11 ^ (n2 ^ n2 << 7) ^ (n3 ^ n3 << 13);
        this.state_i = this.state_i + 31 & 0x1F;
        long l = this.state[this.state_i];
        return (double)(l > 0L ? l : l + 0x100000000L) * 2.3283064365386963E-10;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Must provide the output file.");
            System.exit(1);
        }
        System.out.println("Creating the WELL1024 state transition matrices.");
        BitVector[] bitVectorArray = new BitVector[1024];
        int[] nArray = new int[32];
        for (int i = 0; i < 1024; ++i) {
            WELL1024 wELL1024 = new WELL1024(i);
            wELL1024.nextValue();
            for (int j = 0; j < 32; ++j) {
                nArray[j] = wELL1024.state[wELL1024.state_i + j & 0x1F];
            }
            bitVectorArray[i] = new BitVector(nArray, 1024);
        }
        BitMatrix bitMatrix = new BitMatrix(bitVectorArray).transpose();
        BitMatrix bitMatrix2 = bitMatrix.power2e(400);
        BitMatrix bitMatrix3 = bitMatrix2.power2e(300);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(bitMatrix2);
            objectOutputStream.writeObject(bitMatrix3);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't create " + stringArray[0]);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        initialised = false;
        pw = new int[]{239348046, -282886401, 1586195451, -1490753926, 1503218941, 1870413281, 1731581197, 1274943898, 969051745, -49851802, -1764987617, 1572972165, -696277948, -859825274, 150963740, -837732571, 1718646275, 950776061, 124264292, 272971205, -833952268, 1357082885, -792332417, 1958865910, 751768837, -772662394, -1704181714, -365649124, 1709260051, -561041659, -1982103473, -1916565518};
        pz = new int[]{2091613604, -282545547, 419407466, 715398738, 364297606, 1443695990, -840065007, -1776085209, -288970766, -1711461402, -1833981818, -861440016, -1758527688, -1566601655, 582269366, 277465240, 1834392357, -2020588350, 1581364515, 871472598, 2080399301, 2140805383, 968859373, 1272474228, 236865507, -1762994260, -936052242, -637580721, 1904149580, -49408538, 113348339, -1076025022};
    }
}

