/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.ArithmeticMod;

public class MRG31k3p
extends RandomStreamBase {
    private static final int M1 = Integer.MAX_VALUE;
    private static final int M2 = 2147462579;
    private static final int MASK12 = 511;
    private static final int MASK13 = 0xFFFFFF;
    private static final int MASK2 = 65535;
    private static final int MULT2 = 21069;
    private static final double NORM = 4.656612873077393E-10;
    private int x11;
    private int x12;
    private int x13;
    private int x21;
    private int x22;
    private int x23;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream = new int[]{12345, 12345, 12345, 12345, 12345, 12345};
    private static final int[][] A1p0 = new int[][]{{0, 0x400000, 129}, {1, 0, 0}, {0, 1, 0}};
    private static final int[][] A2p0 = new int[][]{{32768, 0, 32769}, {1, 0, 0}, {0, 1, 0}};
    private static final int[][] A1p72 = new int[][]{{1516919229, 758510237, 499121365}, {1884998244, 1516919229, 335398200}, {601897748, 1884998244, 358115744}};
    private static final int[][] A2p72 = new int[][]{{1228857673, 1496414766, 954677935}, {1133297478, 1407477216, 1496414766}, {2002613992, 1639496704, 1407477216}};
    private static final int[][] A1p134 = new int[][]{{1702500920, 1849582496, 1656874625}, {828554832, 1702500920, 1512419905}, {1143731069, 828554832, 102237247}};
    private static final int[][] A2p134 = new int[][]{{796789021, 1464208080, 607337906}, {1241679051, 1431130166, 1464208080}, {1401213391, 1178684362, 1431130166}};

    private static void multMatVect(int[] nArray, int[][] nArray2, int n, int[][] nArray3, int n2) {
        int n3;
        int[] nArray4 = new int[3];
        for (n3 = 0; n3 < 3; ++n3) {
            nArray4[n3] = nArray[n3];
        }
        ArithmeticMod.matVecModM(nArray2, nArray4, nArray4, n);
        for (n3 = 0; n3 < 3; ++n3) {
            nArray[n3] = nArray4[n3];
        }
        for (n3 = 0; n3 < 3; ++n3) {
            nArray4[n3] = nArray[n3 + 3];
        }
        ArithmeticMod.matVecModM(nArray3, nArray4, nArray4, n2);
        for (n3 = 0; n3 < 3; ++n3) {
            nArray[n3 + 3] = nArray4[n3];
        }
    }

    public MRG31k3p() {
        this.name = null;
        this.prec53 = false;
        this.anti = false;
        this.stream = new int[6];
        this.substream = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.resetStartStream();
        MRG31k3p.multMatVect(curr_stream, A1p134, Integer.MAX_VALUE, A2p134, 2147462579);
    }

    public MRG31k3p(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        if (nArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (nArray[5] == 0 && nArray[3] == 0 && nArray[4] == 0) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (nArray[0] >= Integer.MAX_VALUE || nArray[1] >= Integer.MAX_VALUE || nArray[2] >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The first 3 values must be less than 2147483647");
        }
        if (nArray[5] >= 2147462579 || nArray[3] >= 2147462579 || nArray[4] >= 2147462579) {
            throw new IllegalArgumentException("The last 3 values must be less than 2147462579");
        }
        for (int i = 0; i < 6; ++i) {
            MRG31k3p.curr_stream[i] = nArray[i];
        }
    }

    public void setSeed(int[] nArray) {
        if (nArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (nArray[3] == 0 && nArray[4] == 0 && nArray[5] == 0) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (nArray[0] >= Integer.MAX_VALUE || nArray[1] >= Integer.MAX_VALUE || nArray[2] >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The first 3 values must be less than 2147483647");
        }
        if (nArray[3] >= 2147462579 || nArray[4] >= 2147462579 || nArray[5] >= 2147462579) {
            throw new IllegalArgumentException("The last 3 values must be less than 2147462579");
        }
        for (int i = 0; i < 6; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.x11 = this.substream[0];
        this.x12 = this.substream[1];
        this.x13 = this.substream[2];
        this.x21 = this.substream[3];
        this.x22 = this.substream[4];
        this.x23 = this.substream[5];
    }

    public void resetNextSubstream() {
        MRG31k3p.multMatVect(this.substream, A1p72, Integer.MAX_VALUE, A2p72, 2147462579);
        this.resetStartSubstream();
    }

    public int[] getState() {
        return new int[]{this.x11, this.x12, this.x13, this.x21, this.x22, this.x23};
    }

    public String toString() {
        if (this.name == null) {
            return "The state of the MRG31k3p is : " + this.x11 + "," + this.x12 + "," + this.x13 + "; " + this.x21 + "," + this.x22 + "," + this.x23 + ".";
        }
        return "The state of " + this.name + " is : " + this.x11 + "," + this.x12 + "," + this.x13 + "; " + this.x21 + "," + this.x22 + "," + this.x23 + ".";
    }

    protected double nextValue() {
        int n;
        int n2 = ((this.x12 & 0x1FF) << 22) + (this.x12 >>> 9) + ((this.x13 & 0xFFFFFF) << 7) + (this.x13 >>> 24);
        if (n2 < 0 || n2 >= Integer.MAX_VALUE) {
            n2 -= Integer.MAX_VALUE;
        }
        if ((n2 += this.x13) < 0 || n2 >= Integer.MAX_VALUE) {
            n2 -= Integer.MAX_VALUE;
        }
        this.x13 = this.x12;
        this.x12 = this.x11;
        this.x11 = n2;
        n2 = ((this.x21 & 0xFFFF) << 15) + 21069 * (this.x21 >>> 16);
        if (n2 < 0 || n2 >= 2147462579) {
            n2 -= 2147462579;
        }
        if ((n = ((this.x23 & 0xFFFF) << 15) + 21069 * (this.x23 >>> 16)) < 0 || n >= 2147462579) {
            n -= 2147462579;
        }
        if ((n += this.x23) < 0 || n >= 2147462579) {
            n -= 2147462579;
        }
        if ((n += n2) < 0 || n >= 2147462579) {
            n -= 2147462579;
        }
        this.x23 = this.x22;
        this.x22 = this.x21;
        this.x21 = n;
        if (this.x11 <= this.x21) {
            return (double)(this.x11 - this.x21 + Integer.MAX_VALUE) * 4.656612873077393E-10;
        }
        return (double)(this.x11 - this.x21) * 4.656612873077393E-10;
    }
}

