/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class LFSR258
extends RandomStreamBase {
    private static final double NORM = 5.421010862427523E-20;
    private static final double MAX = 0.9999999999999999;
    private long z0;
    private long z1;
    private long z2;
    private long z3;
    private long z4;
    private long[] stream;
    private long[] substream;
    private static long[] curr_stream = new long[]{1234567890L, 1234567890L, 1234567890L, 1234567890L, 1234567890L};

    public LFSR258() {
        this.name = null;
        this.stream = new long[5];
        this.substream = new long[5];
        for (int i = 0; i < 5; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.resetStartStream();
        long l = curr_stream[0] & 0xFFFFFFFFFFFFFFFEL;
        long l2 = l ^ l << 1;
        LFSR258.curr_stream[0] = l = l2 >>> 61 ^ l2 >>> 59 ^ l2 >>> 58 ^ l2 >>> 57 ^ l2 >>> 51 ^ l2 >>> 47 ^ l2 >>> 46 ^ l2 >>> 45 ^ l2 >>> 43 ^ l2 >>> 39 ^ l2 >>> 30 ^ l2 >>> 29 ^ l2 >>> 23 ^ l2 >>> 15 ^ l << 2 ^ l << 4 ^ l << 5 ^ l << 6 ^ l << 12 ^ l << 16 ^ l << 17 ^ l << 18 ^ l << 20 ^ l << 24 ^ l << 33 ^ l << 34 ^ l << 40 ^ l << 48;
        l = curr_stream[1] & 0xFFFFFFFFFFFFFE00L;
        l2 = l ^ l << 24;
        LFSR258.curr_stream[1] = l = l2 >>> 52 ^ l2 >>> 50 ^ l2 >>> 49 ^ l2 >>> 46 ^ l2 >>> 43 ^ l2 >>> 40 ^ l2 >>> 37 ^ l2 >>> 34 ^ l2 >>> 30 ^ l2 >>> 28 ^ l2 >>> 26 ^ l2 >>> 25 ^ l2 >>> 23 ^ l2 >>> 21 ^ l2 >>> 20 ^ l2 >>> 19 ^ l2 >>> 17 ^ l2 >>> 15 ^ l2 >>> 13 ^ l2 >>> 12 ^ l2 >>> 10 ^ l2 >>> 8 ^ l2 >>> 7 ^ l2 >>> 6 ^ l2 >>> 2 ^ l << 1 ^ l << 4 ^ l << 6 ^ l << 7 ^ l << 11 ^ l << 14 ^ l << 15 ^ l << 16 ^ l << 17 ^ l << 21 ^ l << 22 ^ l << 25 ^ l << 27 ^ l << 29 ^ l << 30 ^ l << 32 ^ l << 34 ^ l << 35 ^ l << 36 ^ l << 38 ^ l << 40 ^ l << 42 ^ l << 43 ^ l << 45 ^ l << 47 ^ l << 48 ^ l << 49 ^ l << 53;
        l = curr_stream[2] & 0xFFFFFFFFFFFFF000L;
        l2 = l ^ l << 3;
        LFSR258.curr_stream[2] = l = l2 >>> 49 ^ l2 >>> 45 ^ l2 >>> 41 ^ l2 >>> 40 ^ l2 >>> 32 ^ l2 >>> 27 ^ l2 >>> 23 ^ l2 >>> 14 ^ l2 >>> 1 ^ l << 2 ^ l << 3 ^ l << 7 ^ l << 11 ^ l << 12 ^ l << 20 ^ l << 25 ^ l << 29 ^ l << 38 ^ l << 51;
        l = curr_stream[3] & 0xFFFFFFFFFFFE0000L;
        l2 = l ^ l << 5;
        LFSR258.curr_stream[3] = l = l2 >>> 45 ^ l2 >>> 32 ^ l2 >>> 27 ^ l2 >>> 22 ^ l2 >>> 17 ^ l2 >>> 13 ^ l2 >>> 12 ^ l2 >>> 7 ^ l2 >>> 3 ^ l2 >>> 2 ^ l << 3 ^ l << 15 ^ l << 20 ^ l << 25 ^ l << 30 ^ l << 34 ^ l << 35 ^ l << 40 ^ l << 44 ^ l << 45;
        l = curr_stream[4] & 0xFFFFFFFFFF800000L;
        l2 = l ^ l << 3;
        LFSR258.curr_stream[4] = l = l2 >>> 40 ^ l2 >>> 39 ^ l2 >>> 38 ^ l2 >>> 37 ^ l2 >>> 35 ^ l2 >>> 34 ^ l2 >>> 31 ^ l2 >>> 30 ^ l2 >>> 29 ^ l2 >>> 28 ^ l2 >>> 27 ^ l2 >>> 26 ^ l2 >>> 24 ^ l2 >>> 23 ^ l2 >>> 21 ^ l2 >>> 20 ^ l2 >>> 18 ^ l2 >>> 15 ^ l2 >>> 12 ^ l2 >>> 10 ^ l2 >>> 9 ^ l2 >>> 7 ^ l2 >>> 6 ^ l2 >>> 5 ^ l2 >>> 4 ^ l2 >>> 3 ^ l << 1 ^ l << 2 ^ l << 3 ^ l << 4 ^ l << 6 ^ l << 7 ^ l << 10 ^ l << 11 ^ l << 12 ^ l << 13 ^ l << 14 ^ l << 15 ^ l << 17 ^ l << 18 ^ l << 20 ^ l << 21 ^ l << 23 ^ l << 26 ^ l << 29 ^ l << 31 ^ l << 32 ^ l << 34 ^ l << 35 ^ l << 36 ^ l << 37 ^ l << 38;
    }

    public LFSR258(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(long[] lArray) {
        if (lArray.length != 5) {
            throw new IllegalArgumentException("Seed must contain 5 values");
        }
        if (lArray[0] < 2L || lArray[1] < 512L || lArray[2] < 4096L || lArray[3] < 131072L || lArray[4] < 0x800000L) {
            throw new IllegalArgumentException("The seed elements must be greater or equal than 2, 512, 4096, 131072 and 8388608 respectively");
        }
        for (int i = 0; i < 5; ++i) {
            LFSR258.curr_stream[i] = lArray[i];
        }
    }

    public void setSeed(int[] nArray) {
        if (nArray.length != 5) {
            throw new IllegalArgumentException("Seed must contain 5 values");
        }
        if (nArray[0] < 2 || nArray[1] < 512 || nArray[2] < 4096 || nArray[3] < 131072 || nArray[4] < 0x800000) {
            throw new IllegalArgumentException("The seed elements must be greater or equal than 2, 512, 4096, 131072 and 8388608 respectively");
        }
        for (int i = 0; i < 5; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public long[] getState() {
        return new long[]{this.z0, this.z1, this.z2, this.z3, this.z4};
    }

    public void resetStartStream() {
        for (int i = 0; i < 5; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.z0 = this.substream[0];
        this.z1 = this.substream[1];
        this.z2 = this.substream[2];
        this.z3 = this.substream[3];
        this.z4 = this.substream[4];
    }

    public void resetNextSubstream() {
        long l = this.substream[0] & 0xFFFFFFFFFFFFFFFEL;
        long l2 = l ^ l << 1;
        this.substream[0] = l = l2 >>> 58 ^ l2 >>> 55 ^ l2 >>> 46 ^ l2 >>> 43 ^ l << 5 ^ l << 8 ^ l << 17 ^ l << 20;
        l = this.substream[1] & 0xFFFFFFFFFFFFFE00L;
        l2 = l ^ l << 24;
        this.substream[1] = l = l2 >>> 54 ^ l2 >>> 53 ^ l2 >>> 52 ^ l2 >>> 50 ^ l2 >>> 49 ^ l2 >>> 48 ^ l2 >>> 43 ^ l2 >>> 41 ^ l2 >>> 38 ^ l2 >>> 37 ^ l2 >>> 30 ^ l2 >>> 25 ^ l2 >>> 24 ^ l2 >>> 23 ^ l2 >>> 19 ^ l2 >>> 16 ^ l2 >>> 15 ^ l2 >>> 14 ^ l2 >>> 13 ^ l2 >>> 11 ^ l2 >>> 8 ^ l2 >>> 7 ^ l2 >>> 5 ^ l2 >>> 3 ^ l << 0 ^ l << 2 ^ l << 3 ^ l << 6 ^ l << 7 ^ l << 8 ^ l << 9 ^ l << 10 ^ l << 11 ^ l << 12 ^ l << 13 ^ l << 14 ^ l << 16 ^ l << 18 ^ l << 19 ^ l << 21 ^ l << 25 ^ l << 30 ^ l << 31 ^ l << 32 ^ l << 36 ^ l << 39 ^ l << 40 ^ l << 41 ^ l << 42 ^ l << 44 ^ l << 47 ^ l << 48 ^ l << 50 ^ l << 52;
        l = this.substream[2] & 0xFFFFFFFFFFFFF000L;
        l2 = l ^ l << 3;
        this.substream[2] = l = l2 >>> 50 ^ l2 >>> 49 ^ l2 >>> 46 ^ l2 >>> 42 ^ l2 >>> 40 ^ l2 >>> 39 ^ l2 >>> 38 ^ l2 >>> 37 ^ l2 >>> 36 ^ l2 >>> 32 ^ l2 >>> 29 ^ l2 >>> 28 ^ l2 >>> 27 ^ l2 >>> 25 ^ l2 >>> 23 ^ l2 >>> 20 ^ l2 >>> 19 ^ l2 >>> 15 ^ l2 >>> 12 ^ l2 >>> 11 ^ l2 >>> 2 ^ l << 1 ^ l << 2 ^ l << 3 ^ l << 6 ^ l << 10 ^ l << 12 ^ l << 13 ^ l << 14 ^ l << 15 ^ l << 16 ^ l << 20 ^ l << 23 ^ l << 24 ^ l << 25 ^ l << 27 ^ l << 29 ^ l << 32 ^ l << 33 ^ l << 37 ^ l << 40 ^ l << 41 ^ l << 50;
        l = this.substream[3] & 0xFFFFFFFFFFFE0000L;
        l2 = l ^ l << 5;
        this.substream[3] = l = l2 >>> 46 ^ l2 >>> 44 ^ l2 >>> 42 ^ l2 >>> 41 ^ l2 >>> 40 ^ l2 >>> 38 ^ l2 >>> 36 ^ l2 >>> 32 ^ l2 >>> 30 ^ l2 >>> 25 ^ l2 >>> 18 ^ l2 >>> 16 ^ l2 >>> 15 ^ l2 >>> 14 ^ l2 >>> 12 ^ l2 >>> 11 ^ l2 >>> 10 ^ l2 >>> 9 ^ l2 >>> 8 ^ l2 >>> 6 ^ l2 >>> 5 ^ l2 >>> 4 ^ l2 >>> 3 ^ l2 >>> 2 ^ l << 2 ^ l << 5 ^ l << 6 ^ l << 7 ^ l << 9 ^ l << 11 ^ l << 15 ^ l << 17 ^ l << 22 ^ l << 29 ^ l << 31 ^ l << 32 ^ l << 33 ^ l << 35 ^ l << 36 ^ l << 37 ^ l << 38 ^ l << 39 ^ l << 41 ^ l << 42 ^ l << 43 ^ l << 44 ^ l << 45;
        l = this.substream[4] & 0xFFFFFFFFFF800000L;
        l2 = l ^ l << 3;
        this.substream[4] = l = l2 >>> 40 ^ l2 >>> 29 ^ l2 >>> 10 ^ l << 1 ^ l << 12 ^ l << 31;
        this.resetStartSubstream();
    }

    public String toString() {
        if (this.name == null) {
            return "The state of the LFSR258 is : " + this.z0 + "," + this.z1 + "," + this.z2 + "," + this.z3 + "," + this.z4 + ".";
        }
        return "The state of the " + this.name + " is : " + this.z0 + "," + this.z1 + "," + this.z2 + "," + this.z3 + "," + this.z4 + ".";
    }

    private long nextNumber() {
        long l = (this.z0 << 1 ^ this.z0) >>> 53;
        this.z0 = (this.z0 & 0xFFFFFFFFFFFFFFFEL) << 10 ^ l;
        l = (this.z1 << 24 ^ this.z1) >>> 50;
        this.z1 = (this.z1 & 0xFFFFFFFFFFFFFE00L) << 5 ^ l;
        l = (this.z2 << 3 ^ this.z2) >>> 23;
        this.z2 = (this.z2 & 0xFFFFFFFFFFFFF000L) << 29 ^ l;
        l = (this.z3 << 5 ^ this.z3) >>> 24;
        this.z3 = (this.z3 & 0xFFFFFFFFFFFE0000L) << 23 ^ l;
        l = (this.z4 << 3 ^ this.z4) >>> 33;
        this.z4 = (this.z4 & 0xFFFFFFFFFF800000L) << 8 ^ l;
        return this.z0 ^ this.z1 ^ this.z2 ^ this.z3 ^ this.z4;
    }

    protected double nextValue() {
        long l = this.nextNumber();
        if (l <= 0L) {
            return (double)l * 5.421010862427523E-20 + 0.9999999999999999;
        }
        return (double)l * 5.421010862427523E-20;
    }

    public int nextInt(int n, int n2) {
        long l;
        if (n > n2) {
            throw new IllegalArgumentException(n + " is larger than " + n2 + ".");
        }
        long l2 = n2 - n + 1;
        long l3 = 0x4000000000000000L / l2;
        long l4 = 0x4000000000000000L % l2;
        while ((l = this.nextNumber() >>> 2) >= 0x4000000000000000L - l4) {
        }
        return n + (int)(l / l3);
    }
}

