/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdistmulti.DiscreteDistributionIntMulti;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class NegativeMultinomialDist
extends DiscreteDistributionIntMulti {
    protected double gamma;
    protected double[] p;

    public NegativeMultinomialDist(double d, double[] dArray) {
        this.setParams(d, dArray);
    }

    public double prob(int[] nArray) {
        return NegativeMultinomialDist.prob_(this.gamma, this.p, nArray);
    }

    public double[] getMean() {
        return NegativeMultinomialDist.getMean_(this.gamma, this.p);
    }

    public double[][] getCovariance() {
        return NegativeMultinomialDist.getCovariance_(this.gamma, this.p);
    }

    public double[][] getCorrelation() {
        return NegativeMultinomialDist.getCorrelation_(this.gamma, this.p);
    }

    private static void verifParam(double d, double[] dArray) {
        double d2 = 0.0;
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < 0.0 || dArray[i] >= 1.0) {
                throw new IllegalArgumentException("p is not a probability vector");
            }
            d2 += dArray[i];
        }
        if (d2 >= 1.0) {
            throw new IllegalArgumentException("p is not a probability vector");
        }
    }

    private static double prob_(double d, double[] dArray, int[] nArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("x and p must have the same size");
        }
        for (int i = 0; i < dArray.length; ++i) {
            d3 += dArray[i];
            d4 += (double)nArray[i];
            d5 += Num.lnFactorial(nArray[i]);
            d6 += (double)nArray[i] * Math.log(dArray[i]);
        }
        d2 = 1.0 - d3;
        return Math.exp(Num.lnGamma(d + d4) - (Num.lnGamma(d) + d5) + d * Math.log(d2) + d6);
    }

    public static double prob(double d, double[] dArray, int[] nArray) {
        NegativeMultinomialDist.verifParam(d, dArray);
        return NegativeMultinomialDist.prob_(d, dArray, nArray);
    }

    private static double cdf_(double d, double[] dArray, int[] nArray) {
        throw new UnsupportedOperationException("cdf not implemented");
    }

    public static double cdf(double d, double[] dArray, int[] nArray) {
        NegativeMultinomialDist.verifParam(d, dArray);
        return NegativeMultinomialDist.cdf_(d, dArray, nArray);
    }

    private static double[] getMean_(double d, double[] dArray) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            d3 += dArray[n];
        }
        d2 = 1.0 - d3;
        for (n = 0; n < dArray.length; ++n) {
            dArray2[n] = d * dArray[n] / d2;
        }
        return dArray2;
    }

    public static double[] getMean(double d, double[] dArray) {
        NegativeMultinomialDist.verifParam(d, dArray);
        return NegativeMultinomialDist.getMean_(d, dArray);
    }

    private static double[][] getCovariance_(double d, double[] dArray) {
        int n;
        double d2 = 0.0;
        double d3 = 0.0;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            d3 += dArray[n];
        }
        d2 = 1.0 - d3;
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[n][i] = d * dArray[n] * dArray[i] / (d2 * d2);
            }
            dArray2[n][n] = d * dArray[n] * (dArray[n] + d2) / (d2 * d2);
        }
        return dArray2;
    }

    public static double[][] getCovariance(double d, double[] dArray) {
        NegativeMultinomialDist.verifParam(d, dArray);
        return NegativeMultinomialDist.getCovariance_(d, dArray);
    }

    private static double[][] getCorrelation_(double d, double[] dArray) {
        int n;
        double[][] dArray2 = new double[dArray.length][dArray.length];
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d2 += dArray[n];
        }
        double d3 = 1.0 - d2;
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[n][i] = Math.sqrt(dArray[n] * dArray[i] / ((d3 + dArray[n]) * (d3 + dArray[i])));
            }
            dArray2[n][n] = 1.0;
        }
        return dArray2;
    }

    public static double[][] getCorrelation(double d, double[] dArray) {
        NegativeMultinomialDist.verifParam(d, dArray);
        return NegativeMultinomialDist.getCorrelation_(d, dArray);
    }

    public static double[] getMaximumLikelihoodEstimate(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        double[] dArray = new double[n2 + 1];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            nArray3[n4] = 0;
        }
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n3] = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                int n5 = n3;
                nArray2[n5] = nArray2[n5] + nArray[n3][n4];
                int n6 = n4;
                nArray3[n6] = nArray3[n6] + nArray[n3][n4];
            }
        }
        int n7 = nArray2[0];
        for (n3 = 1; n3 < n; ++n3) {
            if (nArray2[n3] <= n7) continue;
            n7 = nArray2[n3];
        }
        double[] dArray2 = new double[n7];
        for (int i = 0; i < n7; ++i) {
            int n8 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (nArray2[n3] <= i) continue;
                ++n8;
            }
            dArray2[i] = (double)n8 / (double)n;
        }
        Function function = new Function(n, n7, nArray2, dArray2);
        dArray[0] = RootFinder.brentDekker(1.0E-15, 1.0E9, function, 1.0E-5);
        double[] dArray3 = new double[n2];
        double d = 0.0;
        for (n4 = 0; n4 < n2; ++n4) {
            dArray3[n4] = (double)nArray3[n4] / ((double)n * dArray[0]);
            d += dArray3[n4];
        }
        for (n4 = 0; n4 < n2; ++n4) {
            dArray[n4 + 1] = dArray3[n4] / (1.0 + d);
        }
        return dArray;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double[] getP() {
        return this.p;
    }

    public void setParams(double d, double[] dArray) {
        double d2 = 0.0;
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.gamma = d;
        this.dimension = dArray.length;
        this.p = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            if (dArray[i] < 0.0 || dArray[i] >= 1.0) {
                throw new IllegalArgumentException("p is not a probability vector");
            }
            d2 += dArray[i];
            this.p[i] = dArray[i];
        }
        if (d2 >= 1.0) {
            throw new IllegalArgumentException("p is not a probability vector");
        }
    }

    private static class Function
    implements MathFunction {
        protected double[] Fl;
        protected int[] ups;
        protected int n;
        protected int M;
        protected int sumUps;

        public Function(int n, int n2, int[] nArray, double[] dArray) {
            this.n = n;
            this.M = n2;
            this.Fl = new double[dArray.length];
            System.arraycopy(dArray, 0, this.Fl, 0, dArray.length);
            this.ups = new int[nArray.length];
            System.arraycopy(nArray, 0, this.ups, 0, nArray.length);
            this.sumUps = 0;
            for (int i = 0; i < nArray.length; ++i) {
                this.sumUps += nArray[i];
            }
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            for (int i = 0; i < this.M; ++i) {
                d2 += this.Fl[i] / (d + (double)i);
            }
            return d2 - Num.log1p((double)this.sumUps / ((double)this.n * d));
        }
    }
}

