/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistributionMulti;

public class MultiNormalDist
extends ContinuousDistributionMulti {
    protected int dim;
    protected double[] mu;
    protected DoubleMatrix2D sigma;
    protected DoubleMatrix2D invSigma;
    protected static Algebra algebra = new Algebra();

    public MultiNormalDist(double[] dArray, double[][] dArray2) {
        this.setParams(dArray, dArray2);
    }

    public double density(double[] dArray) {
        int n;
        double d = 0.0;
        if (this.invSigma == null) {
            this.invSigma = algebra.inverse(this.sigma);
        }
        double[] dArray2 = new double[this.mu.length];
        for (n = 0; n < this.mu.length; ++n) {
            d = 0.0;
            for (int i = 0; i < this.mu.length; ++i) {
                d += (dArray[i] - this.mu[i]) * this.invSigma.getQuick(i, n);
            }
            dArray2[n] = d;
        }
        d = 0.0;
        for (n = 0; n < this.mu.length; ++n) {
            d += dArray2[n] * (dArray[n] - this.mu[n]);
        }
        return Math.exp(-0.5 * d) / Math.sqrt(Math.pow(Math.PI * 2, this.mu.length) * algebra.det(this.sigma));
    }

    public double[] getMean() {
        return this.mu;
    }

    public double[][] getCovariance() {
        return this.sigma.toArray();
    }

    public double[][] getCorrelation() {
        return MultiNormalDist.getCorrelation_(this.mu, this.sigma.toArray());
    }

    public static double density(double[] dArray, double[][] dArray2, double[] dArray3) {
        int n;
        double d = 0.0;
        if (dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(dArray2);
        DoubleMatrix2D doubleMatrix2D = algebra.inverse(denseDoubleMatrix2D);
        double[] dArray4 = new double[dArray.length];
        for (n = 0; n < dArray.length; ++n) {
            d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += (dArray3[i] - dArray[i]) * doubleMatrix2D.getQuick(i, n);
            }
            dArray4[n] = d;
        }
        d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray4[n] * (dArray3[n] - dArray[n]);
        }
        return Math.exp(-0.5 * d) / Math.sqrt(Math.pow(Math.PI * 2, dArray.length) * algebra.det(denseDoubleMatrix2D));
    }

    public int getDimension() {
        return this.dim;
    }

    public static double[] getMean(double[] dArray, double[][] dArray2) {
        if (dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        return dArray;
    }

    public static double[][] getCovariance(double[] dArray, double[][] dArray2) {
        if (dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        return dArray2;
    }

    private static double[][] getCorrelation_(double[] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[dArray.length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray3[i][j] = -dArray2[i][j] / Math.sqrt(dArray2[i][i] * dArray2[j][j]);
            }
            dArray3[i][i] = 1.0;
        }
        return dArray3;
    }

    public static double[][] getCorrelation(double[] dArray, double[][] dArray2) {
        if (dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        return MultiNormalDist.getCorrelation_(dArray, dArray2);
    }

    public static double[] getMaximumLikelihoodEstimateMu(double[][] dArray, int n, int n2) {
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        double[] dArray2 = new double[n2];
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = 0.0;
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                int n4 = i;
                dArray2[n4] = dArray2[n4] + dArray[n3][i];
            }
        }
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray2[n3] = dArray2[n3] / (double)n;
        }
        return dArray2;
    }

    public static double[][] getMaximumLikelihoodEstimateSigma(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        double d = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        double[] dArray2 = MultiNormalDist.getMaximumLikelihoodEstimateMu(dArray, n, n2);
        double[][] dArray3 = new double[n2][n2];
        for (n4 = 0; n4 < dArray3.length; ++n4) {
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                dArray3[n4][n3] = 0.0;
            }
        }
        for (n4 = 0; n4 < dArray3.length; ++n4) {
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += (dArray[i][n4] - dArray2[n4]) * (dArray[i][n3] - dArray2[n3]);
                }
                dArray3[n4][n3] = d / (double)n;
            }
        }
        return dArray3;
    }

    public double[] getMu() {
        return this.mu;
    }

    public double getMu(int n) {
        return this.mu[n];
    }

    public double[][] getSigma() {
        return this.sigma.toArray();
    }

    public void setParams(double[] dArray, double[][] dArray2) {
        if (dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException("sigma must be a square matrix");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("mu and sigma must have the same dimension");
        }
        this.mu = new double[dArray.length];
        this.dimension = dArray.length;
        System.arraycopy(dArray, 0, this.mu, 0, dArray.length);
        this.sigma = new DenseDoubleMatrix2D(dArray2);
        this.invSigma = null;
    }
}

