/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;

public class UniformIntDist
extends DiscreteDistributionInt {
    private int i;
    private int j;

    public UniformIntDist(int n, int n2) {
        this.setParams(n, n2);
    }

    public double prob(int n) {
        return UniformIntDist.prob(this.i, this.j, n);
    }

    public double cdf(int n) {
        return UniformIntDist.cdf(this.i, this.j, n);
    }

    public double barF(int n) {
        return UniformIntDist.barF(this.i, this.j, n);
    }

    public int inverseFInt(double d) {
        return UniformIntDist.inverseF(this.i, this.j, d);
    }

    public double getMean() {
        return UniformIntDist.getMean(this.i, this.j);
    }

    public double getVariance() {
        return UniformIntDist.getVariance(this.i, this.j);
    }

    public double getStandardDeviation() {
        return UniformIntDist.getStandardDeviation(this.i, this.j);
    }

    public static double prob(int n, int n2, int n3) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        if (n3 < n || n3 > n2) {
            return 0.0;
        }
        return 1.0 / ((double)(n2 - n) + 1.0);
    }

    public static double cdf(int n, int n2, int n3) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        if (n3 < n) {
            return 0.0;
        }
        if (n3 >= n2) {
            return 1.0;
        }
        return (double)(n3 - n + 1) / ((double)(n2 - n) + 1.0);
    }

    public static double barF(int n, int n2, int n3) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        if (n3 <= n) {
            return 1.0;
        }
        if (n3 > n2) {
            return 0.0;
        }
        return ((double)(n2 - n3) + 1.0) / ((double)(n2 - n) + 1.0);
    }

    public static int inverseF(int n, int n2, double d) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d <= 0.0) {
            return n;
        }
        if (d >= 1.0) {
            return n2;
        }
        return n + (int)(d * (double)(n2 - n + 1));
    }

    public static UniformIntDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = UniformIntDist.getMaximumLikelihoodEstimate(nArray, n);
        return new UniformIntDist((int)dArray[0], (int)dArray[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray = new double[]{2.147483647E9, -2.147483648E9};
        for (int i = 0; i < n; ++i) {
            if ((double)nArray[i] < dArray[0]) {
                dArray[0] = nArray[i];
            }
            if (!((double)nArray[i] > dArray[1])) continue;
            dArray[1] = nArray[i];
        }
        return dArray;
    }

    public static double getMean(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        return (double)(n + n2) / 2.0;
    }

    public static double getVariance(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        return (((double)(n2 - n) + 1.0) * ((double)(n2 - n) + 1.0) - 1.0) / 12.0;
    }

    public static double getStandardDeviation(int n, int n2) {
        return Math.sqrt(UniformIntDist.getVariance(n, n2));
    }

    public int getI() {
        return this.i;
    }

    public int getJ() {
        return this.j;
    }

    public void setParams(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("j < i");
        }
        this.i = n;
        this.j = n2;
    }
}

