/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.Num;

public class StudentDist
extends ContinuousDistribution {
    private int n;
    private double factor;
    private static final int STUDENT_N1 = 20;
    private static final double STUDENT_X1 = 8.01;
    private static final int STUDENT_KMAX = 200;
    private static final double STUDENT_EPS = 5.0E-17;
    private static double[] W = new double[5];

    public StudentDist(int n) {
        this.setN(n);
    }

    public double density(double d) {
        return this.factor * Math.pow(1.0 + d * d / (double)this.n, -((double)this.n + 1.0) / 2.0);
    }

    public double cdf(double d) {
        return StudentDist.cdf(this.n, d);
    }

    public double inverseF(double d) {
        return StudentDist.inverseF(this.n, d);
    }

    public double getMean() {
        return StudentDist.getMean(this.n);
    }

    public double getVariance() {
        return StudentDist.getVariance(this.n);
    }

    public double getStandardDeviation() {
        return StudentDist.getStandardDeviation(this.n);
    }

    public static double density(int n, double d) {
        double d2 = Math.exp(Num.lnGamma((double)(n + 1) / 2.0) - Num.lnGamma((double)n / 2.0)) / Math.sqrt((double)n * Math.PI);
        return d2 * Math.pow(1.0 + d * d / (double)n, -((double)n + 1.0) / 2.0);
    }

    public static double cdf(int n, double d) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return 0.5 + Math.atan(d) / Math.PI;
        }
        if (n == 2) {
            double d2 = 1.0 + d * d / 2.0;
            return 0.5 + d * Math.sqrt(d2) / (2.0 * d2 * 1.4142135623730951);
        }
        if (d <= -1000.0) {
            return 0.0;
        }
        if (d >= 1000.0) {
            return 1.0;
        }
        if (n <= 20 && d <= 8.01) {
            double d3 = 1.0 + d * d / (double)n;
            double d4 = d / Math.sqrt(n);
            double d5 = 1.0;
            for (int i = n - 2; i >= 2; i -= 2) {
                d5 = 1.0 + d5 * ((double)i - 1.0) / ((double)i * d3);
            }
            if (n % 2 == 0) {
                return (1.0 + d5 * d4 / Math.sqrt(d3)) / 2.0;
            }
            return 0.5 + (Math.atan(d4) + d5 * d4 / d3) / Math.PI;
        }
        if (d < 8.01) {
            double d6 = (double)n - 0.5;
            double d7 = 48.0 * d6 * d6;
            double d8 = d6 * Num.log1p(d * d / (double)n);
            double d9 = Math.sqrt(d8);
            double d10 = (((((64.0 * d8 + 788.0) * d8 + 9801.0) * d8 + 89775.0) * d8 + 543375.0) * d8 + 1788885.0) * d9 / (210.0 * d7 * d7 * d7);
            d10 -= (((4.0 * d8 + 33.0) * d8 + 240.0) * d8 + 855.0) * d9 / (10.0 * d7 * d7);
            d10 += d9 + (d8 + 3.0) * d9 / d7;
            if (d >= 0.0) {
                return NormalDist.barF01(-d10);
            }
            return NormalDist.barF01(d10);
        }
        double d11 = 1.0 + d * d / (double)n;
        double d12 = Num.lnGamma((double)(n + 1) / 2.0) - Num.lnGamma((double)n / 2.0);
        d12 = Math.exp(d12);
        d12 *= 1.0 / (Math.sqrt(Math.PI * (double)n) * Math.pow(d11, (double)(n + 1) / 2.0));
        double d13 = (d12 *= 2.0 * Math.sqrt((double)n * d11)) / (double)n;
        double d14 = 10.0;
        double d15 = 10.0;
        for (n2 = 2; n2 < 200 && d14 > 5.0E-17; n2 += 2) {
            d14 = Math.abs((d13 += (d12 *= (double)(n2 - 1) / ((double)n2 * d11)) / (double)(n + n2)) - d15);
            d15 = d13;
        }
        if (n2 >= 200) {
            System.err.println("student: k >= STUDENT_KMAX");
        }
        if (d >= 0.0) {
            return 1.0 - d13 / 2.0;
        }
        return d13 / 2.0;
    }

    public static double cdf2(int n, int n2, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("student2:   d <= 0");
        }
        if (d >= 0.0) {
            return 0.5 * (1.0 + BetaDist.cdf(0.5, 0.5 * (double)n, n2, d * d / ((double)n + d * d)));
        }
        return 0.5 * BetaDist.cdf(0.5 * (double)n, 0.5, n2, (double)n / ((double)n + d * d));
    }

    public static double barF(int n, double d) {
        return 1.0 - StudentDist.cdf(n, d);
    }

    public static double inverseF(int n, double d) {
        if (n < 1) {
            throw new IllegalArgumentException("Calling student with n < 1");
        }
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("Calling student with u < 0 or u > 1");
        }
        if (n == 1) {
            double d2 = Math.PI * (1.0 - d);
            if (Math.sin(d2) > 1.0E-31) {
                return Math.cos(d2) / Math.sin(d2);
            }
            return Math.cos(d2) / 1.0E-31;
        }
        if (n == 2) {
            double d3 = d <= 0.5 ? 2.0 * d : 2.0 * (1.0 - d);
            if (d3 <= 1.0E-31) {
                d3 = 1.0E-31;
            }
            double d4 = Math.sqrt(2.0 / (d3 * (2.0 - d3)) - 2.0);
            if (d <= 0.5) {
                return -d4;
            }
            return d4;
        }
        if (d <= 1.0E-31 || 1.0 - d <= 1.0E-31) {
            double d5 = 1.0E31;
            if (d < 0.5) {
                return -d5;
            }
            return d5;
        }
        double d6 = d * 2.0;
        double d7 = d6 < 2.0 - d6 ? d6 : 2.0 - d6;
        StudentDist.W[2] = 1.0 / ((double)n - 0.5);
        StudentDist.W[1] = 48.0 / (W[2] * W[2]);
        StudentDist.W[3] = ((20700.0 * W[2] / W[1] - 98.0) * W[2] - 16.0) * W[2] + 96.36;
        StudentDist.W[4] = ((94.5 / (W[1] + W[3]) - 3.0) / W[1] + 1.0) * Math.sqrt(W[2] * 1.5707963268) * (double)n;
        double d8 = W[4] * d7;
        double d9 = W[3];
        double d10 = Math.pow(d8, 2.0 / (double)n);
        if (d10 <= 0.05 + W[2]) {
            double d11 = ((double)n + 6.0) / ((double)n + d10) - 0.089 * W[4] - 0.822;
            d11 = d11 * ((double)n + 2.0) * 3.0;
            d11 = (1.0 / d11 + 0.5 / ((double)n + 4.0)) * d10 - 1.0;
            d11 = d11 * ((double)n + 1.0) / ((double)n + 2.0);
            d10 = d11 + 1.0 / d10;
        } else {
            d8 = NormalDist.inverseF01(d7 * 0.5);
            d10 = d8 * d8;
            if ((double)n < 5.0) {
                d9 += 0.3 * ((double)n - 4.5) * (d8 + 0.6);
            }
            d9 = (((0.05 * W[4] * d8 - 5.0) * d8 - 7.0) * d8 - 2.0) * d8 + W[1] + d9;
            d10 = (((((0.4 * d10 + 6.3) * d10 + 36.0) * d10 + 94.5) / d9 - d10 - 3.0) / W[1] + 1.0) * d8;
            d10 = (d10 = W[2] * d10 * d10) <= 0.002 ? 0.5 * d10 * d10 + d10 : Math.exp(d10) - 1.0;
        }
        double d12 = Math.sqrt((double)n * d10);
        if (d < 0.5) {
            return -d12;
        }
        return d12;
    }

    public static StudentDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = StudentDist.getMaximumLikelihoodEstimate(dArray, n);
        return new StudentDist((int)dArray2[0]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        double d;
        double d2 = 0.0;
        double[] dArray2 = new double[1];
        if (n <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i] * dArray[i];
        }
        Function function = new Function(dArray, n);
        double d4 = Math.round(2.0 * (d3 /= (double)n) / (d3 - 1.0));
        double d5 = d = function.evaluate(d4);
        double d6 = function.evaluate(d4 + 1.0);
        double d7 = function.evaluate(d4 - 1.0);
        dArray2[0] = d4;
        if (d7 > d) {
            double d8 = d4 - 1.0;
            while (true) {
                double d9;
                double d10 = function.evaluate(d8);
                if (d9 > d5 && d8 >= 1.0) {
                    d5 = d10;
                    dArray2[0] = d8;
                    d8 -= 1.0;
                    continue;
                }
                break;
            }
        } else if (d6 > d) {
            double d11 = d4 + 1.0;
            while (true) {
                double d12;
                double d13 = function.evaluate(d11);
                if (!(d12 > d5)) break;
                d5 = d13;
                dArray2[0] = d11;
                d11 += 1.0;
            }
        }
        return dArray2;
    }

    public static double getMean(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        return 0.0;
    }

    public static double getVariance(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("n <= 2");
        }
        return (double)n / ((double)n - 2.0);
    }

    public static double getStandardDeviation(int n) {
        return Math.sqrt(StudentDist.getVariance(n));
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.factor = Math.exp(Num.lnGamma((double)(n + 1) / 2.0) - Num.lnGamma((double)n / 2.0)) / Math.sqrt((double)n * Math.PI);
    }

    private static class Function
    implements MathFunction {
        private int n;
        private double[] xi;

        public Function(double[] dArray, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(dArray, 0, this.xi, 0, n);
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            if (d <= 0.0) {
                return 1.0E200;
            }
            for (int i = 0; i < this.n; ++i) {
                d2 += Math.log(StudentDist.density((int)Math.round(d), this.xi[i]));
            }
            return d2;
        }
    }
}

