/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class NegativeBinomialDist
extends DiscreteDistributionInt {
    protected double gamma;
    protected double p;
    public static double MAXN = 100000.0;

    protected NegativeBinomialDist() {
    }

    public NegativeBinomialDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double prob(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            if (n > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return NegativeBinomialDist.prob(this.gamma, this.p, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return NegativeBinomialDist.prob(this.gamma, this.p, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.p >= 1.0) {
            return 1.0;
        }
        if (this.p <= 0.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (n >= this.xmax) {
                return 1.0;
            }
            if (n < this.xmin) {
                return NegativeBinomialDist.cdf(this.gamma, this.p, n);
            }
            if (n <= this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n + 1 - this.xmin];
        }
        return NegativeBinomialDist.cdf(this.gamma, this.p, n);
    }

    public double barF(int n) {
        if (n < 1) {
            return 1.0;
        }
        if (this.p >= 1.0) {
            return 0.0;
        }
        if (this.p <= 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return BetaDist.barF(this.gamma, n, 15, this.p);
        }
        if (n > this.xmax) {
            return BetaDist.barF(this.gamma, n, 15, this.p);
        }
        if (n <= this.xmin) {
            return 1.0;
        }
        if (n > this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n - 1 - this.xmin];
    }

    public int inverseFInt(double d) {
        if (this.cdf == null) {
            return NegativeBinomialDist.inverseF(this.gamma, this.p, d);
        }
        return super.inverseFInt(d);
    }

    public double getMean() {
        return NegativeBinomialDist.getMean(this.gamma, this.p);
    }

    public double getVariance() {
        return NegativeBinomialDist.getVariance(this.gamma, this.p);
    }

    public double getStandardDeviation() {
        return NegativeBinomialDist.getStandardDeviation(this.gamma, this.p);
    }

    public static double prob(double d, double d2, int n) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0.0");
        }
        if (n < 0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            if (n == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        double d3 = Num.lnGamma(d + (double)n) - (Num.lnFactorial(n) + Num.lnGamma(d)) + d * Math.log(d2) + (double)n * Num.log1p(-d2);
        if (d3 >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        if (d3 <= -708.3964185322641) {
            return 0.0;
        }
        return Math.exp(d3);
    }

    public static double cdf(double d, double d2, int n) {
        double d3 = DiscreteDistributionInt.EPSILON;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0.0");
        }
        if (n < 0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            return 1.0;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        int n2 = 1 + (int)Math.floor((d * (1.0 - d2) - 1.0) / d2);
        if (n2 > n) {
            n2 = n;
        }
        if (n2 <= 100000) {
            int n3;
            double d4;
            double d5 = d4 = NegativeBinomialDist.prob(d, d2, n2);
            double d6 = d4;
            for (n3 = n2; n3 > 0 && !((d5 *= (double)n3 / ((1.0 - d2) * (d + (double)n3 - 1.0))) < d3); --n3) {
                d6 += d5;
            }
            d5 = d4;
            for (n3 = n2; n3 < n && !((d5 *= (1.0 - d2) * (d + (double)n3) / (double)(n3 + 1)) < d3); ++n3) {
                d6 += d5;
            }
            if (d6 <= 1.0) {
                return d6;
            }
            return 1.0;
        }
        return BetaDist.cdf(d, (double)n + 1.0, 15, d2);
    }

    public static int inverseF(double d, double d2, double d3) {
        double d4;
        if (d3 < 0.0 || d3 >= 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        if (d2 >= 1.0) {
            return 0;
        }
        if (d2 <= 0.0) {
            return 0;
        }
        int n = 0;
        int n2 = 1 + (int)Math.floor((d * (1.0 - d2) - 1.0) / d2);
        double d5 = d4 = NegativeBinomialDist.prob(d, d2, n2);
        double d6 = d4;
        for (int i = n2; i > 0 && !((d5 *= (double)i / ((1.0 - d2) * (d + (double)i - 1.0))) < EPSILON); --i) {
            d6 += d5;
        }
        d5 = d4;
        n = n2;
        if (d6 < d3) {
            while (d6 < d3 && !((d5 *= (1.0 - d2) * (d + (double)n) / (double)(n + 1)) < EPSILON)) {
                d6 += d5;
                ++n;
            }
        } else {
            while (d6 >= d3 && !((d5 *= (double)n / ((1.0 - d2) * (d + (double)n - 1.0))) < EPSILON)) {
                d6 -= d5;
                --n;
            }
            ++n;
        }
        return n;
    }

    public static NegativeBinomialDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = NegativeBinomialDist.getMaximumLikelihoodEstimate(nArray, n);
        return new NegativeBinomialDist(dArray[0], dArray[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n<= 0");
        }
        int n2 = 0;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        double d = (double)n2 / (double)n;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += ((double)nArray[i] - d) * ((double)nArray[i] - d);
        }
        d2 /= (double)n;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if (nArray[j] <= i) continue;
                ++n4;
            }
            nArray2[i] = n4;
        }
        double d3 = d / d2 - 0.1;
        if (d3 <= 0.0) {
            d3 = 1.0E-15;
        }
        double[] dArray = new double[2];
        Function function = new Function(n, n3, d, nArray2);
        dArray[1] = RootFinder.brentDekker(d3, d3 + 0.2, function, 1.0E-5);
        if (dArray[1] >= 1.0) {
            dArray[1] = 0.999999999999999;
        }
        dArray[0] = dArray[1] * d / (1.0 - dArray[1]);
        return dArray;
    }

    public static double getMean(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return d * (1.0 - d2) / d2;
    }

    public static double getVariance(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        return d * (1.0 - d2) / (d2 * d2);
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(NegativeBinomialDist.getVariance(d, d2));
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getP() {
        return this.p;
    }

    public void setParams(double d, double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("gamma <= 0");
        }
        this.gamma = d;
        this.p = d2;
        int n = 1 + (int)Math.floor((d * (1.0 - d2) - 1.0) / d2);
        if ((double)n < 0.0 || (double)n > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int n2 = (int)(d * (1.0 - d2) / d2 + 16.0 * Math.sqrt(d * (1.0 - d2) / (d2 * d2)));
        if (n2 < 32) {
            n2 = 32;
        }
        double[] dArray = new double[1 + n2];
        double[] dArray2 = new double[1 + n2];
        double d3 = EPSILON / NegativeBinomialDist.prob(d, d2, n);
        dArray[n] = 1.0;
        double d4 = 1.0;
        int n3 = n;
        while (n3 > 0 && dArray[n3] >= d3) {
            dArray[n3 - 1] = dArray[n3] * (double)n3 / ((1.0 - d2) * (d + (double)n3 - 1.0));
            d4 += dArray[--n3];
        }
        int n4 = n3;
        n3 = n;
        while (dArray[n3] >= d3) {
            dArray[n3 + 1] = dArray[n3] * (1.0 - d2) * (d + (double)n3) / (double)(n3 + 1);
            d4 += dArray[++n3];
            if (n3 != n2 - 1) continue;
            double[] dArray3 = new double[1 + (n2 *= 2)];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            dArray = dArray3;
            dArray3 = new double[1 + n2];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            dArray2 = dArray3;
        }
        int n5 = n3;
        n3 = n4;
        while (n3 <= n5) {
            int n6 = n3++;
            dArray[n6] = dArray[n6] / d4;
        }
        dArray2[n4] = dArray[n4];
        n3 = n4;
        while (n3 < n5 && dArray2[n3] < 0.5) {
            dArray2[++n3] = dArray2[n3 - 1] + dArray[n3];
        }
        this.xmed = n3;
        dArray2[n5] = dArray[n5];
        n3 = n5 - 1;
        do {
            dArray2[n3] = dArray[n3] + dArray2[n3 + 1];
        } while (--n3 > this.xmed);
        this.xmin = n4;
        this.xmax = n5;
        this.pdf = new double[n5 + 1 - n4];
        this.cdf = new double[n5 + 1 - n4];
        System.arraycopy(dArray, n4, this.pdf, 0, n5 + 1 - n4);
        System.arraycopy(dArray2, n4, this.cdf, 0, n5 + 1 - n4);
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int max;
        protected double mean;
        protected int[] Fj;

        public Function(int n, int n2, double d, int[] nArray) {
            this.m = n;
            this.max = n2;
            this.mean = d;
            this.Fj = new int[nArray.length];
            System.arraycopy(nArray, 0, this.Fj, 0, nArray.length);
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            double d3 = d * this.mean / (1.0 - d);
            for (int i = 0; i < this.max; ++i) {
                d2 += (double)this.Fj[i] / (d3 + (double)i);
            }
            return d2 + (double)this.m * Math.log(d);
        }
    }
}

