/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Lmder_fcn;
import optimization.Minpack_f77;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class LogisticDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;

    public LogisticDist() {
        this.setParams(0.0, 1.0);
    }

    public LogisticDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return LogisticDist.density(this.alpha, this.lambda, d);
    }

    public double cdf(double d) {
        return LogisticDist.cdf(this.alpha, this.lambda, d);
    }

    public double barF(double d) {
        return LogisticDist.barF(this.alpha, this.lambda, d);
    }

    public double inverseF(double d) {
        return LogisticDist.inverseF(this.alpha, this.lambda, d);
    }

    public double getMean() {
        return LogisticDist.getMean(this.alpha, this.lambda);
    }

    public double getVariance() {
        return LogisticDist.getVariance(this.alpha, this.lambda);
    }

    public double getStandardDeviation() {
        return LogisticDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double d, double d2, double d3) {
        double d4 = 1.0 + Math.exp(-d2 * (d3 - d));
        return d2 * Math.exp(-d2 * (d3 - d)) / (d4 * d4);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= d - 1000.0 / d2) {
            return 0.0;
        }
        if (d3 >= d + 1000.0 / d2) {
            return 1.0;
        }
        return 1.0 / (1.0 + Math.exp(-d2 * (d3 - d)));
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= d - 1000.0 / d2) {
            return 1.0;
        }
        if (d3 >= d + 1000.0 / d2) {
            return 0.0;
        }
        return 1.0 / (1.0 + Math.exp(d2 * (d3 - d)));
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d3 >= 1.0) {
            return d + 1000.0 / d2;
        }
        if (d3 <= 0.0) {
            return d - 1000.0 / d2;
        }
        return Math.log(d3 / (1.0 - d3)) / d2 + d;
    }

    public static LogisticDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = LogisticDist.getMaximumLikelihoodEstimate(dArray, n);
        return new LogisticDist(dArray2[0], dArray2[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        double[] dArray2 = new double[3];
        dArray2[1] = d / (double)n;
        d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (dArray[i] - dArray2[1]) * (dArray[i] - dArray2[1]);
        }
        dArray2[2] = Math.sqrt(Math.PI * Math.PI * (double)n / (3.0 * d));
        double[] dArray3 = new double[3];
        double[][] dArray4 = new double[3][3];
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[3];
        Optim optim = new Optim(dArray, n);
        Minpack_f77.lmder1_f77((Lmder_fcn)optim, (int)2, (int)2, (double[])dArray2, (double[])dArray3, (double[][])dArray4, (double)1.0E-5, (int[])nArray2, (int[])nArray3);
        double[] dArray5 = new double[]{dArray2[1], dArray2[2]};
        return dArray5;
    }

    public static double getMean(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d;
    }

    public static double getVariance(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 3.289868133696453 * (1.0 / (d2 * d2));
    }

    public static double getStandardDeviation(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(0.3333333333333333) * Math.PI / d2;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
    }

    private static class Optim
    implements Lmder_fcn {
        protected double[] xi;
        protected int n;

        public Optim(double[] dArray, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(dArray, 0, this.xi, 0, n);
        }

        public void fcn(int n, int n2, double[] dArray, double[] dArray2, double[][] dArray3, int[] nArray) {
            if (nArray[1] == 1) {
                int n3;
                double d = 0.0;
                for (n3 = 0; n3 < n2; ++n3) {
                    d += 1.0 / (1.0 + Math.exp(dArray[2] * (this.xi[n3] - dArray[1])));
                }
                dArray2[1] = d - (double)n2 / 2.0;
                d = 0.0;
                for (n3 = 0; n3 < n2; ++n3) {
                    double d2 = dArray[2] * (this.xi[n3] - dArray[1]);
                    d += d2 * ((1.0 - Math.exp(d2)) / (1.0 + Math.exp(d2)));
                }
                dArray2[2] = d - (double)n2;
            } else if (nArray[1] == 2) {
                double d;
                int n4;
                double d3 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    d = Math.exp(dArray[2] * (this.xi[n4] - dArray[1]));
                    d3 -= dArray[2] * d / ((1.0 + d) * (1.0 + d));
                }
                dArray3[1][1] = d3;
                d3 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    d = Math.exp(dArray[2] * (this.xi[n4] - dArray[1]));
                    d3 -= (this.xi[n4] - dArray[1]) * d / ((1.0 + d) * (1.0 + d));
                }
                dArray3[1][2] = d3;
                d3 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    d = Math.exp(dArray[2] * (this.xi[n4] - dArray[1]));
                    d3 -= dArray[2] * (-1.0 + d * d - 2.0 * (dArray[2] * (this.xi[n4] - dArray[1])) * d) / ((1.0 + d) * (1.0 + d));
                }
                dArray3[2][1] = d3;
                d3 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    d = Math.exp(dArray[2] * (this.xi[n4] - dArray[1]));
                    d3 -= (dArray[1] - this.xi[1]) * (-1.0 + d * d - 2.0 * (dArray[2] * (this.xi[n4] - dArray[1])) * d) / ((1.0 + d) * (1.0 + d));
                }
                dArray3[2][2] = d3;
            }
        }
    }
}

