/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.GammaDist;

public class ErlangDist
extends GammaDist {
    public ErlangDist(int n) {
        super(n);
    }

    public ErlangDist(int n, double d) {
        super(n, d);
    }

    public static double density(int n, double d, double d2) {
        return ErlangDist.density(n, d, d2);
    }

    public static double cdf(int n, double d, int n2, double d2) {
        return ErlangDist.cdf(n, n2, d * d2);
    }

    public static double barF(int n, double d, int n2, double d2) {
        return ErlangDist.barF(n, n2, d * d2);
    }

    public static double inverseF(int n, double d, int n2, double d2) {
        return ErlangDist.inverseF(n, d, n2, d2);
    }

    public static ErlangDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = ErlangDist.getMaximumLikelihoodEstimate(dArray, n);
        return new ErlangDist((int)dArray2[0], dArray2[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        double[] dArray2 = GammaDist.getMaximumLikelihoodEstimate(dArray, n);
        dArray2[0] = Math.round(dArray2[0]);
        return dArray2;
    }

    public static double getMean(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return (double)n / d;
    }

    public static double getVariance(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return (double)n / (d * d);
    }

    public static double getStandardDeviation(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("k <= 0");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(n) / d;
    }

    public int getK() {
        return (int)this.getAlpha();
    }

    public void setParams(int n, double d, int n2) {
        this.setParams(n, d, n2);
    }
}

