/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public class DiscreteDistribution
implements Distribution {
    protected double[] cdf = null;
    protected double[] pr = null;
    protected int xmin = 0;
    protected int xmax = 0;
    protected int xmed = 0;
    protected int nObs;
    protected int nObsTot;
    protected double[] obs;
    protected double[] sortedObs;

    protected DiscreteDistribution() {
    }

    public DiscreteDistribution(int n, double[] dArray, double[] dArray2) {
        int n2 = dArray.length;
        int n3 = dArray2.length;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n2 < n - 1 || n3 < n - 1) {
            throw new IllegalArgumentException("Size of arrays 'obs' or 'prob' less than 'n'");
        }
        this.nObs = n;
        this.obs = dArray;
        this.pr = dArray2;
        this.sortedObs = new double[this.nObs];
        System.arraycopy(dArray, 0, this.sortedObs, 0, this.nObs);
        this.cdf = new double[this.nObs];
        this.cdf[0] = this.pr[0];
        this.cdf[this.nObs - 1] = this.pr[this.nObs - 1];
        this.xmin = 0;
        this.xmax = this.nObs - 1;
        int n4 = 0;
        while (n4 < this.xmax && this.cdf[n4] < 0.5) {
            this.cdf[++n4] = this.pr[n4] + this.cdf[n4 - 1];
        }
        this.xmed = n4;
        for (n4 = this.nObs - 2; n4 > this.xmed; --n4) {
            this.cdf[n4] = this.pr[n4] + this.cdf[n4 + 1];
        }
    }

    public double prob(int n) {
        return this.pr[n];
    }

    public double cdf(double d) {
        if (d < this.sortedObs[0]) {
            return 0.0;
        }
        if (d >= this.sortedObs[this.nObs - 1]) {
            return 1.0;
        }
        if (this.xmax == this.xmed || d < this.sortedObs[this.xmed + 1]) {
            for (int i = 0; i <= this.xmed; ++i) {
                if (!(d >= this.sortedObs[i]) || !(d < this.sortedObs[i + 1])) continue;
                return this.cdf[i];
            }
        } else {
            for (int i = this.xmed + 1; i < this.nObs - 1; ++i) {
                if (!(d >= this.sortedObs[i]) || !(d < this.sortedObs[i + 1])) continue;
                return 1.0 - this.cdf[i + 1];
            }
        }
        throw new IllegalStateException();
    }

    public double barF(double d) {
        if (d <= this.sortedObs[0]) {
            return 1.0;
        }
        if (d > this.sortedObs[this.nObs - 1]) {
            return 0.0;
        }
        if (this.xmax == this.xmed || d <= this.sortedObs[this.xmed + 1]) {
            for (int i = 0; i <= this.xmed; ++i) {
                if (!(d > this.sortedObs[i]) || !(d <= this.sortedObs[i + 1])) continue;
                return 1.0 - this.cdf[i];
            }
        } else {
            for (int i = this.xmed + 1; i < this.nObs - 1; ++i) {
                if (!(d > this.sortedObs[i]) || !(d <= this.sortedObs[i + 1])) continue;
                return this.cdf[i + 1];
            }
        }
        throw new IllegalStateException();
    }

    public double inverseF(double d) {
        int n;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d <= this.cdf[this.xmed - this.xmin]) {
            if (d <= this.cdf[0]) {
                return this.sortedObs[this.xmin];
            }
            n = 0;
            int n2 = this.xmed - this.xmin;
            while (n < n2) {
                int n3 = (n + n2) / 2;
                if (d > this.cdf[n3]) {
                    n = n3 + 1;
                    continue;
                }
                n2 = n3;
            }
        } else {
            if ((d = 1.0 - d) < this.cdf[this.xmax - this.xmin]) {
                return this.sortedObs[this.xmax];
            }
            n = this.xmed - this.xmin + 1;
            int n4 = this.xmax - this.xmin;
            while (n < n4) {
                int n5 = (n + n4) / 2;
                if (d < this.cdf[n5]) {
                    n = n5 + 1;
                    continue;
                }
                n4 = n5;
            }
            --n;
        }
        return this.sortedObs[n + this.xmin];
    }

    public double getMean() {
        double d = 0.0;
        for (int i = 0; i < this.nObs; ++i) {
            d += this.obs[i] * this.pr[i];
        }
        return d;
    }

    public double getVariance() {
        double d = 0.0;
        double d2 = this.getMean();
        for (int i = 0; i < this.nObs; ++i) {
            d += (this.obs[i] - d2) * (this.obs[i] - d2) * this.pr[i];
        }
        return d / (double)this.nObs;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }
}

