/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.Num;

public class ChiDist
extends ContinuousDistribution {
    private int nu;

    public ChiDist(int n) {
        this.setNu(n);
    }

    public double density(double d) {
        return ChiDist.density(this.nu, d);
    }

    public double cdf(double d) {
        return ChiDist.cdf(this.nu, d);
    }

    public double barF(double d) {
        return ChiDist.barF(this.nu, d);
    }

    public double inverseF(double d) {
        return ChiDist.inverseF(this.nu, d);
    }

    public double getMean() {
        return ChiDist.getMean(this.nu);
    }

    public double getVariance() {
        return ChiDist.getVariance(this.nu);
    }

    public double getStandardDeviation() {
        return ChiDist.getStandardDeviation(this.nu);
    }

    public static double density(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        return Math.exp((double)(n - 1) * Math.log(d) - d * d / 2.0 - ((double)n / 2.0 - 1.0) * 0.6931471805599453 - Num.lnGamma((double)n / 2.0));
    }

    public static double cdf(int n, double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return GammaDist.cdf((double)n / 2.0, 15, d * d / 2.0);
    }

    public static double barF(int n, double d) {
        if (d <= 0.0) {
            return 1.0;
        }
        return GammaDist.barF((double)n / 2.0, 15, d * d / 2.0);
    }

    public static double inverseF(int n, double d) {
        double d2 = GammaDist.inverseF((double)n / 2.0, 15, d);
        return Math.sqrt(2.0 * d2);
    }

    public static ChiDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = ChiDist.getMaximumLikelihoodEstimate(dArray, n);
        return new ChiDist((int)dArray2[0]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        double[] dArray2 = new double[1];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        d /= (double)n;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        double d3 = (double)Math.round((d2 /= (double)n) + d * d) - 5.0;
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 += Math.log(dArray[i]);
        }
        Function function = new Function(d4, n);
        while (function.evaluate(d3) > 0.0) {
            d3 += 1.0;
        }
        dArray2[0] = d3;
        return dArray2;
    }

    public static double getMean(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        return 1.4142135623730951 * Math.exp(Num.lnGamma((double)(n + 1) / 2.0)) / Math.exp(Num.lnGamma((double)n / 2.0));
    }

    public static double getVariance(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        double d = ChiDist.getMean(n);
        return (double)n - d * d;
    }

    public static double getStandardDeviation(int n) {
        return Math.sqrt(ChiDist.getVariance(n));
    }

    public int getNu() {
        return this.nu;
    }

    public void setNu(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        this.nu = n;
        this.supportA = 0.0;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double sum;

        public Function(double d, int n) {
            this.n = n;
            this.sum = d;
        }

        public double evaluate(double d) {
            return this.sum + (double)this.n * (Num.lnGamma(d / 2.0) - 0.34657359027997264 - Num.lnGamma((d + 1.0) / 2.0));
        }
    }
}

