/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.PoissonDist;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class BinomialDist
extends DiscreteDistributionInt {
    private int n;
    private double p;
    private double q;
    public static double MAXN = 100000.0;

    public BinomialDist(int n, double d) {
        this.setBinomial(n, d);
    }

    public double prob(int n) {
        if (this.n == 0) {
            return 1.0;
        }
        if (n < 0 || n > this.n) {
            return 0.0;
        }
        if (this.p == 0.0) {
            if (n > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.q == 0.0) {
            if (n < this.n) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return BinomialDist.prob(this.n, this.p, this.q, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return BinomialDist.prob(this.n, this.p, this.q, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (this.p < 0.0 || this.p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (this.n == 0) {
            return 1.0;
        }
        if (n < 0) {
            return 0.0;
        }
        if (n >= this.n) {
            return 1.0;
        }
        if (this.p == 0.0) {
            return 1.0;
        }
        if (this.p == 1.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (n >= this.xmax) {
                return 1.0;
            }
            if (n < this.xmin) {
                double d;
                double d2 = d = this.prob(n);
                double d3 = (1.0 - this.p) / this.p;
                int n2 = n;
                while (n2 > 0 && n2 >= n - 20) {
                    d2 += (d *= d3 * (double)(--n2) / (double)(this.n - n2 + 1));
                }
                return d2;
            }
            if (n <= this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n + 1 - this.xmin];
        }
        return BinomialDist.cdf(this.n, this.p, n);
    }

    public double barF(int n) {
        if (this.p < 0.0 || this.p > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (this.n == 0) {
            return 1.0;
        }
        if (n < 1) {
            return 1.0;
        }
        if (n > this.n) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            return 1.0;
        }
        if (this.cdf != null) {
            if (n > this.xmax) {
                double d;
                double d2 = 1.0 - this.p;
                double d3 = d = this.prob(n);
                double d4 = this.p / d2;
                for (int i = n; i < this.n && i < n + 20; ++i) {
                    d = d * d4 * (double)(this.n - i) / (double)(i + 1);
                    d3 += d;
                }
                return d3;
            }
            if (n <= this.xmin) {
                return 1.0;
            }
            if (n > this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n - 1 - this.xmin];
        }
        return 1.0 - BinomialDist.cdf(this.n, this.p, n);
    }

    public int inverseFInt(double d) {
        if (this.cdf == null) {
            return BinomialDist.inverseF(this.n, this.p, d);
        }
        return super.inverseFInt(d);
    }

    public double getMean() {
        return BinomialDist.getMean(this.n, this.p);
    }

    public double getVariance() {
        return BinomialDist.getVariance(this.n, this.p);
    }

    public double getStandardDeviation() {
        return BinomialDist.getStandardDeviation(this.n, this.p);
    }

    public static double prob(int n, double d, int n2) {
        return BinomialDist.prob(n, d, 1.0 - d, n2);
    }

    public static double prob(int n, double d, double d2, int n2) {
        double d3;
        int n3 = 1;
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return 1.0;
        }
        if (n2 < 0 || n2 > n) {
            return 0.0;
        }
        if (n2 > n / 2) {
            n2 = n - n2;
            d3 = d;
            d = d2;
            d2 = d3;
        }
        if (d < 0.0) {
            d = -d;
            if ((n2 & 1) != 0) {
                n3 *= -1;
            }
        }
        if (d2 < 0.0) {
            d2 = -d2;
            if ((n - n2 & 1) != 0) {
                n3 *= -1;
            }
        }
        if (n2 <= 15) {
            d3 = Math.pow(d, n2) * Num.combination(n, n2) * Math.pow(d2, n - n2);
            return (double)n3 * d3;
        }
        d3 = (double)n2 * Math.log(d) + (double)(n - n2) * Math.log(d2) + Num.lnFactorial(n) - Num.lnFactorial(n - n2) - Num.lnFactorial(n2);
        if (d3 >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        if (d3 < -708.3964185322641) {
            return 0.0;
        }
        return (double)n3 * Math.exp(d3);
    }

    public static double cdf(int n, double d, int n2) {
        double d2 = DiscreteDistributionInt.EPSILON * 0.01;
        double d3 = 1.0 - d;
        boolean bl = false;
        if (d < 0.0 | d > 1.0) {
            throw new IllegalArgumentException("p not in [0,1]");
        }
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return 1.0;
        }
        if (n2 < 0) {
            return 0.0;
        }
        if (n2 >= n) {
            return 1.0;
        }
        if (d <= 0.0) {
            return 1.0;
        }
        if (d >= 1.0) {
            return 0.0;
        }
        if (n < 10000) {
            double d4;
            int n3 = (int)((double)(n + 1) * d);
            if (n3 > n2) {
                n3 = n2;
            }
            double d5 = d4 = BinomialDist.prob(n, d, 1.0 - d, n3);
            double d6 = d4;
            double d7 = d3 / d;
            int n4 = n3;
            while (d5 >= EPSILON || n4 >= n3 - 20) {
                d6 += (d5 *= d7 * (double)n4 / (double)(n - n4 + 1));
                if (--n4 != 0) continue;
            }
            d7 = d / d3;
            d5 = d4;
            for (n4 = n3; n4 < n2 && !((d5 *= d7 * (double)(n - n4) / (double)(n4 + 1)) < EPSILON); ++n4) {
                d6 += d5;
            }
            return d6;
        }
        if (d > 0.5 || d == 0.5 && n2 > n / 2) {
            d = d3;
            d3 = 1.0 - d;
            bl = true;
            n2 = n - n2 - 1;
        }
        if ((double)n * d * d3 > 100.0) {
            double d8 = Math.pow((double)(n2 + 1) * d3 / ((double)(n - n2) * d), 0.3333333333333333);
            double d9 = d8 * (9.0 - 1.0 / (double)(n2 + 1)) - 9.0 + 1.0 / (double)(n - n2);
            double d10 = 3.0 * Math.sqrt(d8 * d8 / (double)(n2 + 1) + 1.0 / (double)(n - n2));
            d9 /= d10;
            if (bl) {
                return NormalDist.barF01(d9);
            }
            return NormalDist.cdf01(d9);
        }
        double d11 = (double)(2 * n - n2) * d / (2.0 - d);
        double d12 = (2.0 * d11 * d11 - (double)n2 * d11 - (double)(n2 * n2) - (double)(2 * n2)) / (double)(6 * (2 * n - n2) * (2 * n - n2));
        d12 = d11 / (1.0 - d12);
        if (bl) {
            return PoissonDist.barF(d12, n2 - 1);
        }
        return PoissonDist.cdf(d12, n2);
    }

    public static int inverseF(int n, double d, double d2) {
        double d3;
        int n2;
        double d4 = 1.0 - d;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (n < 10000) {
            double d5;
            int n3;
            int n4 = n3 = (int)((double)(n + 1) * d);
            double d6 = d5 = BinomialDist.prob(n, d, n4);
            double d7 = d5;
            double d8 = d4 / d;
            for (n4 = n3; n4 > 0 && !((d6 *= d8 * (double)n4 / (double)(n - n4 + 1)) < EPSILON); --n4) {
                d7 += d6;
            }
            if (d7 >= d2) {
                for (n4 = n3; d7 >= d2 && n4 >= 0; --n4) {
                    d8 = d4 / d;
                    d7 -= d5;
                    d5 *= d8 * (double)n4 / (double)(n - n4 + 1);
                }
                return n4 + 1;
            }
            while (d7 < d2 && n4 < n) {
                d8 = d / d4;
                d7 += (d5 *= d8 * (double)(n - n4) / (double)(n4 + 1));
                ++n4;
            }
            return n4;
        }
        for (n2 = 0; n2 <= n && !((d3 = BinomialDist.cdf(n, d, n2)) >= d2); ++n2) {
        }
        return n2;
    }

    public static BinomialDist getInstanceFromMLE(int[] nArray, int n) {
        double[] dArray = BinomialDist.getMaximumLikelihoodEstimate(nArray, n);
        return new BinomialDist((int)dArray[0], dArray[1]);
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n) {
        int n2;
        double[] dArray = new double[2];
        double d = 0.0;
        int n3 = Integer.MIN_VALUE;
        for (n2 = 0; n2 < n; ++n2) {
            d += (double)nArray[n2];
            if (nArray[n2] <= n3) continue;
            n3 = nArray[n2];
        }
        d /= (double)n;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = 0;
            for (n2 = 0; n2 < n; ++n2) {
                if (nArray[n2] <= i) continue;
                int n4 = i;
                nArray2[n4] = nArray2[n4] + 1;
            }
        }
        Function function = new Function(n, d, n3, nArray2);
        dArray[0] = RootFinder.brentDekker((double)n3 / 2.0, 2.0 * (double)n3, function, 1.0E-10);
        if (dArray[0] < (double)n3) {
            dArray[0] = n3;
        } else {
            int n5 = (int)Math.floor(dArray[0]) - 1;
            if (n5 < n3) {
                n5 = n3;
            }
            double d2 = Double.MAX_VALUE;
            for (n2 = n5; n2 <= n5 + 4; ++n2) {
                double d3 = Math.abs(function.evaluate(n2));
                if (!(d3 < d2)) continue;
                d2 = d3;
                dArray[0] = n2;
            }
        }
        dArray[1] = d / dArray[0];
        return dArray;
    }

    public static double[] getMaximumLikelihoodEstimate(int[] nArray, int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double[] dArray = new double[1];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i];
        }
        dArray[0] = (d /= (double)n) / (double)n2;
        return dArray;
    }

    public static double getMean(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        return (double)n * d;
    }

    public static double getVariance(int n, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        return (double)n * d * (1.0 - d);
    }

    public static double getStandardDeviation(int n, double d) {
        return Math.sqrt(BinomialDist.getVariance(n, d));
    }

    private void setBinomial(int n, double d) {
        int n2;
        double d2 = DiscreteDistributionInt.EPSILON * 0.01;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in range (0, 1)");
        }
        double d3 = 1.0 - d;
        double d4 = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.p = d;
        this.q = d3;
        if ((double)n > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        double[] dArray = new double[1 + n];
        double[] dArray2 = new double[1 + n];
        int n3 = (int)((double)(n + 1) * Math.abs(d) / (Math.abs(d) + Math.abs(d3)));
        if (n3 > n) {
            n3 = n;
        }
        dArray[n3] = BinomialDist.prob(n, d, d3, n3);
        if (d != 0.0 || d != -0.0) {
            d4 = d3 / d;
        }
        for (n2 = n3; n2 > 0 && Math.abs(dArray[n2]) > d2; --n2) {
            dArray[n2 - 1] = dArray[n2] * d4 * (double)n2 / (double)(n - n2 + 1);
        }
        int n4 = n2;
        if (d3 != 0.0 || d3 != -0.0) {
            d4 = d / d3;
        }
        for (n2 = n3; n2 < n && Math.abs(dArray[n2]) > d2; ++n2) {
            dArray[n2 + 1] = dArray[n2] * d4 * (double)(n - n2) / (double)(n2 + 1);
        }
        int n5 = n2;
        dArray2[n4] = dArray[n4];
        n2 = n4;
        while (n2 < n && dArray2[n2] < 0.5) {
            dArray2[++n2] = dArray2[n2 - 1] + dArray[n2];
        }
        this.xmed = n2;
        dArray2[n5] = dArray[n5];
        for (n2 = n5 - 1; n2 > this.xmed; --n2) {
            dArray2[n2] = dArray[n2] + dArray2[n2 + 1];
        }
        for (n2 = n4; n2 < this.xmed && dArray2[n2] < DiscreteDistributionInt.EPSILON; ++n2) {
        }
        this.xmin = n4 = n2;
        for (n2 = n5; n2 > this.xmed && dArray2[n2] < DiscreteDistributionInt.EPSILON; --n2) {
        }
        this.xmax = n5 = n2;
        this.pdf = new double[n5 + 1 - n4];
        this.cdf = new double[n5 + 1 - n4];
        System.arraycopy(dArray, n4, this.pdf, 0, n5 + 1 - n4);
        System.arraycopy(dArray2, n4, this.cdf, 0, n5 + 1 - n4);
    }

    public int getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    public void setParams(int n, double d) {
        this.setBinomial(n, d);
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected int R;
        protected double mean;
        protected int[] f;

        public Function(int n, double d, int n2, int[] nArray) {
            this.n = n;
            this.mean = d;
            this.R = n2;
            this.f = new int[nArray.length];
            System.arraycopy(nArray, 0, this.f, 0, nArray.length);
        }

        public double evaluate(double d) {
            double d2 = 0.0;
            if (d < (double)this.R) {
                return 1.0E200;
            }
            for (int i = 0; i < this.R; ++i) {
                d2 += (double)this.f[i] / (d - (double)i);
            }
            return d2 + (double)this.n * Math.log(1.0 - this.mean / d);
        }
    }
}

