/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.MathFunction;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class BetaSymmetricalDist
extends BetaDist {
    private static final double PI_2 = 1.5707963267948966;
    private static final int MAXI = 11;
    private static final int MAXIB = 50;
    private static final int MAXJ = 2000;
    private static final double EPSSINGLE = 1.0E-5;
    private static final double EPSBETA = 1.0E-10;
    private static final double SQPI_2 = 0.886226925452758;
    private static final double LOG_SQPI_2 = -0.1207822376352453;
    private static final double ALIM1 = 100000.0;
    private static final double LOG2 = 0.6931471805599453;
    private static final double LOG4 = 1.3862943611198906;
    private static final double INV2PI = 0.6366197723675813;
    private double Ceta;
    private double logCeta;

    public BetaSymmetricalDist(double d) {
        super(d, d);
        this.setParams(d, 14);
    }

    public BetaSymmetricalDist(double d, int n) {
        super(d, d, n);
        this.setParams(d, n);
    }

    public double cdf(double d) {
        return BetaSymmetricalDist.calcCdf(this.alpha, d, this.decPrec, this.logFactor, this.logBeta, this.logCeta, this.Ceta);
    }

    public double inverseF(double d) {
        return BetaSymmetricalDist.calcInverseF(this.alpha, d, this.decPrec, this.logFactor, this.logBeta, this.logCeta, this.Ceta);
    }

    public static double density(double d, double d2) {
        return BetaSymmetricalDist.density(d, d, 0.0, 1.0, d2);
    }

    public static double cdf(double d, int n, double d2) {
        return BetaSymmetricalDist.calcCdf(d, d2, 14, Double.MIN_NORMAL, 0.0, 0.0, 0.0);
    }

    public static double barF(double d, int n, double d2) {
        return 1.0 - BetaSymmetricalDist.cdf(d, d, n, d2);
    }

    public static double inverseF(double d, double d2) {
        return BetaSymmetricalDist.calcInverseF(d, d2, 14, Double.MIN_NORMAL, 0.0, 0.0, 0.0);
    }

    private static double series1(double d, double d2, double d3) {
        double d4;
        double d5 = 1.0;
        double d6 = 1.0 / d;
        int n = 1;
        while ((d4 = (d5 *= d2 * ((double)n - d) / (double)n) / ((double)n + d)) > (d6 += d4) * d3 && ++n < 2000) {
        }
        return d6 * Math.pow(d2, d);
    }

    private static double series2(double d, double d2, double d3) {
        double d4;
        double d5 = 4.0 * d2 * d2;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = 1;
        while ((d4 = (d7 *= d5 * ((double)n - d) / (double)n) / (double)(2 * n + 1)) > (d6 += d4) * d3 && ++n < 2000) {
        }
        return d6 * d2;
    }

    private static double series3(double d, double d2, double d3) {
        double d4 = -d2 / (1.0 - d2);
        double d5 = 1.0;
        double d6 = 1.0;
        int n = 1;
        while (Math.abs(d5) > (d6 += (d5 *= d4 * ((double)n - d) / ((double)n + d))) * d3 && ++n < 2000) {
        }
        return d6 * d2;
    }

    private static double series4(double d, double d2, double d3) {
        double d4 = 4.0 * d2 * d2;
        double d5 = 1.0;
        double d6 = 1.0;
        int n = 1;
        while (d6 > (d5 += (d6 *= d4 * ((double)n + d - 0.5) / (0.5 + (double)n))) * d3 && ++n < 2000) {
        }
        return d5 * d2;
    }

    private static double Peizer(double d, double d2) {
        double d3 = 1.0 - d2;
        double d4 = Math.sqrt((1.0 - d3 * GammaDist.belog(2.0 * d2) - d2 * GammaDist.belog(2.0 * d3)) / ((2.0 * d - 0.8333333333333334) * d2 * d3)) * (2.0 * d2 - 1.0) * (d - 0.3333333333333333 + 0.025 / d);
        return NormalDist.cdf01(d4);
    }

    private static double inverse1(double d, double d2, int n) {
        double d3 = EPSARRAY[n];
        double d4 = Math.pow(d2 * d, 1.0 / d);
        double d5 = d * (1.0 - d) * d4 / (1.0 + d);
        if (d5 < d3) {
            return d4;
        }
        d4 = d2 * d / (1.0 + d5);
        double d6 = Math.pow(d4, 1.0 / d);
        int n2 = 0;
        do {
            ++n2;
            d4 = d6;
            double d7 = 1.0;
            double d8 = 1.0 / d;
            int n3 = 1;
            while ((d5 = (d7 *= d4 * ((double)n3 - d) / (double)n3) / ((double)n3 + d)) > (d8 += d5) * d3 && ++n3 < 2000) {
            }
            d5 = ((d8 *= Math.pow(d4, d)) - d2) * Math.pow(d4 * (1.0 - d4), 1.0 - d);
            d6 = d4 - d5;
        } while (Math.abs(d5) > d3 && n2 <= 11);
        return d6;
    }

    private static double inverse2(double d, double d2, int n) {
        double d3;
        double d4;
        double d5 = (1.0 - d) * d2 * d2 * 4.0 / 3.0;
        double d6 = EPSARRAY[n];
        if (d5 < d6) {
            return 0.5 - d2;
        }
        double d7 = d2 / (1.0 + d5);
        int n2 = 0;
        do {
            ++n2;
            d4 = d7;
            d3 = 4.0 * d4 * d4;
            double d8 = 1.0;
            double d9 = 1.0;
            int n3 = 1;
            while ((d5 = (d9 *= d3 * ((double)n3 - d) / (double)n3) / (double)(2 * n3 + 1)) > (d8 += d5) * d6 && ++n3 < 2000) {
            }
        } while (Math.abs((d7 = d4 - ((d8 *= d4) - d2) * Math.pow(1.0 - d3, 1.0 - d)) - d4) > d6 && n2 <= 11);
        return 0.5 - d7;
    }

    private static double bisect(double d, double d2, double d3, double d4, int n) {
        double d5;
        double d6 = EPSARRAY[n];
        if (d3 >= 0.5 || d3 > d4) {
            d3 = 0.0;
            d4 = 0.5;
        }
        double d7 = 0.5 * (d3 + d4);
        int n2 = 0;
        do {
            ++n2;
            double d8 = -d7 / (1.0 - d7);
            double d9 = 1.0;
            double d10 = 1.0;
            int n3 = 1;
            while (Math.abs(d9 / (d10 += (d9 *= d8 * ((double)n3 - d) / ((double)n3 + d)))) > d6 && ++n3 < 2000) {
            }
            d10 *= d7;
            d9 = Math.log(d7 * (1.0 - d7));
            d8 = d2 - (d - 1.0) * d9;
            if (d8 > Math.log(d10)) {
                d3 = d7;
                continue;
            }
            d4 = d7;
        } while (Math.abs((d5 = d7) - (d7 = 0.5 * (d3 + d4))) > d6 && n2 < 50);
        return d7;
    }

    private static double inverse3(double d, double d2, int n) {
        double d3 = 0.0;
        double d4 = 1.0E-5;
        double d5 = EPSARRAY[n];
        double d6 = d2 / d;
        double d7 = Math.exp(d6);
        double d8 = (Num.log1p(-d7) + d2) / d;
        double d9 = Math.exp(d8);
        double d10 = d9 >= 0.25 ? 0.497 : (d9 > 1.0E-6 ? (1.0 - Math.sqrt(1.0 - 4.0 * d9)) / 2.0 : d9);
        int n2 = 0;
        do {
            ++n2;
            if (d10 >= 0.5) {
                d10 = 0.497;
            }
            if (Math.abs(d6 = d2 - (d - 1.0) * (d3 = Math.log((d7 = d10) * (1.0 - d7)))) >= 709.782712893384) {
                d10 = 0.497;
                continue;
            }
            d6 = Math.exp(d6);
            d9 = -d7 / (1.0 - d7);
            d8 = 1.0;
            d3 = 1.0;
            int n3 = 1;
            while (Math.abs(d8 / (d3 += (d8 *= d9 * ((double)n3 - d) / ((double)n3 + d)))) > d4 && ++n3 < 2000) {
            }
            d8 = ((d3 *= d7) - d6) / d;
            d10 = d7 - d8;
            if (!(Math.abs(d8) < 3.2E-4)) continue;
            d4 = d5;
        } while (Math.abs(d10 - d7) > d3 * d5 && Math.abs(d10 - d7) > d5 && n2 <= 11);
        if (n2 >= 11 && Math.abs(d10 - d7) > 10.0 * d5) {
            return BetaSymmetricalDist.bisect(d, d2, 0.0, 0.5, n);
        }
        return d10;
    }

    private static double inverse4(double d, double d2, int n) {
        double d3;
        double d4;
        double d5 = 1.0E-5;
        double d6 = EPSARRAY[n];
        double d7 = Math.exp(d2);
        int n2 = 0;
        do {
            ++n2;
            d4 = d7;
            double d8 = 4.0 * d4 * d4;
            d3 = 1.0;
            double d9 = 1.0;
            int n3 = 1;
            while (d9 > (d3 += (d9 *= d8 * ((double)n3 + d - 0.5) / (0.5 + (double)n3))) * d5 && ++n3 < 2000) {
            }
            d9 = Num.log1p(-d8);
            d9 = (d3 *= d4 * (1.0 - d8)) - Math.exp(d2 - (d - 1.0) * d9);
            d7 = d4 - d9;
            if (!(Math.abs(d9) < 3.2E-4)) continue;
            d5 = d6;
        } while (Math.abs(d7 - d4) > d6 && Math.abs(d7 - d4) > d3 * d6 && n2 <= 11);
        return 0.5 - d7;
    }

    private static double PeizerInverse(double d, double d2) {
        double d3;
        double d4 = d - 0.3333333333333333 + 0.025 / d;
        double d5 = NormalDist.inverseF01(d2);
        double d6 = 0.5;
        double d7 = 1.0 - d6;
        int n = 0;
        do {
            ++n;
            double d8 = (2.0 * d - 0.8333333333333334) * d6 * d7;
            double d9 = 1.0 - d7 * GammaDist.belog(2.0 * d6) - d6 * GammaDist.belog(2.0 * d7);
            d3 = d6;
            d6 = 0.5 + 0.5 * d5 * Math.sqrt(d8 / d9) / d4;
            d7 = 1.0 - d6;
        } while (n <= 11 && Math.abs(d6 - d3) > 1.0E-10);
        return d6;
    }

    private static void CalcB4(double d, double[] dArray, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (d <= 1.0E-10) {
            d3 = 2.0 / d;
            d4 = Math.log(d3);
            d5 = d4 + (d - 1.0) * 1.3862943611198906;
        } else if (d <= 1.0) {
            double d6 = Num.lnGamma(d);
            d4 = 2.0 * d6 - Num.lnGamma(2.0 * d);
            d5 = d4 + (d - 1.0) * 1.3862943611198906;
            d3 = Math.exp(d4);
        } else if (d <= 10.0) {
            d5 = Num.lnGamma(d) - Num.lnGamma(0.5 + d) + -0.1207822376352453;
            d4 = d5 - (d - 1.0) * 1.3862943611198906;
        } else if (d <= 200.0) {
            double d7 = 1.0;
            double d8 = 1.0;
            int n = 1;
            while (d7 > d2 * d8) {
                d8 += (d7 *= ((double)n - 1.5) * ((double)n - 1.5) / ((double)n * (d + (double)n - 1.5)));
                ++n;
            }
            double d9 = 0.886226925452758 / Math.sqrt((d - 0.5) * d8);
            d5 = Math.log(d9);
            d4 = d5 - (d - 1.0) * 1.3862943611198906;
        } else {
            double d10 = 1.0 / (8.0 * d);
            double d11 = 1.0 + d10 * (-1.0 + d10 * (0.5 + d10 * (2.5 - d10 * (2.625 + 49.875 * d10))));
            d11 = 0.886226925452758 / (Math.sqrt(d) * d11);
            d5 = Math.log(d11);
            d4 = d5 - (d - 1.0) * 1.3862943611198906;
        }
        dArray[0] = d3;
        dArray[1] = d4;
        dArray[2] = d5;
    }

    private static double calcInverseF(double d, double d2, int n, double d3, double d4, double d5, double d6) {
        double d7;
        boolean bl;
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 > 1.0 || d2 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 == 1.0) {
            return 1.0;
        }
        if (d2 == 0.5) {
            return 0.5;
        }
        if (d == 1.0) {
            return d2;
        }
        if (d == 0.5) {
            double d8 = Math.sin(d2 * 1.5707963267948966);
            return d8 * d8;
        }
        if (d > 100000.0) {
            return BetaSymmetricalDist.PeizerInverse(d, d2);
        }
        if (d2 > 0.5) {
            bl = true;
            d2 = 1.0 - d2;
        } else {
            bl = false;
        }
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        if (d3 == Double.MIN_NORMAL) {
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            BetaSymmetricalDist.CalcB4(d, dArray, EPSARRAY[n]);
            d10 = dArray[0];
            d11 = dArray[1];
            d12 = dArray[2];
            d9 = Math.exp(d12);
        } else {
            d10 = 1.0 / Math.exp(d3);
            d11 = d4;
            d12 = d5;
            d9 = d6;
        }
        if (d <= 1.0) {
            double d13 = d9 * (0.5 - d2);
            d7 = d13 > 0.25 ? BetaSymmetricalDist.inverse1(d, d10 * d2, n) : BetaSymmetricalDist.inverse2(d, d13, n);
        } else if (d2 < 1.0 / (2.5 + 2.25 * Math.sqrt(d))) {
            double d14 = d11 + Math.log(d2 * d);
            d7 = BetaSymmetricalDist.inverse3(d, d14, n);
        } else {
            double d15 = d12 - 0.6931471805599453 + Num.log1p(-2.0 * d2);
            d7 = BetaSymmetricalDist.inverse4(d, d15, n);
        }
        if (bl) {
            return 1.0 - d7 - 2.220446049250313E-16;
        }
        return d7;
    }

    private static double calcCdf(double d, double d2, int n, double d3, double d4, double d5, double d6) {
        double d7;
        boolean bl;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = EPSARRAY[n];
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            return 1.0;
        }
        if (d2 == 0.5) {
            return 0.5;
        }
        if (d == 1.0) {
            return d2;
        }
        if (d == 0.5) {
            return 0.6366197723675813 * Math.asin(Math.sqrt(d2));
        }
        if (d > 100000.0) {
            return BetaSymmetricalDist.Peizer(d, d2);
        }
        if (d2 > 0.5) {
            d2 = 1.0 - d2;
            bl = true;
        } else {
            bl = false;
        }
        if (d3 == Double.MIN_NORMAL) {
            double[] dArray = new double[]{d11, d8, d9};
            BetaSymmetricalDist.CalcB4(d, dArray, d12);
            d11 = dArray[0];
            d8 = dArray[1];
            d9 = dArray[2];
            d10 = Math.exp(d9);
        } else {
            d11 = 1.0 / Math.exp(d3);
            d8 = d4;
            d9 = d5;
            d10 = d6;
        }
        if (d <= 1.0) {
            double d13;
            if (d2 > 0.25) {
                double d14 = -Math.log(d);
                d13 = d >= 1.0E-6 ? 0.25 + 0.005 * d14 : 0.13863 + 0.01235 * d14;
            } else {
                d13 = 0.25;
            }
            d7 = d2 <= d13 ? BetaSymmetricalDist.series1(d, d2, d12) / d11 : 0.5 - BetaSymmetricalDist.series2(d, 0.5 - d2, d12) / d10;
        } else {
            double d15 = d < 400.0 ? 0.5 - 0.9 / Math.sqrt(4.0 * d) : 0.5 - 1.0 / Math.sqrt(d);
            if (d15 < 0.25) {
                d15 = 0.25;
            }
            if (d2 <= d15) {
                double d16 = (d - 1.0) * Math.log(d2 * (1.0 - d2)) - d8;
                d7 = BetaSymmetricalDist.series3(d, d2, d12) * Math.exp(d16) / d;
            } else {
                double d17;
                double d18 = 0.5 - d2;
                if (d18 > 0.05) {
                    d17 = Math.log(1.0 - 4.0 * d18 * d18);
                } else {
                    d7 = 4.0 * d18 * d18;
                    d17 = -d7 * (1.0 + d7 * (0.5 + d7 * (0.3333333333333333 + d7 * (0.25 + d7 * (0.2 + d7 * (0.16666666666666666 + d7 * 1.0 / 7.0))))));
                }
                d17 = d * d17 - d9;
                d7 = 0.5 - BetaSymmetricalDist.series4(d, d18, d12) * Math.exp(d17);
            }
        }
        if (bl) {
            return 1.0 - d7;
        }
        return d7;
    }

    public double getMean() {
        return 0.5;
    }

    public double getVariance() {
        return BetaSymmetricalDist.getVariance(this.alpha);
    }

    public double getStandardDeviation() {
        return BetaSymmetricalDist.getStandardDeviation(this.alpha);
    }

    public static BetaSymmetricalDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = BetaSymmetricalDist.getMaximumLikelihoodEstimate(dArray, n);
        return new BetaSymmetricalDist(dArray2[0]);
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (dArray[i] - 0.5) * (dArray[i] - 0.5);
            d2 += Math.log(dArray[i] * (1.0 - dArray[i]));
        }
        d /= (double)n;
        Function function = new Function(d2, n);
        double[] dArray2 = new double[1];
        double d3 = (1.0 - 4.0 * d) / (8.0 * d);
        double d4 = d3 - 5.0;
        if (d4 <= 0.0) {
            d4 = 1.0E-15;
        }
        dArray2[0] = RootFinder.brentDekker(d4, d3 + 5.0, function, 1.0E-5);
        return dArray2;
    }

    public static double getMean(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        return 0.5;
    }

    public static double getVariance(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        return 1.0 / (8.0 * d + 4.0);
    }

    public static double getStandardDeviation(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        return 1.0 / Math.sqrt(8.0 * d + 4.0);
    }

    public void setParams(double d, double d2, double d3, double d4, int n) {
        if (d3 >= d4) {
            throw new IllegalArgumentException("a >= b");
        }
        this.decPrec = n;
        this.supportA = this.a = d3;
        this.supportB = this.b = d4;
        this.bminusa = d4 - d3;
    }

    private void setParams(double d, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        this.alpha = d;
        this.beta = d;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        BetaSymmetricalDist.CalcB4(d, dArray, EPSARRAY[n]);
        this.Beta = dArray[0];
        this.logBeta = dArray[1];
        this.logCeta = dArray[2];
        this.Ceta = Math.exp(this.logCeta);
        this.logFactor = this.Beta > 0.0 ? -this.logBeta - (2.0 * d - 1.0) * Math.log(this.bminusa) : 0.0;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double sum;

        public Function(double d, int n) {
            this.n = n;
            this.sum = d;
        }

        public double evaluate(double d) {
            return -2.0 * (double)this.n * Num.digamma(d) + (double)this.n * 2.0 * Num.digamma(2.0 * d) + this.sum;
        }
    }
}

