/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.markovchain;

import umontreal.iro.lecuyer.markovchain.MarkovChainComparable;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;

public abstract class MarkovChainDouble
extends MarkovChainComparable {
    protected double state;
    protected int step;

    public abstract double initialStateDouble();

    public void initialState() {
        this.step = 0;
        this.state = this.initialStateDouble();
    }

    public abstract double nextStepDouble(int var1, double var2, RandomStream var4);

    public void nextStep(RandomStream randomStream) {
        this.state = this.nextStepDouble(this.step, this.state, randomStream);
        ++this.step;
    }

    public abstract void initStats();

    public abstract double getPerformance(int var1);

    public double getPerformance() {
        return this.getPerformance(this.numSteps);
    }

    public int compareTo(Object object) {
        double d = ((MarkovChainDouble)object).state;
        return this.state < d ? -1 : (this.state > d ? 1 : 0);
    }

    public double simulStepsDouble(int n, RandomStream randomStream) {
        this.state = this.initialStateDouble();
        this.initStats();
        this.numSteps = n;
        for (int i = 0; i < n; ++i) {
            this.state = this.nextStepDouble(i, this.state, randomStream);
        }
        return this.state;
    }

    public void simulRuns(int n, int n2, RandomStream randomStream, Tally tally) {
        tally.init();
        for (int i = 0; i < n; ++i) {
            this.simulStepsDouble(n2, randomStream);
            tally.add(this.getPerformance(n2));
        }
    }

    public void simulRunsWithSubstreams(int n, int n2, RandomStream randomStream, Tally tally) {
        tally.init();
        randomStream.resetStartStream();
        for (int i = 0; i < n; ++i) {
            this.simulStepsDouble(n2, randomStream);
            tally.add(this.getPerformance(n2));
            randomStream.resetNextSubstream();
        }
    }
}

