/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.markovchain;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stat.Tally;
import umontreal.iro.lecuyer.util.Chrono;
import umontreal.iro.lecuyer.util.PrintfFormat;

public abstract class MarkovChain
implements Cloneable {
    Chrono timer = Chrono.createForSingleThread();
    int numSteps;

    public abstract void initialState();

    public abstract void nextStep(RandomStream var1);

    public abstract double getPerformance();

    public Object clone() throws CloneNotSupportedException {
        MarkovChain markovChain = null;
        try {
            markovChain = (MarkovChain)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("This MarkovChain cannot be cloned");
        }
        return markovChain;
    }

    public void simulSteps(int n, RandomStream randomStream) {
        this.initialState();
        this.numSteps = n;
        for (int i = 0; i < n; ++i) {
            this.nextStep(randomStream);
        }
    }

    public void simulRuns(int n, int n2, RandomStream randomStream, Tally tally) {
        tally.init();
        for (int i = 0; i < n; ++i) {
            this.simulSteps(n2, randomStream);
            tally.add(this.getPerformance());
        }
    }

    public void simulRunsWithSubstreams(int n, int n2, RandomStream randomStream, Tally tally) {
        tally.init();
        randomStream.resetStartStream();
        for (int i = 0; i < n; ++i) {
            this.simulSteps(n2, randomStream);
            tally.add(this.getPerformance());
            randomStream.resetNextSubstream();
        }
    }

    public void simulRQMC(PointSet pointSet, int n, int n2, RandomStream randomStream, Tally tally) {
        tally.init();
        Tally tally2 = new Tally();
        int n3 = pointSet.getNumPoints();
        PointSetIterator pointSetIterator = pointSet.iterator();
        for (int i = 0; i < n; ++i) {
            pointSet.randomize(randomStream);
            this.simulRunsWithSubstreams(n3, n2, pointSetIterator, tally2);
            tally.add(tally2.average());
        }
    }

    public String simulRunsFormat(int n, int n2, RandomStream randomStream, Tally tally) {
        this.timer.init();
        this.simulRuns(n, n2, randomStream, tally);
        StringBuffer stringBuffer = new StringBuffer("----------------------------------------------\n");
        stringBuffer.append("MC simulations:\n");
        stringBuffer.append(" Number of runs n          = " + n + "\n");
        stringBuffer.append(this.formatResults(tally));
        stringBuffer.append(" CPU Time = " + this.timer.format() + "\n");
        return stringBuffer.toString();
    }

    public String simulRunsWithSubstreamsFormat(int n, int n2, RandomStream randomStream, Tally tally) {
        this.timer.init();
        this.simulRunsWithSubstreams(n, n2, randomStream, tally);
        StringBuffer stringBuffer = new StringBuffer("----------------------------------------------\n");
        stringBuffer.append("MC simulations with substreams:\n");
        stringBuffer.append(" Number of runs n          = " + n + "\n");
        stringBuffer.append(this.formatResults(tally));
        stringBuffer.append(" CPU Time = " + this.timer.format() + "\n");
        return stringBuffer.toString();
    }

    public String simulRQMCFormat(PointSet pointSet, int n, int n2, RandomStream randomStream, Tally tally) {
        this.timer.init();
        this.simulRQMC(pointSet, n, n2, randomStream, tally);
        int n3 = pointSet.getNumPoints();
        StringBuffer stringBuffer = new StringBuffer("----------------------------------------------\n");
        stringBuffer.append("RQMC simulations:\n\n");
        stringBuffer.append(pointSet.toString());
        stringBuffer.append("\n Number of random shifts m = " + n + "\n");
        stringBuffer.append(" Number of points n        = " + n3 + "\n");
        stringBuffer.append(this.formatResultsRQMC(tally, n3));
        stringBuffer.append(" CPU Time = " + this.timer.format() + "\n");
        return stringBuffer.toString();
    }

    public String testImprovementRQMC(PointSet pointSet, int n, int n2, RandomStream randomStream, double d, Tally tally) {
        StringBuffer stringBuffer = new StringBuffer(this.simulRQMCFormat(pointSet, n, n2, randomStream, tally));
        double d2 = (double)pointSet.getNumPoints() * tally.variance();
        stringBuffer.append(" Variance ratio: " + PrintfFormat.format(15, 10, 4, d / d2) + "\n");
        return stringBuffer.toString();
    }

    public String formatResults(Tally tally) {
        StringBuffer stringBuffer = new StringBuffer(" Average value             = ");
        stringBuffer.append(PrintfFormat.format(12, 9, 5, tally.average()) + "\n");
        stringBuffer.append(" Variance                  = ");
        stringBuffer.append(PrintfFormat.format(12, 9, 5, tally.variance()) + "\n");
        stringBuffer.append(tally.formatConfidenceIntervalStudent(0.9, 7));
        return stringBuffer.toString();
    }

    public String formatResultsRQMC(Tally tally, int n) {
        StringBuffer stringBuffer = new StringBuffer(" Average value             = ");
        stringBuffer.append(PrintfFormat.format(12, 9, 5, tally.average()) + "\n");
        stringBuffer.append(" Variance * numPoints      = ");
        stringBuffer.append(PrintfFormat.format(12, 9, 5, (double)n * tally.variance()) + "\n");
        stringBuffer.append(tally.formatConfidenceIntervalStudent(0.9, 7));
        return stringBuffer.toString();
    }
}

