/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.markovchain;

import java.util.Arrays;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.markovchain.ArrayOfDoubleChains;
import umontreal.iro.lecuyer.markovchain.MarkovChainDoubleStop;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ArrayOfDoubleChainsStop
extends ArrayOfDoubleChains {
    MarkovChainDoubleStop baseChain;

    public ArrayOfDoubleChainsStop(MarkovChainDoubleStop markovChainDoubleStop) {
        super(markovChainDoubleStop);
        this.baseChain = markovChainDoubleStop;
    }

    public double simulArrayRQMC(PointSet pointSet, int n, RandomStream randomStream) {
        int n2;
        PointSetIterator pointSetIterator = pointSet.iterator();
        this.baseChain.initStats();
        this.baseChain.initialState();
        Arrays.fill(this.state, 0, this.n, this.baseChain.state);
        for (n2 = 0; n2 < this.n; ++n2) {
            this.state[n2] = this.baseChain.initialStateDouble();
        }
        for (int i = 0; this.state[0] < Double.POSITIVE_INFINITY && i < n; ++i) {
            pointSet.randomize(randomStream);
            pointSetIterator.resetStartStream();
            for (n2 = 0; n2 < this.n && this.state[n2] < Double.POSITIVE_INFINITY; ++n2) {
                this.state[n2] = this.baseChain.nextStepDouble(i, this.state[n2], pointSetIterator);
                pointSetIterator.resetNextSubstream();
            }
            Arrays.sort(this.state, 0, n2);
        }
        return this.baseChain.getPerformance() / (double)this.n;
    }
}

