/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import umontreal.iro.lecuyer.hups.DigitalSequenceBase2;

public class NiedXingSequenceBase2
extends DigitalSequenceBase2 {
    private static final int MAXDIM = 32;
    private static final int NUMCOLS = 30;
    private boolean isTrans = true;
    private static int[] NiedXingMat = new int[15660];
    private static int[] NiedXingMatTrans = new int[15660];
    private static final int MAXN = 15660;
    static /* synthetic */ Class class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2;

    public NiedXingSequenceBase2(int n, int n2, int n3) {
        this.init(n, n2, n2, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Niederreiter-Xing sequence:\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    private void init(int n, int n2, int n3, int n4) {
        if (n4 < 1 || n4 > 32) {
            throw new IllegalArgumentException("Dimension for NiedXingSequenceBase2 must be > 1 and <= 32");
        }
        if (n2 < n || n3 < n2 || n3 > 31 || n >= 31) {
            throw new IllegalArgumentException("One must have k < 31 and k <= r <= w <= 31 for NiedXingSequenceBase2");
        }
        this.numCols = n;
        this.numRows = n2;
        this.outDigits = n3;
        this.numPoints = 1 << n;
        this.dim = n4;
        this.normFactor = 1.0 / (double)(1L << this.outDigits);
        this.genMat = new int[n4 * this.numCols];
        this.initGenMat();
    }

    public void extendSequence(int n) {
        this.init(n, this.numRows, this.outDigits, this.dim);
    }

    private void initGenMat() {
        int n = this.dim <= 4 ? 0 : (this.dim * (this.dim - 1) / 2 - 6) * 30;
        if (this.isTrans) {
            for (int i = 0; i < this.dim; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    long l = NiedXingMatTrans[n + i * 30 + j];
                    this.genMat[i * this.numCols + j] = (int)((l <<= 1) >> 31 - this.outDigits);
                }
            }
        } else {
            for (int i = 0; i < this.dim; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    long l = NiedXingMat[n + i * 30 + j];
                    this.genMat[i * this.numCols + j] = (int)((l <<= 1) >> 31 - this.outDigits);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            InputStream inputStream = (class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2 == null ? (class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2 = NiedXingSequenceBase2.class$("umontreal.iro.lecuyer.hups.NiedXingSequenceBase2")) : class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2).getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataSer/Nieder/NiedXingSequenceBase2.ser");
            if (inputStream == null) {
                throw new FileNotFoundException("Cannot find NiedXingSequenceBase2.ser");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            NiedXingMat = (int[])objectInputStream.readObject();
            objectInputStream.close();
            inputStream = (class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2 == null ? (class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2 = NiedXingSequenceBase2.class$("umontreal.iro.lecuyer.hups.NiedXingSequenceBase2")) : class$umontreal$iro$lecuyer$hups$NiedXingSequenceBase2).getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataSer/Nieder/NiedXingSequenceBase2Trans.ser");
            if (inputStream == null) {
                throw new FileNotFoundException("Cannot find NiedXingSequenceBase2Trans.ser");
            }
            objectInputStream = new ObjectInputStream(inputStream);
            NiedXingMatTrans = (int[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
    }
}

