/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.scene2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.swing.base.ButtonNoFocus;
import uibk.mtk.swing.base.TitledPanel;

public class PanelMoveXAchse2D
extends TitledPanel
implements ActionListener {
    protected ButtonNoFocus buttonXup;
    protected ButtonNoFocus buttonXdown;
    MathPanel2D mathpanel2d;
    CoordinateRect2D limits = new CoordinateRect2D();
    private static final String BUNDLE_NAME = "uibk.mtk.swing.scene2d.messages";
    private static final String STRINDEPENDENTLY = Messages.getString("uibk.mtk.swing.scene2d.messages", "PanelMoveXAchse2D.2");
    Scene2D scene2d;

    public PanelMoveXAchse2D(MathPanel2D mathpanel2d) {
        super(STRINDEPENDENTLY);
        if (mathpanel2d == null) {
            throw new NullPointerException("MathPanel is null");
        }
        this.mathpanel2d = mathpanel2d;
        this.scene2d = mathpanel2d.getScene2d();
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 80));
        URL urlIconUp = this.getClass().getResource("/uibk/mtk/swing/res/arrowup.gif");
        URL urlIconDown = this.getClass().getResource("/uibk/mtk/swing/res/arrowdown.gif");
        this.buttonXup = new ButtonNoFocus(new ImageIcon(urlIconUp));
        this.buttonXdown = new ButtonNoFocus(new ImageIcon(urlIconDown));
        this.buttonXup.setActionCommand("xUp");
        this.buttonXdown.setActionCommand("xDown");
        this.buttonXup.addActionListener(this);
        this.buttonXdown.addActionListener(this);
        this.add((Component)this.buttonXup, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.buttonXdown, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.scene2d.setEnlargeEnable(true);
    }

    public void actionPerformed(ActionEvent ev) {
        double factor = this.scene2d.getYRange() / 10.0;
        double ymin = this.scene2d.getYmin();
        double ymax = this.scene2d.getYmax();
        if (ev.getActionCommand().equals("xUp")) {
            this.scene2d.enableRoundY(false);
            this.scene2d.setYInterval(new Interval(ymin - factor, ymax - factor));
        }
        if (ev.getActionCommand().equals("xDown")) {
            this.scene2d.enableRoundY(false);
            this.scene2d.setYInterval(new Interval(ymin + factor, ymax + factor));
        }
        this.mathpanel2d.repaint();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }
}

