/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import uibk.mtk.swing.datatable.MyAbstractTableModel;

public class TableModelWithRowIndex
extends MyAbstractTableModel {
    public static final String countername = "n  ";

    public TableModelWithRowIndex(double[][] data) {
        super(data);
    }

    public TableModelWithRowIndex(int rows, int cols) {
        super(rows, cols);
    }

    public int getColumnCount() {
        if (this.columnnames != null) {
            return this.columnnames.length + 1;
        }
        if (this.datagrid == null || this.datagrid.isEmpty()) {
            return 0;
        }
        return this.datagrid.getColumns() + 1;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return countername;
        }
        if (this.columnnames == null) {
            return "x" + columnIndex;
        }
        return this.columnnames[columnIndex - 1];
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return;
        }
        try {
            double d = Double.parseDouble(aValue.toString());
            this.datagrid.setValue(new Double(d), rowIndex, columnIndex - 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return String.valueOf(row + 1);
        }
        Object obj = this.datagrid.getValue(row, col - 1);
        if (obj == null) {
            return "";
        }
        return obj;
    }
}

