/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Reporter;
import uibk.mtk.lang.StandardOptions;
import uibk.mtk.swing.base.TitledPanel;
import uibk.mtk.swing.datatable.DataTable;

public class PannelFileIO
extends TitledPanel
implements ActionListener {
    private static final String BUNDLE_NAME = "uibk.mtk.swing.datatable.messages";
    private final DataTable table;
    private final Reporter reporter;
    private final Component parentComponent;
    private String path = "";

    public PannelFileIO(DataTable table, Reporter reporter, Component parentComponent) {
        super(Messages.getString(BUNDLE_NAME, "PanelFileIO.0"));
        this.table = table;
        this.reporter = reporter;
        this.parentComponent = parentComponent;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 120));
        JButton button = new JButton(Messages.getString(BUNDLE_NAME, "PanelFileIO.1"));
        button.setActionCommand("load");
        button.addActionListener(this);
        button.setPreferredSize(new Dimension(100, 23));
        this.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        button = new JButton(Messages.getString(BUNDLE_NAME, "PanelFileIO.2"));
        button.setActionCommand("save");
        button.addActionListener(this);
        button.setPreferredSize(new Dimension(100, 23));
        this.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand() == "load") {
                File file = this.fileChooser(Type.OPEN);
                if (file == null) {
                    this.reporter.report(Messages.getString(BUNDLE_NAME, "PanelFileIO.3"));
                    return;
                }
                this.path = file.getPath();
                this.readFile(file);
            } else if (event.getActionCommand() == "save") {
                File file = this.fileChooser(Type.SAVE);
                if (file == null) {
                    this.reporter.report(Messages.getString(BUNDLE_NAME, "PanelFileIO.3"));
                    return;
                }
                this.path = file.getPath();
                this.saveFile(file);
            }
        }
        catch (IOException e) {
            this.reporter.reportException("", e, this.parentComponent);
        }
    }

    private void readFile(File f) throws IOException {
        Vector<Double[]> data = new Vector<Double[]>();
        FileReader fR = new FileReader(f);
        BufferedReader bR = new BufferedReader(fR);
        String[] labels = this.getLabel(bR.readLine());
        String line = null;
        int row = 1;
        while ((line = bR.readLine()) != null) {
            ++row;
            try {
                line = line.replace('.', ',');
                Scanner s = new Scanner(line);
                Double[] dataLine = new Double[labels.length];
                int i = 0;
                while (s.hasNext()) {
                    dataLine[i++] = s.nextDouble();
                }
                if (i != labels.length) {
                    throw new IOException();
                }
                data.add(dataLine);
            }
            catch (Exception e) {
                throw new IOException(String.valueOf(Messages.getString(BUNDLE_NAME, "PanelFileIO.4")) + " " + row);
            }
        }
        if (data.size() == 0) {
            throw new IOException(Messages.getString(BUNDLE_NAME, "PanelFileIO.5"));
        }
        fR.close();
        bR.close();
        this.table.setData(data, labels);
        this.table.setColumnWidthFromLabels();
        this.reporter.report(Messages.getString(BUNDLE_NAME, "PanelFileIO.6"));
    }

    private String[] getLabel(String line) throws IOException {
        if (line == null) {
            throw new IOException(Messages.getString(BUNDLE_NAME, "PanelFileIO.7"));
        }
        Scanner s = new Scanner(line);
        int anz = 0;
        while (s.hasNext()) {
            s.next();
            ++anz;
        }
        if (anz < 1) {
            throw new IOException(Messages.getString(BUNDLE_NAME, "PanelFileIO.8"));
        }
        String[] label = new String[anz];
        s = new Scanner(line);
        int i = 0;
        while (s.hasNext()) {
            String var;
            String str = s.next();
            if (!str.contains(var = "x" + (i + 1))) {
                str = String.valueOf(str) + " [x" + (i + 1) + "]";
            }
            label[i++] = str;
        }
        return label;
    }

    private void saveFile(File f) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        Vector data = this.table.getDataVector();
        if (this.table.getLabel() == null || data == null || this.table.getLabel().length < 1 || data.size() < 1) {
            throw new IOException(Messages.getString(BUNDLE_NAME, "PanelFileIO.9"));
        }
        String[] label = new String[this.table.getLabel().length];
        if (!f.getName().contains(".")) {
            f = new File(String.valueOf(f.getPath()) + ".txt");
        }
        if (f.canRead()) {
            Object[] options = new Object[]{Messages.getString(BUNDLE_NAME, "PanelFileIO.13"), Messages.getString(BUNDLE_NAME, "PanelFileIO.14")};
            JOptionPane pane = new JOptionPane(String.valueOf(f.getName()) + " " + Messages.getString(BUNDLE_NAME, "PanelFileIO.10"), -1, 2);
            pane.setOptions(options);
            pane.setInitialValue(options[0]);
            pane.setBackground(StandardOptions.COMPONENTSCOLOR);
            URL url = this.getClass().getResource("/uibk/mtk/swing/res/windows-question.png");
            pane.setIcon(new ImageIcon(url));
            JDialog dialog = pane.createDialog(this.parentComponent, Messages.getString(BUNDLE_NAME, "PanelFileIO.11"));
            dialog.setVisible(true);
            Object selectedValue = pane.getValue();
            if (selectedValue == null) {
                throw new IOException(Messages.getString(BUNDLE_NAME, "PanelFileIO.3"));
            }
            if (selectedValue.equals(Messages.getString(BUNDLE_NAME, "PanelFileIO.14"))) {
                this.actionPerformed(new ActionEvent(this, 1, "save"));
            }
        }
        int[] max = new int[label.length];
        int i = 0;
        i = 0;
        while (i < label.length) {
            label[i] = this.table.getLabel()[i];
            if (label[i].contains(" [x" + (i + 1) + "]")) {
                label[i] = label[i].replace(" [x" + (i + 1) + "]", "");
            }
            max[i] = label[i].length();
            ++i;
        }
        for (Object[] line : data) {
            i = 0;
            objectArray = line;
            n2 = line.length;
            n = 0;
            while (n < n2) {
                Object db = objectArray[n];
                String out = "0";
                if (db != null) {
                    out = db.toString();
                }
                if (out.length() > max[i]) {
                    max[i] = out.length();
                }
                ++i;
                ++n;
            }
        }
        FileWriter writer = new FileWriter(f);
        BufferedWriter bwriter = new BufferedWriter(writer);
        i = 0;
        objectArray = label;
        n2 = label.length;
        n = 0;
        while (n < n2) {
            Object str = objectArray[n];
            bwriter.append((CharSequence)str);
            this.appendSpaces(bwriter, ((String)str).length(), max[i++]);
            ++n;
        }
        for (Object[] line : data) {
            bwriter.newLine();
            i = 0;
            Object[] objectArray2 = line;
            int n3 = line.length;
            int n4 = 0;
            while (n4 < n3) {
                Object db = objectArray2[n4];
                String out = "0";
                if (db != null) {
                    out = db.toString();
                }
                bwriter.append(out);
                this.appendSpaces(bwriter, out.length(), max[i++]);
                ++n4;
            }
        }
        bwriter.close();
        writer.close();
        this.reporter.report(Messages.getString(BUNDLE_NAME, "PanelFileIO.12"));
    }

    private void appendSpaces(BufferedWriter bwritter, int strLength, int max) throws IOException {
        int i = strLength;
        while (i < max + 5) {
            bwritter.append(' ');
            ++i;
        }
    }

    private File fileChooser(Type type) {
        JFileChooser d = new JFileChooser(this.path);
        d.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".txt");
            }

            public String getDescription() {
                return "*.txt;";
            }
        });
        int returnVal = -1;
        if (type == Type.OPEN) {
            returnVal = d.showOpenDialog(this.parentComponent);
        } else if (type == Type.SAVE) {
            returnVal = d.showSaveDialog(this.parentComponent);
        }
        d.setDialogType(1);
        if (returnVal == 0) {
            return d.getSelectedFile();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        OPEN,
        SAVE;

    }
}

