/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.datatable;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import uibk.mtk.swing.datatable.Datagrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyAbstractTableModel
extends AbstractTableModel {
    protected transient Datagrid datagrid = new Datagrid();
    protected String[] columnnames;
    protected boolean editable = true;

    public MyAbstractTableModel(double[][] data) {
        if (data != null) {
            this.setData(data);
        }
    }

    public void cleardata() {
        this.datagrid.clear();
    }

    public MyAbstractTableModel(int rows, int cols) {
        this.datagrid = new Datagrid(rows, cols);
    }

    public void create(int rows, int cols) {
        this.datagrid = new Datagrid(rows, cols);
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.datagrid.getRows();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setData(double[][] data) {
        this.cleardata();
        int m = data[0].length;
        int n = data.length;
        this.datagrid = new Datagrid(m, n);
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                this.datagrid.setValue(data[j][i], i, j);
                ++j;
            }
            ++i;
        }
        this.fireTableStructureChanged();
    }

    public void setData(Vector<Double[]> data) {
        this.cleardata();
        int m = data.size();
        int n = data.firstElement().length;
        this.datagrid = new Datagrid(m, n);
        this.datagrid.setValue(data);
        this.fireTableStructureChanged();
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public abstract String getColumnName(int var1);

    @Override
    public abstract void setValueAt(Object var1, int var2, int var3);

    public void setColumnNames(String[] columnnames) {
        this.columnnames = columnnames;
    }

    public String[] getColumnNames() {
        return this.columnnames;
    }
}

