/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.appletbase;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import uibk.mtk.exception.ExtendedException;
import uibk.mtk.lang.Messages;
import uibk.mtk.lang.Reporter;
import uibk.mtk.lang.StandardOptions;

public class ReportingLabel
extends JLabel
implements Reporter {
    private static final String BUNDLE_NAME = "uibk.mtk.swing.appletbase.messages";

    public void report(String message) {
        this.setForeground(Color.black);
        this.setText(message);
    }

    public ReportingLabel() {
    }

    public ReportingLabel(String text) {
        super(text);
    }

    public void reportError(Exception ex) {
        this.reportError(ex.getMessage());
    }

    public void reportError(String message, Component parentComponent) {
        message = this.reportError(message);
        if (parentComponent != null) {
            this.reportWithDialog(message, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-error.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.3"));
            this.setText(" ");
        }
    }

    public void reportWarning(String message, Component parentComponent) {
        message = this.reportError(message);
        if (parentComponent != null) {
            this.reportWithDialog(message, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-warning.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.5"));
            this.setText(" ");
        }
    }

    public void reportError(String title, Exception ex) {
        this.reportError(String.valueOf(title) + ": " + ex.getMessage());
    }

    public String reportError(String message) {
        if (message == null || message.equals("")) {
            message = Messages.getString(BUNDLE_NAME, "ReportingLabel.2");
        }
        this.setForeground(new Color(255, 51, 0));
        this.setText(message);
        return message;
    }

    public void reportSuccess(String message) {
        this.setForeground(Color.black);
        this.setText(message);
    }

    public void reportSuccess(String message, Component parentComponent) {
        this.reportSuccess(message);
        if (parentComponent != null) {
            this.reportWithDialog(message, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-info.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.6"));
        }
    }

    public void reportException(String message, Exception e, Component parentComponent) {
        String text = message != null && !message.equals("") ? String.valueOf(message) + ": " + e.getMessage() : e.getMessage();
        this.reportSuccess(text);
        if (parentComponent != null) {
            if (e instanceof ExtendedException) {
                ExtendedException ee = (ExtendedException)e;
                switch (ee.getLevel()) {
                    case INFO: {
                        this.reportWithDialog(text, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-info.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.6"));
                        break;
                    }
                    case WARNING: {
                        this.reportWithDialog(text, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-warning.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.5"));
                        break;
                    }
                    default: {
                        this.reportWithDialog(text, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-error.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.3"));
                        break;
                    }
                }
            } else {
                this.reportWithDialog(text, parentComponent, this.getClass().getResource("/uibk/mtk/swing/res/windows-error.png"), Messages.getString(BUNDLE_NAME, "ReportingLabel.3"));
            }
        }
    }

    private void reportWithDialog(String message, Component parentComponent, URL url, String typ) {
        Object[] options = new Object[]{Messages.getString(BUNDLE_NAME, "ReportingLabel.4")};
        JOptionPane pane = new JOptionPane(message, -1, 2);
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        pane.setBackground(StandardOptions.COMPONENTSCOLOR);
        pane.setIcon(new ImageIcon(url));
        JDialog dialog = pane.createDialog(parentComponent, typ);
        dialog.setVisible(true);
    }
}

